/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport;

import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslServer;
import org.apache.qpid.transport.Binary;
import org.apache.qpid.transport.ByteBufferSender;
import org.apache.qpid.transport.ConnectionClose;
import org.apache.qpid.transport.ConnectionCloseCode;
import org.apache.qpid.transport.ConnectionDelegate;
import org.apache.qpid.transport.ConnectionException;
import org.apache.qpid.transport.ConnectionInvoker;
import org.apache.qpid.transport.ConnectionListener;
import org.apache.qpid.transport.ConnectionSettings;
import org.apache.qpid.transport.ExceptionHandlingByteBufferReceiver;
import org.apache.qpid.transport.FrameSizeObserver;
import org.apache.qpid.transport.Method;
import org.apache.qpid.transport.Option;
import org.apache.qpid.transport.ProtocolEvent;
import org.apache.qpid.transport.ProtocolEventReceiver;
import org.apache.qpid.transport.ProtocolEventSender;
import org.apache.qpid.transport.ProtocolHeader;
import org.apache.qpid.transport.ProtocolVersionException;
import org.apache.qpid.transport.Session;
import org.apache.qpid.transport.SessionDetachCode;
import org.apache.qpid.transport.SessionDetached;
import org.apache.qpid.transport.network.Assembler;
import org.apache.qpid.transport.network.Disassembler;
import org.apache.qpid.transport.network.InputHandler;
import org.apache.qpid.transport.network.NetworkConnection;
import org.apache.qpid.transport.network.TransportActivity;
import org.apache.qpid.transport.network.io.IoNetworkTransport;
import org.apache.qpid.transport.network.security.SecurityLayer;
import org.apache.qpid.transport.network.security.SecurityLayerFactory;
import org.apache.qpid.transport.util.Waiter;
import org.apache.qpid.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Connection
extends ConnectionInvoker
implements ProtocolEventReceiver,
ProtocolEventSender {
    private static final Logger LOGGER = LoggerFactory.getLogger(Connection.class);
    public static final int MAX_CHANNEL_MAX = 65535;
    public static final int MIN_USABLE_CHANNEL_NUM = 0;
    private long _lastSendTime;
    private long _lastReadTime;
    private NetworkConnection _networkConnection;
    private FrameSizeObserver _frameSizeObserver;
    private boolean _messageCompressionSupported;
    private final AtomicBoolean _redirecting = new AtomicBoolean();
    private boolean _virtualHostPropertiesSupported;
    private boolean _queueLifetimePolicySupported;
    private static final SessionFactory DEFAULT_SESSION_FACTORY = new DefaultSessionFactory();
    private SessionFactory _sessionFactory = DEFAULT_SESSION_FACTORY;
    private ConnectionDelegate delegate;
    private ProtocolEventSender sender;
    private final Map<Binary, Session> sessions = new HashMap<Binary, Session>();
    private final Map<Integer, Session> channels = new ConcurrentHashMap<Integer, Session>();
    private State state = State.NEW;
    private final Object lock = new Object();
    private long timeout = 60000L;
    private List<ConnectionListener> listeners = new ArrayList<ConnectionListener>();
    private ConnectionException error = null;
    private int channelMax = 1;
    private String locale;
    private SaslServer saslServer;
    private SaslClient saslClient;
    private int idleTimeout = 0;
    private Map<String, Object> _serverProperties;
    private String userID;
    private ConnectionSettings conSettings;
    private SecurityLayer securityLayer;
    private final AtomicBoolean connectionLost = new AtomicBoolean(false);
    private SocketAddress _remoteAddress;
    private SocketAddress _localAddress;

    public void setConnectionDelegate(ConnectionDelegate delegate) {
        this.delegate = delegate;
    }

    public void addConnectionListener(ConnectionListener listener) {
        this.listeners.add(listener);
    }

    public List<ConnectionListener> getListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    public ProtocolEventSender getSender() {
        return this.sender;
    }

    public void setSender(ProtocolEventSender sender) {
        this.sender = sender;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setState(State state) {
        Object object = this.lock;
        synchronized (object) {
            this.state = state;
            this.lock.notifyAll();
        }
    }

    void setLocale(String locale) {
        this.locale = locale;
    }

    String getLocale() {
        return this.locale;
    }

    void setSaslServer(SaslServer saslServer) {
        this.saslServer = saslServer;
    }

    SaslServer getSaslServer() {
        return this.saslServer;
    }

    void setSaslClient(SaslClient saslClient) {
        this.saslClient = saslClient;
    }

    public SaslClient getSaslClient() {
        return this.saslClient;
    }

    public void connect(String host, int port, String vhost, String username, String password, boolean ssl, String saslMechs) {
        this.connect(host, port, vhost, username, password, ssl, saslMechs, null);
    }

    public void connect(String host, int port, String vhost, String username, String password, boolean ssl, String saslMechs, Map<String, Object> clientProps) {
        ConnectionSettings settings = new ConnectionSettings();
        settings.setHost(host);
        settings.setPort(port);
        settings.setVhost(vhost);
        settings.setUsername(username);
        settings.setPassword(password);
        settings.setUseSSL(ssl);
        settings.setSaslMechs(saslMechs);
        settings.setClientProperties(clientProps);
        this.connect(settings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(ConnectionSettings settings) {
        Object object = this.lock;
        synchronized (object) {
            this.conSettings = settings;
            this._redirecting.set(false);
            this.state = State.OPENING;
            this.userID = settings.getUsername();
            this.connectionLost.set(false);
            this.securityLayer = SecurityLayerFactory.newInstance(this.getConnectionSettings());
            IoNetworkTransport transport = new IoNetworkTransport();
            InputHandler inputHandler = new InputHandler(new Assembler(this), false);
            this.addFrameSizeObserver(inputHandler);
            ExceptionHandlingByteBufferReceiver secureReceiver = this.securityLayer.receiver(inputHandler);
            if (secureReceiver instanceof ConnectionListener) {
                this.addConnectionListener((ConnectionListener)((Object)secureReceiver));
            }
            this._networkConnection = transport.connect(settings, secureReceiver, new ConnectionActivity());
            this.setRemoteAddress(this._networkConnection.getRemoteAddress());
            this.setLocalAddress(this._networkConnection.getLocalAddress());
            ByteBufferSender secureSender = this.securityLayer.sender(this._networkConnection.getSender());
            if (secureSender instanceof ConnectionListener) {
                this.addConnectionListener((ConnectionListener)((Object)secureSender));
            }
            Disassembler disassembler = new Disassembler(secureSender, 4096);
            this.sender = disassembler;
            this.addFrameSizeObserver(disassembler);
            this.send(new ProtocolHeader(1, 0, 10));
            Waiter w = new Waiter(this.lock, this.timeout);
            while (w.hasTime() && (this.state == State.OPENING && this.error == null || this.isRedirecting())) {
                w.await();
            }
            if (this.error != null) {
                ConnectionException t;
                block15: {
                    t = this.error;
                    this.error = null;
                    try {
                        this.close();
                    }
                    catch (ConnectionException ce) {
                        if (t instanceof ProtocolVersionException) break block15;
                        throw ce;
                    }
                }
                t.rethrow();
            }
            switch (this.state) {
                case OPENING: {
                    this.close();
                    throw new ConnectionException("connect() timed out");
                }
                case OPEN: 
                case RESUMING: {
                    this.connectionLost.set(false);
                    break;
                }
                case CLOSED: {
                    throw new ConnectionException("connect() aborted");
                }
                default: {
                    throw new IllegalStateException(String.valueOf((Object)this.state));
                }
            }
        }
        for (ConnectionListener listener : this.listeners) {
            listener.opened(this);
        }
    }

    public Session createSession() {
        return this.createSession(0L);
    }

    public Session createSession(long expiry) {
        return this.createSession(expiry, false);
    }

    public Session createSession(long expiry, boolean isNoReplay) {
        return this.createSession(UUID.randomUUID().toString(), expiry, isNoReplay);
    }

    public Session createSession(String name) {
        return this.createSession(name, 0L);
    }

    public Session createSession(String name, long expiry) {
        return this.createSession(Strings.toUTF8(name), expiry);
    }

    public Session createSession(String name, long expiry, boolean isNoReplay) {
        return this.createSession(new Binary(Strings.toUTF8(name)), expiry, isNoReplay);
    }

    public Session createSession(byte[] name, long expiry) {
        return this.createSession(new Binary(name), expiry);
    }

    public Session createSession(Binary name, long expiry) {
        return this.createSession(name, expiry, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session createSession(Binary name, long expiry, boolean isNoReplay) {
        Object object = this.lock;
        synchronized (object) {
            Waiter w = new Waiter(this.lock, this.timeout);
            while (w.hasTime() && this.state != State.OPEN && this.error == null) {
                w.await();
            }
            if (this.state != State.OPEN) {
                throw new ConnectionException("Timed out waiting for connection to be ready. Current state is :" + (Object)((Object)this.state));
            }
            Session ssn = this._sessionFactory.newSession(this, name, expiry, isNoReplay);
            this.registerSession(ssn);
            this.map(ssn);
            ssn.attach();
            return ssn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSession(Session ssn) {
        Object object = this.lock;
        synchronized (object) {
            this.sessions.put(ssn.getName(), ssn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSession(Session ssn) {
        Object object = this.lock;
        synchronized (object) {
            this.sessions.remove(ssn.getName());
        }
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        assert (sessionFactory != null);
        this._sessionFactory = sessionFactory;
    }

    public ConnectionDelegate getConnectionDelegate() {
        return this.delegate;
    }

    @Override
    public void received(ProtocolEvent event) {
        this._lastReadTime = System.currentTimeMillis();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("RECV: [{}] {}", (Object)this, (Object)String.valueOf(event));
        }
        event.delegate(this, this.delegate);
    }

    @Override
    public void send(ProtocolEvent event) {
        ProtocolEventSender s;
        this._lastSendTime = System.currentTimeMillis();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("SEND: [{}] {}", (Object)this, (Object)String.valueOf(event));
        }
        if ((s = this.sender) == null) {
            throw new ConnectionException("connection closed");
        }
        s.send(event);
    }

    @Override
    public void flush() {
        ProtocolEventSender theSender;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("FLUSH: [{}]", (Object)this);
        }
        if ((theSender = this.sender) != null) {
            theSender.flush();
        }
    }

    @Override
    protected void invoke(Method method) {
        method.setChannel(0);
        this.send(method);
        if (!method.isBatch()) {
            this.flush();
        }
    }

    public void dispatch(Method method) {
        int channel = method.getChannel();
        Session ssn = this.getSession(channel);
        if (ssn != null) {
            ssn.received(method);
        } else {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Control received on unattached channel : {}", (Object)channel);
            }
            this.invokeSessionDetached(channel, SessionDetachCode.NOT_ATTACHED);
        }
    }

    public int getChannelMax() {
        return this.channelMax;
    }

    void setChannelMax(int max) {
        this.channelMax = max;
    }

    private int map(Session ssn) {
        Object object = this.lock;
        synchronized (object) {
            for (int i = 0; i < this.getChannelMax(); ++i) {
                if (this.channels.containsKey(i)) continue;
                this.map(ssn, i);
                return i;
            }
            throw new RuntimeException("no more channels available");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void map(Session ssn, int channel) {
        Object object = this.lock;
        synchronized (object) {
            this.channels.put(channel, ssn);
            ssn.setChannel(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unmap(Session ssn) {
        Object object = this.lock;
        synchronized (object) {
            this.channels.remove(ssn.getChannel());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session getSession(int channel) {
        Object object = this.lock;
        synchronized (object) {
            return this.channels.get(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        Object object = this.lock;
        synchronized (object) {
            for (Session ssn : this.sessions.values()) {
                this.map(ssn);
                ssn.resume();
            }
            this.setState(State.OPEN);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exception(ConnectionException e) {
        this.connectionLost.set(true);
        Object object = this.lock;
        synchronized (object) {
            switch (this.state) {
                case OPENING: 
                case CLOSING: {
                    this.error = e;
                    this.lock.notifyAll();
                    return;
                }
            }
        }
        for (ConnectionListener listener : this.listeners) {
            listener.exception(this, e);
        }
    }

    @Override
    public void exception(Throwable t) {
        this.exception(new ConnectionException(t));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeCode(ConnectionClose close) {
        Object object = this.lock;
        synchronized (object) {
            ConnectionCloseCode code = close.getReplyCode();
            if (code != ConnectionCloseCode.NORMAL) {
                this.exception(new ConnectionException(close));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closed() {
        if (this.state == State.OPEN) {
            this.exception(new ConnectionException("connection aborted"));
        }
        LOGGER.debug("connection closed: {}", (Object)this);
        Object object = this.lock;
        synchronized (object) {
            ArrayList<Session> values = new ArrayList<Session>(this.channels.values());
            for (Session ssn : values) {
                ssn.closed();
            }
            try {
                this.sender.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.sender = null;
            this.setState(State.CLOSED);
        }
        for (ConnectionListener listener : this.listeners) {
            listener.closed(this);
        }
    }

    @Override
    public void close() {
        this.close(ConnectionCloseCode.NORMAL, null, new Option[0]);
    }

    protected void sendConnectionClose(ConnectionCloseCode replyCode, String replyText, Option ... _options) {
        this.connectionClose(replyCode, replyText, _options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(ConnectionCloseCode replyCode, String replyText, Option ... _options) {
        Object object = this.lock;
        synchronized (object) {
            block2 : switch (this.state) {
                case OPEN: {
                    this.state = State.CLOSING;
                    this.connectionClose(replyCode, replyText, _options);
                    Waiter w = new Waiter(this.lock, this.timeout);
                    while (w.hasTime() && this.state == State.CLOSING && this.error == null) {
                        w.await();
                    }
                    if (this.error != null) {
                        this.close(replyCode, replyText, _options);
                        throw new ConnectionException(this.error);
                    }
                    switch (this.state) {
                        case CLOSING: {
                            this.close(replyCode, replyText, _options);
                            throw new ConnectionException("close() timed out");
                        }
                        case CLOSED: {
                            break block2;
                        }
                    }
                    throw new IllegalStateException(String.valueOf((Object)this.state));
                }
                case CLOSED: {
                    break;
                }
                default: {
                    if (this.sender == null) break;
                    this.sender.close();
                    Waiter w = new Waiter(this.lock, this.timeout);
                    while (w.hasTime() && this.sender != null && this.error == null) {
                        w.await();
                    }
                    if (this.error != null) {
                        throw new ConnectionException(this.error);
                    }
                    if (this.sender == null) break;
                    throw new ConnectionException("close() timed out");
                }
            }
        }
    }

    public String getUserID() {
        return this.userID;
    }

    public void setUserID(String id) {
        this.userID = id;
    }

    public void setServerProperties(Map<String, Object> serverProperties) {
        this._serverProperties = serverProperties == null ? Collections.emptyMap() : serverProperties;
        this._messageCompressionSupported = Boolean.parseBoolean(String.valueOf(this._serverProperties.get("qpid.message_compression_supported")));
        this._virtualHostPropertiesSupported = Boolean.parseBoolean(String.valueOf(this._serverProperties.get("qpid.virtualhost_properties_supported")));
        this._queueLifetimePolicySupported = Boolean.parseBoolean(String.valueOf(this._serverProperties.get("qpid.queue_lifetime_supported")));
    }

    public Map<String, Object> getServerProperties() {
        return this._serverProperties;
    }

    public String toString() {
        return String.format("conn:%x", System.identityHashCode(this));
    }

    public ConnectionSettings getConnectionSettings() {
        return this.conSettings;
    }

    public SecurityLayer getSecurityLayer() {
        return this.securityLayer;
    }

    public boolean isConnectionResuming() {
        return this.connectionLost.get();
    }

    protected boolean isConnectionLost() {
        return this.connectionLost.get();
    }

    protected Collection<? extends Session> getChannels() {
        return new ArrayList<Session>(this.channels.values());
    }

    public boolean hasSessionWithName(byte[] name) {
        return this.sessions.containsKey(new Binary(name));
    }

    public void notifyFailoverRequired() {
        for (Session session : this.getChannels()) {
            session.notifyFailoverRequired();
        }
    }

    public SocketAddress getRemoteSocketAddress() {
        return this._remoteAddress;
    }

    public SocketAddress getLocalAddress() {
        return this._localAddress;
    }

    protected void setRemoteAddress(SocketAddress remoteAddress) {
        this._remoteAddress = remoteAddress;
    }

    protected void setLocalAddress(SocketAddress localAddress) {
        this._localAddress = localAddress;
    }

    private void invokeSessionDetached(int channel, SessionDetachCode sessionDetachCode) {
        SessionDetached sessionDetached = new SessionDetached();
        sessionDetached.setChannel(channel);
        sessionDetached.setCode(sessionDetachCode);
        this.invoke(sessionDetached);
    }

    protected void doHeartBeat() {
        this.connectionHeartbeat(new Option[0]);
    }

    public void setNetworkConnection(NetworkConnection network) {
        this._networkConnection = network;
    }

    public NetworkConnection getNetworkConnection() {
        return this._networkConnection;
    }

    public void setMaxFrameSize(int maxFrameSize) {
        if (this._frameSizeObserver != null) {
            this._frameSizeObserver.setMaxFrameSize(maxFrameSize);
        }
    }

    public void addFrameSizeObserver(final FrameSizeObserver frameSizeObserver) {
        if (this._frameSizeObserver == null) {
            this._frameSizeObserver = frameSizeObserver;
        } else {
            final FrameSizeObserver currentObserver = this._frameSizeObserver;
            this._frameSizeObserver = new FrameSizeObserver(){

                @Override
                public void setMaxFrameSize(int frameSize) {
                    currentObserver.setMaxFrameSize(frameSize);
                    frameSizeObserver.setMaxFrameSize(frameSize);
                }
            };
        }
    }

    public boolean isMessageCompressionSupported() {
        return this._messageCompressionSupported;
    }

    public boolean isVirtualHostPropertiesSupported() {
        return this._virtualHostPropertiesSupported;
    }

    public boolean isQueueLifetimePolicySupported() {
        return this._queueLifetimePolicySupported;
    }

    public boolean isRedirecting() {
        return this._redirecting.get();
    }

    public void setRedirecting(boolean redirecting) {
        this._redirecting.set(redirecting);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosing() {
        Object object = this.lock;
        synchronized (object) {
            return this.state == State.CLOSING || this.state == State.CLOSED;
        }
    }

    private class ConnectionActivity
    implements TransportActivity {
        private ConnectionActivity() {
        }

        @Override
        public long getLastReadTime() {
            return Connection.this._lastReadTime;
        }

        @Override
        public long getLastWriteTime() {
            return Connection.this._lastSendTime;
        }

        @Override
        public void writerIdle() {
            Connection.this.getConnectionDelegate().writerIdle(Connection.this);
        }

        @Override
        public void readerIdle() {
            LOGGER.error("Closing connection as no heartbeat or other activity detected within specified interval");
            Connection.this._networkConnection.close();
        }
    }

    private static final class DefaultSessionFactory
    implements SessionFactory {
        private DefaultSessionFactory() {
        }

        @Override
        public Session newSession(Connection conn, Binary name, long expiry, boolean isNoReplay) {
            return new Session(conn, name, expiry, isNoReplay);
        }
    }

    public static interface SessionFactory {
        public Session newSession(Connection var1, Binary var2, long var3, boolean var5);
    }

    public static enum State {
        NEW,
        CLOSED,
        OPENING,
        OPEN,
        CLOSING,
        CLOSE_RCVD,
        RESUMING;

    }
}

