/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.qpid.transport.Struct;
import org.apache.qpid.transport.codec.Decoder;
import org.apache.qpid.transport.codec.Encoder;

public final class ReplyTo
extends Struct {
    public static final int TYPE = -3;
    private short packing_flags = 0;
    private String exchange;
    private String routingKey;

    @Override
    public final int getStructType() {
        return -3;
    }

    @Override
    public final int getSizeWidth() {
        return 2;
    }

    @Override
    public final int getPackWidth() {
        return 2;
    }

    public final boolean hasPayload() {
        return false;
    }

    public final byte getEncodedTrack() {
        return -1;
    }

    public final boolean isConnectionControl() {
        return false;
    }

    public ReplyTo() {
    }

    public ReplyTo(String exchange, String routingKey) {
        if (exchange != null) {
            this.setExchange(exchange);
        }
        if (routingKey != null) {
            this.setRoutingKey(routingKey);
        }
    }

    public final boolean hasExchange() {
        return (this.packing_flags & 0x100) != 0;
    }

    public final ReplyTo clearExchange() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFEFF);
        this.exchange = null;
        this.setDirty(true);
        return this;
    }

    public final String getExchange() {
        return this.exchange;
    }

    public final ReplyTo setExchange(String value) {
        this.exchange = value;
        this.packing_flags = (short)(this.packing_flags | 0x100);
        this.setDirty(true);
        return this;
    }

    public final ReplyTo exchange(String value) {
        return this.setExchange(value);
    }

    public final boolean hasRoutingKey() {
        return (this.packing_flags & 0x200) != 0;
    }

    public final ReplyTo clearRoutingKey() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFDFF);
        this.routingKey = null;
        this.setDirty(true);
        return this;
    }

    public final String getRoutingKey() {
        return this.routingKey;
    }

    public final ReplyTo setRoutingKey(String value) {
        this.routingKey = value;
        this.packing_flags = (short)(this.packing_flags | 0x200);
        this.setDirty(true);
        return this;
    }

    public final ReplyTo routingKey(String value) {
        return this.setRoutingKey(value);
    }

    @Override
    public void write(Encoder enc) {
        enc.writeUint16(this.packing_flags);
        if ((this.packing_flags & 0x100) != 0) {
            enc.writeStr8(this.exchange);
        }
        if ((this.packing_flags & 0x200) != 0) {
            enc.writeStr8(this.routingKey);
        }
    }

    @Override
    public void read(Decoder dec) {
        this.packing_flags = (short)dec.readUint16();
        if ((this.packing_flags & 0x100) != 0) {
            this.exchange = dec.readStr8();
        }
        if ((this.packing_flags & 0x200) != 0) {
            this.routingKey = dec.readStr8();
        }
    }

    @Override
    public Map<String, Object> getFields() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if ((this.packing_flags & 0x100) != 0) {
            result.put("exchange", this.getExchange());
        }
        if ((this.packing_flags & 0x200) != 0) {
            result.put("routingKey", this.getRoutingKey());
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ReplyTo)) {
            return false;
        }
        ReplyTo reply = (ReplyTo)obj;
        return (this.routingKey == null ? reply.getRoutingKey() == null : this.routingKey.equals(reply.getRoutingKey())) && (this.exchange == null ? reply.getExchange() == null : this.exchange.equals(reply.getExchange()));
    }

    public int hashCode() {
        int result = this.routingKey == null ? 1 : this.routingKey.hashCode();
        return 31 * result + (this.exchange == null ? 5 : this.exchange.hashCode());
    }
}

