/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport.network.security;

import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import org.apache.qpid.ssl.SSLContextFactory;
import org.apache.qpid.transport.ByteBufferSender;
import org.apache.qpid.transport.ConnectionSettings;
import org.apache.qpid.transport.ExceptionHandlingByteBufferReceiver;
import org.apache.qpid.transport.TransportException;
import org.apache.qpid.transport.network.security.SSLStatus;
import org.apache.qpid.transport.network.security.SecurityLayer;
import org.apache.qpid.transport.network.security.sasl.SASLReceiver;
import org.apache.qpid.transport.network.security.sasl.SASLSender;
import org.apache.qpid.transport.network.security.ssl.SSLReceiver;
import org.apache.qpid.transport.network.security.ssl.SSLSender;
import org.apache.qpid.transport.network.security.ssl.SSLUtil;
import org.apache.qpid.util.Strings;

public class SecurityLayerFactory {
    private SecurityLayerFactory() {
    }

    public static SecurityLayer newInstance(ConnectionSettings settings) {
        SecurityLayer layer = NullSecurityLayer.getInstance();
        if (settings.isUseSSL()) {
            layer = new SSLSecurityLayer(settings, layer);
        }
        if (settings.isUseSASLEncryption()) {
            layer = new SASLSecurityLayer(layer);
        }
        return layer;
    }

    static class NullSecurityLayer
    implements SecurityLayer {
        private static final NullSecurityLayer INSTANCE = new NullSecurityLayer();

        private NullSecurityLayer() {
        }

        @Override
        public ByteBufferSender sender(ByteBufferSender delegate) {
            return delegate;
        }

        @Override
        public ExceptionHandlingByteBufferReceiver receiver(ExceptionHandlingByteBufferReceiver delegate) {
            return delegate;
        }

        @Override
        public String getUserID() {
            return null;
        }

        public static NullSecurityLayer getInstance() {
            return INSTANCE;
        }
    }

    static class SASLSecurityLayer
    implements SecurityLayer {
        private SecurityLayer _layer;

        SASLSecurityLayer(SecurityLayer layer) {
            this._layer = layer;
        }

        @Override
        public SASLSender sender(ByteBufferSender delegate) {
            SASLSender sender = new SASLSender(this._layer.sender(delegate));
            return sender;
        }

        @Override
        public SASLReceiver receiver(ExceptionHandlingByteBufferReceiver delegate) {
            SASLReceiver receiver = new SASLReceiver(this._layer.receiver(delegate));
            return receiver;
        }

        @Override
        public String getUserID() {
            return this._layer.getUserID();
        }
    }

    static class SSLSecurityLayer
    implements SecurityLayer {
        private static final Pattern JSON_ARRAY_PATTERN = Pattern.compile("\\s*\\[(\\s|.)*\\]\\s*");
        private final SSLEngine _engine;
        private final SSLStatus _sslStatus = new SSLStatus();
        private String _hostname;
        private SecurityLayer _layer;

        public SSLSecurityLayer(ConnectionSettings settings, SecurityLayer layer) {
            SSLContext sslCtx;
            this._layer = layer;
            try {
                TrustManager[] trustManagers = settings.getTrustManagers();
                KeyManager[] keyManagers = settings.getKeyManagers();
                sslCtx = SSLContextFactory.buildClientContext(trustManagers, keyManagers);
            }
            catch (Exception e) {
                throw new TransportException("Error creating SSL Context", e);
            }
            if (settings.isVerifyHostname()) {
                this._hostname = settings.getHost();
            }
            List<String> protocolWhiteList = this.getSystemPropertyAsList("qpid.client.security.tls.protocolWhiteList", "qpid.security.tls.protocolWhiteList", "TLSv1\\.[0-9]+");
            List<String> protocolBlackList = this.getSystemPropertyAsList("qpid.client.security.tls.protocolBlackList", "qpid.security.tls.protocolBlackList", "TLSv1\\.0");
            List<String> cipherSuiteWhiteList = this.getSystemPropertyAsList("qpid.client.security.tls.cipherSuiteWhiteList", "qpid.security.tls.cipherSuiteWhiteList", "");
            List<String> cipherSuiteBlackList = this.getSystemPropertyAsList("qpid.client.security.tls.cipherSuiteBlackList", "qpid.security.tls.cipherSuiteBlackList", "");
            try {
                this._engine = sslCtx.createSSLEngine();
                this._engine.setUseClientMode(true);
                SSLUtil.updateEnabledTlsProtocols(this._engine, protocolWhiteList, protocolBlackList);
                SSLUtil.updateEnabledCipherSuites(this._engine, cipherSuiteWhiteList, cipherSuiteBlackList);
            }
            catch (Exception e) {
                throw new TransportException("Error creating SSL Engine", e);
            }
        }

        private List<String> getSystemPropertyAsList(String propertyName, String alternatePropertyName, String defaultValue) {
            Properties systemProperties = System.getProperties();
            String listAsString = systemProperties.containsKey(propertyName) ? systemProperties.getProperty(propertyName) : (systemProperties.containsKey(alternatePropertyName) && !JSON_ARRAY_PATTERN.matcher(systemProperties.getProperty(alternatePropertyName)).matches() ? systemProperties.getProperty(alternatePropertyName) : defaultValue);
            return Strings.split(listAsString);
        }

        @Override
        public ByteBufferSender sender(ByteBufferSender delegate) {
            SSLSender sender = new SSLSender(this._engine, this._layer.sender(delegate), this._sslStatus);
            sender.setHostname(this._hostname);
            return sender;
        }

        @Override
        public ExceptionHandlingByteBufferReceiver receiver(ExceptionHandlingByteBufferReceiver delegate) {
            SSLReceiver receiver = new SSLReceiver(this._engine, this._layer.receiver(delegate), this._sslStatus);
            receiver.setHostname(this._hostname);
            return receiver;
        }

        @Override
        public String getUserID() {
            return SSLUtil.retrieveIdentity(this._engine);
        }
    }
}

