/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.bytebuffer;

import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;

class BufferPool {
    private final int _maxSize;
    private final ConcurrentLinkedQueue<ByteBuffer> _pooledBuffers = new ConcurrentLinkedQueue();
    private final AtomicInteger _size = new AtomicInteger();

    BufferPool(int maxSize) {
        this._maxSize = maxSize;
    }

    ByteBuffer getBuffer() {
        ByteBuffer buffer = this._pooledBuffers.poll();
        if (buffer != null) {
            this._size.decrementAndGet();
        }
        return buffer;
    }

    void returnBuffer(ByteBuffer buf) {
        buf.clear();
        if (this.size() < this._maxSize) {
            this._pooledBuffers.add(buf);
            this._size.incrementAndGet();
        }
    }

    public int getMaxSize() {
        return this._maxSize;
    }

    public int size() {
        return this._size.get();
    }
}

