/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.bytebuffer;

import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import org.apache.qpid.bytebuffer.BufferPool;
import org.apache.qpid.bytebuffer.ByteBufferRef;
import org.apache.qpid.bytebuffer.NonPooledByteBufferRef;
import org.apache.qpid.bytebuffer.PooledByteBufferRef;
import org.apache.qpid.bytebuffer.QpidByteBufferOutputStream;
import org.apache.qpid.streams.CompositeInputStream;

public class QpidByteBuffer {
    private static final AtomicIntegerFieldUpdater<QpidByteBuffer> DISPOSED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(QpidByteBuffer.class, "_disposed");
    private static final ThreadLocal<QpidByteBuffer> _cachedBuffer = new ThreadLocal();
    private static final ByteBuffer[] EMPTY_BYTE_BUFFER_ARRAY = new ByteBuffer[0];
    private static volatile boolean _isPoolInitialized;
    private static volatile BufferPool _bufferPool;
    private static volatile int _pooledBufferSize;
    private static volatile ByteBuffer _zeroed;
    private final int _offset;
    final ByteBufferRef _ref;
    volatile ByteBuffer _buffer;
    private volatile int _disposed;

    QpidByteBuffer(ByteBufferRef ref) {
        this(ref, ref.getBuffer(), 0);
    }

    private QpidByteBuffer(ByteBufferRef ref, ByteBuffer buffer, int offset) {
        this._ref = ref;
        this._buffer = buffer;
        this._offset = offset;
        this._ref.incrementRef();
    }

    public final boolean isDirect() {
        return this._buffer.isDirect();
    }

    public final short getUnsignedByte() {
        return (short)((short)this.get() & 0xFF);
    }

    public final int getUnsignedShort() {
        return this.getShort() & 0xFFFF;
    }

    public final int getUnsignedShort(int pos) {
        return this.getShort(pos) & 0xFFFF;
    }

    public final long getUnsignedInt() {
        return (long)this.getInt() & 0xFFFFFFFFL;
    }

    public final QpidByteBuffer putUnsignedByte(short s) {
        this.put((byte)s);
        return this;
    }

    public final QpidByteBuffer putUnsignedShort(int i) {
        this.putShort((short)i);
        return this;
    }

    public final QpidByteBuffer putUnsignedInt(long value) {
        this.putInt((int)value);
        return this;
    }

    public final void dispose() {
        if (DISPOSED_UPDATER.compareAndSet(this, 0, 1)) {
            this._ref.decrementRef();
            this._buffer = null;
        }
    }

    public final InputStream asInputStream() {
        return new BufferInputStream(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ByteBuffer asByteBuffer() {
        try {
            ByteBuffer byteBuffer = this.getUnderlyingBuffer();
            return byteBuffer;
        }
        finally {
            this.dispose();
        }
    }

    public final CharBuffer decode(Charset charset) {
        return charset.decode(this.getUnderlyingBuffer());
    }

    public final int read(ReadableByteChannel channel) throws IOException {
        return channel.read(this.getUnderlyingBuffer());
    }

    public final SSLEngineResult decryptSSL(SSLEngine engine, QpidByteBuffer dest) throws SSLException {
        return engine.unwrap(this.getUnderlyingBuffer(), dest.getUnderlyingBuffer());
    }

    public String toString() {
        return "QpidByteBuffer{_buffer=" + this._buffer + ", _disposed=" + this._disposed + '}';
    }

    public final boolean hasRemaining() {
        return this._buffer.hasRemaining();
    }

    public QpidByteBuffer putInt(int index, int value) {
        this._buffer.putInt(index, value);
        return this;
    }

    public QpidByteBuffer putShort(int index, short value) {
        this._buffer.putShort(index, value);
        return this;
    }

    public QpidByteBuffer putChar(int index, char value) {
        this._buffer.putChar(index, value);
        return this;
    }

    public final QpidByteBuffer put(byte b) {
        this._buffer.put(b);
        return this;
    }

    public QpidByteBuffer put(int index, byte b) {
        this._buffer.put(index, b);
        return this;
    }

    public short getShort(int index) {
        return this._buffer.getShort(index);
    }

    public final QpidByteBuffer mark() {
        this._buffer.mark();
        return this;
    }

    public final long getLong() {
        return this._buffer.getLong();
    }

    public QpidByteBuffer putFloat(int index, float value) {
        this._buffer.putFloat(index, value);
        return this;
    }

    public double getDouble(int index) {
        return this._buffer.getDouble(index);
    }

    public final boolean hasArray() {
        return this._buffer.hasArray();
    }

    public final double getDouble() {
        return this._buffer.getDouble();
    }

    public final QpidByteBuffer putFloat(float value) {
        this._buffer.putFloat(value);
        return this;
    }

    public final QpidByteBuffer putInt(int value) {
        this._buffer.putInt(value);
        return this;
    }

    public byte[] array() {
        return this._buffer.array();
    }

    public final QpidByteBuffer putShort(short value) {
        this._buffer.putShort(value);
        return this;
    }

    public int getInt(int index) {
        return this._buffer.getInt(index);
    }

    public final int remaining() {
        return this._buffer.remaining();
    }

    public final QpidByteBuffer put(byte[] src) {
        this._buffer.put(src);
        return this;
    }

    public final QpidByteBuffer put(ByteBuffer src) {
        this._buffer.put(src);
        return this;
    }

    public final QpidByteBuffer put(QpidByteBuffer src) {
        int sourceRemaining = src.remaining();
        if (sourceRemaining > this.remaining()) {
            throw new BufferOverflowException();
        }
        this._buffer.put(src.getUnderlyingBuffer());
        return this;
    }

    public final QpidByteBuffer get(byte[] dst, int offset, int length) {
        this._buffer.get(dst, offset, length);
        return this;
    }

    public final QpidByteBuffer get(ByteBuffer dst) {
        int remaining;
        int destinationRemaining = dst.remaining();
        if (destinationRemaining < (remaining = this.remaining())) {
            throw new BufferUnderflowException();
        }
        dst.put(this._buffer);
        return this;
    }

    public final void copyTo(ByteBuffer dst) {
        dst.put(this._buffer.duplicate());
    }

    public final void putCopyOf(QpidByteBuffer source) {
        int remaining = this.remaining();
        int sourceRemaining = source.remaining();
        if (sourceRemaining > remaining) {
            throw new BufferOverflowException();
        }
        this.put(source.getUnderlyingBuffer().duplicate());
    }

    public QpidByteBuffer rewind() {
        this._buffer.rewind();
        return this;
    }

    public QpidByteBuffer clear() {
        this._buffer.clear();
        return this;
    }

    public QpidByteBuffer putLong(int index, long value) {
        this._buffer.putLong(index, value);
        return this;
    }

    public QpidByteBuffer compact() {
        this._buffer.compact();
        return this;
    }

    public final QpidByteBuffer putDouble(double value) {
        this._buffer.putDouble(value);
        return this;
    }

    public int limit() {
        return this._buffer.limit();
    }

    public QpidByteBuffer reset() {
        this._buffer.reset();
        return this;
    }

    public QpidByteBuffer flip() {
        this._buffer.flip();
        return this;
    }

    public final short getShort() {
        return this._buffer.getShort();
    }

    public final float getFloat() {
        return this._buffer.getFloat();
    }

    public QpidByteBuffer limit(int newLimit) {
        this._buffer.limit(newLimit);
        return this;
    }

    public QpidByteBuffer duplicate() {
        ByteBuffer buffer = this._ref.getBuffer();
        if (!(this._ref instanceof PooledByteBufferRef)) {
            buffer = buffer.duplicate();
        }
        buffer.position(this._offset);
        buffer.limit(this._offset + this._buffer.capacity());
        buffer = buffer.slice();
        buffer.limit(this._buffer.limit());
        buffer.position(this._buffer.position());
        return new QpidByteBuffer(this._ref, buffer, this._offset);
    }

    public final QpidByteBuffer put(byte[] src, int offset, int length) {
        this._buffer.put(src, offset, length);
        return this;
    }

    public long getLong(int index) {
        return this._buffer.getLong(index);
    }

    public int capacity() {
        return this._buffer.capacity();
    }

    public char getChar(int index) {
        return this._buffer.getChar(index);
    }

    public final byte get() {
        return this._buffer.get();
    }

    public byte get(int index) {
        return this._buffer.get(index);
    }

    public final QpidByteBuffer get(byte[] dst) {
        this._buffer.get(dst);
        return this;
    }

    public final void copyTo(byte[] dst) {
        if (this.remaining() < dst.length) {
            throw new BufferUnderflowException();
        }
        this._buffer.duplicate().get(dst);
    }

    public final QpidByteBuffer putChar(char value) {
        this._buffer.putChar(value);
        return this;
    }

    public QpidByteBuffer position(int newPosition) {
        this._buffer.position(newPosition);
        return this;
    }

    public int arrayOffset() {
        return this._buffer.arrayOffset();
    }

    public final char getChar() {
        return this._buffer.getChar();
    }

    public final int getInt() {
        return this._buffer.getInt();
    }

    public final QpidByteBuffer putLong(long value) {
        this._buffer.putLong(value);
        return this;
    }

    public float getFloat(int index) {
        return this._buffer.getFloat(index);
    }

    public QpidByteBuffer slice() {
        return this.view(0, this._buffer.remaining());
    }

    public QpidByteBuffer view(int offset, int length) {
        ByteBuffer buffer = this._ref.getBuffer();
        if (!(this._ref instanceof PooledByteBufferRef)) {
            buffer = buffer.duplicate();
        }
        int newRemaining = Math.min(this._buffer.remaining() - offset, length);
        int newPosition = this._offset + this._buffer.position() + offset;
        buffer.limit(newPosition + newRemaining);
        buffer.position(newPosition);
        buffer = buffer.slice();
        return new QpidByteBuffer(this._ref, buffer, newPosition);
    }

    public int position() {
        return this._buffer.position();
    }

    public QpidByteBuffer putDouble(int index, double value) {
        this._buffer.putDouble(index, value);
        return this;
    }

    ByteBuffer getUnderlyingBuffer() {
        return this._buffer;
    }

    public static QpidByteBuffer allocate(boolean direct, int size) {
        return direct ? QpidByteBuffer.allocateDirect(size) : QpidByteBuffer.allocate(size);
    }

    public static QpidByteBuffer allocate(int size) {
        return new QpidByteBuffer(new NonPooledByteBufferRef(ByteBuffer.allocate(size)));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static QpidByteBuffer allocateDirect(int size) {
        void var1_5;
        if (size < 0) {
            throw new IllegalArgumentException("Cannot allocate QpidByteBuffer with size " + size + " which is negative.");
        }
        if (_isPoolInitialized && _pooledBufferSize >= size) {
            if (_pooledBufferSize == size) {
                ByteBuffer buf = _bufferPool.getBuffer();
                if (buf == null) {
                    buf = ByteBuffer.allocateDirect(size);
                }
                PooledByteBufferRef pooledByteBufferRef = new PooledByteBufferRef(buf);
                return new QpidByteBuffer((ByteBufferRef)var1_5);
            }
            QpidByteBuffer buf = _cachedBuffer.get();
            if (buf == null || buf.remaining() < size) {
                if (buf != null) {
                    buf.dispose();
                }
                buf = QpidByteBuffer.allocateDirect(_pooledBufferSize);
            }
            QpidByteBuffer rVal = buf.view(0, size);
            buf.position(buf.position() + size);
            _cachedBuffer.set(buf);
            return rVal;
        }
        NonPooledByteBufferRef nonPooledByteBufferRef = new NonPooledByteBufferRef(ByteBuffer.allocateDirect(size));
        return new QpidByteBuffer((ByteBufferRef)var1_5);
    }

    public static Collection<QpidByteBuffer> allocateDirectCollection(int size) {
        if (_pooledBufferSize == 0) {
            return Collections.singleton(QpidByteBuffer.allocateDirect(size));
        }
        ArrayList<QpidByteBuffer> buffers = new ArrayList<QpidByteBuffer>(size / _pooledBufferSize + 2);
        int remaining = size;
        QpidByteBuffer buf = _cachedBuffer.get();
        if (buf == null) {
            buf = QpidByteBuffer.allocateDirect(_pooledBufferSize);
        }
        while (remaining > buf.remaining()) {
            int bufRemaining = buf.remaining();
            if (buf == _cachedBuffer.get()) {
                buffers.add(buf.view(0, bufRemaining));
                buf.dispose();
            } else {
                buffers.add(buf);
            }
            remaining -= bufRemaining;
            buf = QpidByteBuffer.allocateDirect(_pooledBufferSize);
        }
        buffers.add(buf.view(0, remaining));
        buf.position(buf.position() + remaining);
        if (buf.hasRemaining()) {
            _cachedBuffer.set(buf);
        } else {
            _cachedBuffer.set(QpidByteBuffer.allocateDirect(_pooledBufferSize));
            buf.dispose();
        }
        return buffers;
    }

    public static Collection<QpidByteBuffer> asQpidByteBuffers(byte[] data) {
        return QpidByteBuffer.asQpidByteBuffers(data, 0, data.length);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Collection<QpidByteBuffer> asQpidByteBuffers(byte[] data, int offset, int length) {
        try (QpidByteBufferOutputStream outputStream = new QpidByteBufferOutputStream(true, QpidByteBuffer.getPooledBufferSize());){
            outputStream.write(data, offset, length);
            Collection<QpidByteBuffer> collection = outputStream.fetchAccumulatedBuffers();
            return collection;
        }
        catch (IOException e) {
            throw new RuntimeException("unexpected Error converting array to QpidByteBuffers", e);
        }
    }

    public static SSLEngineResult encryptSSL(SSLEngine engine, Collection<QpidByteBuffer> buffers, QpidByteBuffer dest) throws SSLException {
        ByteBuffer[] src;
        if (buffers.isEmpty()) {
            src = EMPTY_BYTE_BUFFER_ARRAY;
        } else {
            src = new ByteBuffer[buffers.size()];
            Iterator<QpidByteBuffer> iterator = buffers.iterator();
            for (int i = 0; i < src.length; ++i) {
                src[i] = iterator.next().getUnderlyingBuffer();
            }
        }
        return engine.wrap(src, dest.getUnderlyingBuffer());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Collection<QpidByteBuffer> inflate(Collection<QpidByteBuffer> compressedBuffers) throws IOException {
        if (compressedBuffers == null) {
            throw new IllegalArgumentException("compressedBuffers cannot be null");
        }
        boolean isDirect = false;
        ArrayList<InputStream> streams = new ArrayList<InputStream>(compressedBuffers.size());
        for (QpidByteBuffer buffer : compressedBuffers) {
            isDirect = isDirect || buffer.isDirect();
            streams.add(buffer.asInputStream());
        }
        int bufferSize = isDirect && _pooledBufferSize > 0 ? _pooledBufferSize : 65536;
        ArrayList<QpidByteBuffer> uncompressedBuffers = new ArrayList<QpidByteBuffer>();
        try (GZIPInputStream gzipInputStream = new GZIPInputStream(new CompositeInputStream(streams));){
            int read;
            byte[] buf = new byte[bufferSize];
            while ((read = gzipInputStream.read(buf)) != -1) {
                uncompressedBuffers.addAll(QpidByteBuffer.asQpidByteBuffers(buf, 0, read));
            }
            ArrayList<QpidByteBuffer> arrayList = uncompressedBuffers;
            return arrayList;
        }
        catch (IOException e) {
            Iterator i$ = uncompressedBuffers.iterator();
            while (i$.hasNext()) {
                QpidByteBuffer uncompressedBuffer = (QpidByteBuffer)i$.next();
                uncompressedBuffer.dispose();
            }
            throw e;
        }
    }

    /*
     * Exception decompiling
     */
    public static Collection<QpidByteBuffer> deflate(Collection<QpidByteBuffer> uncompressedBuffers) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static long write(GatheringByteChannel channel, Collection<QpidByteBuffer> qpidByteBuffers) throws IOException {
        ByteBuffer[] byteBuffers = new ByteBuffer[qpidByteBuffers.size()];
        Iterator<QpidByteBuffer> iterator = qpidByteBuffers.iterator();
        for (int i = 0; i < byteBuffers.length; ++i) {
            byteBuffers[i] = iterator.next().getUnderlyingBuffer();
        }
        return channel.write(byteBuffers);
    }

    public static QpidByteBuffer wrap(ByteBuffer wrap) {
        return new QpidByteBuffer(new NonPooledByteBufferRef(wrap));
    }

    public static QpidByteBuffer wrap(byte[] data) {
        return QpidByteBuffer.wrap(ByteBuffer.wrap(data));
    }

    public static QpidByteBuffer wrap(byte[] data, int offset, int length) {
        return QpidByteBuffer.wrap(ByteBuffer.wrap(data, offset, length));
    }

    static void returnToPool(ByteBuffer buffer) {
        buffer.clear();
        ByteBuffer duplicate = _zeroed.duplicate();
        duplicate.limit(buffer.capacity());
        buffer.put(duplicate);
        _bufferPool.returnBuffer(buffer);
    }

    public static synchronized void initialisePool(int bufferSize, int maxPoolSize) {
        if (_isPoolInitialized && (bufferSize != _pooledBufferSize || maxPoolSize != _bufferPool.getMaxSize())) {
            String errorMessage = String.format("QpidByteBuffer pool has already been initialised with bufferSize=%d and maxPoolSize=%d.Re-initialisation with different bufferSize=%d and maxPoolSize=%d is not allowed.", _pooledBufferSize, _bufferPool.getMaxSize(), bufferSize, maxPoolSize);
            throw new IllegalStateException(errorMessage);
        }
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("Negative or zero bufferSize illegal : " + bufferSize);
        }
        _bufferPool = new BufferPool(maxPoolSize);
        _pooledBufferSize = bufferSize;
        _zeroed = ByteBuffer.allocateDirect(_pooledBufferSize);
        _isPoolInitialized = true;
    }

    public static QpidByteBuffer getCachedThreadLocalBuffer() {
        return _cachedBuffer.get();
    }

    public static int getPooledBufferSize() {
        return _pooledBufferSize;
    }

    public static long getAllocatedDirectMemorySize() {
        return (long)_pooledBufferSize * (long)QpidByteBuffer.getNumberOfActivePooledBuffers();
    }

    public static int getNumberOfActivePooledBuffers() {
        return PooledByteBufferRef.getActiveBufferCount();
    }

    public static int getNumberOfPooledBuffers() {
        return _bufferPool.size();
    }

    private static final class BufferInputStream
    extends InputStream {
        private final QpidByteBuffer _qpidByteBuffer;

        private BufferInputStream(QpidByteBuffer buffer) {
            this._qpidByteBuffer = buffer;
        }

        @Override
        public int read() throws IOException {
            if (this._qpidByteBuffer.hasRemaining()) {
                return this._qpidByteBuffer.get() & 0xFF;
            }
            return -1;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (!this._qpidByteBuffer.hasRemaining()) {
                return -1;
            }
            if (this._qpidByteBuffer.remaining() < len) {
                len = this._qpidByteBuffer.remaining();
            }
            this._qpidByteBuffer.get(b, off, len);
            return len;
        }

        @Override
        public void mark(int readlimit) {
            this._qpidByteBuffer.mark();
        }

        @Override
        public void reset() throws IOException {
            this._qpidByteBuffer.reset();
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public long skip(long n) throws IOException {
            this._qpidByteBuffer.position(this._qpidByteBuffer.position() + (int)n);
            return n;
        }

        @Override
        public int available() throws IOException {
            return this._qpidByteBuffer.remaining();
        }

        @Override
        public void close() {
        }
    }
}

