/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.bytebuffer;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.qpid.bytebuffer.ByteBufferRef;
import org.apache.qpid.bytebuffer.QpidByteBuffer;

class PooledByteBufferRef
implements ByteBufferRef {
    private static final AtomicIntegerFieldUpdater<PooledByteBufferRef> REF_COUNT = AtomicIntegerFieldUpdater.newUpdater(PooledByteBufferRef.class, "_refCount");
    private static final AtomicInteger ACTIVE_BUFFERS = new AtomicInteger();
    private final ByteBuffer _buffer;
    private volatile int _refCount;

    PooledByteBufferRef(ByteBuffer buffer) {
        this._buffer = buffer;
        ACTIVE_BUFFERS.incrementAndGet();
    }

    @Override
    public void incrementRef() {
        if (REF_COUNT.get(this) >= 0) {
            REF_COUNT.incrementAndGet(this);
        }
    }

    @Override
    public void decrementRef() {
        if (REF_COUNT.get(this) > 0 && REF_COUNT.decrementAndGet(this) == 0) {
            QpidByteBuffer.returnToPool(this._buffer);
            ACTIVE_BUFFERS.decrementAndGet();
        }
    }

    @Override
    public ByteBuffer getBuffer() {
        return this._buffer.duplicate();
    }

    @Override
    public void removeFromPool() {
        REF_COUNT.set(this, -1073741824);
    }

    public static int getActiveBufferCount() {
        return ACTIVE_BUFFERS.get();
    }
}

