/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing;

import org.apache.qpid.QpidException;
import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyImpl;
import org.apache.qpid.framing.ChannelMethodProcessor;
import org.apache.qpid.framing.EncodableAMQDataBlock;
import org.apache.qpid.framing.MethodDispatcher;

public class ChannelFlowBody
extends AMQMethodBodyImpl
implements EncodableAMQDataBlock,
AMQMethodBody {
    public static final int CLASS_ID = 20;
    public static final int METHOD_ID = 20;
    private final boolean _active;

    public ChannelFlowBody(boolean active) {
        this._active = active;
    }

    @Override
    public int getClazz() {
        return 20;
    }

    @Override
    public int getMethod() {
        return 20;
    }

    public final boolean getActive() {
        return this._active;
    }

    @Override
    protected int getBodySize() {
        return 1;
    }

    @Override
    public void writeMethodPayload(QpidByteBuffer buffer) {
        this.writeBitfield(buffer, this._active ? (byte)1 : 0);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws QpidException {
        return dispatcher.dispatchChannelFlow(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[ChannelFlowBodyImpl: ");
        buf.append("active=");
        buf.append(this.getActive());
        buf.append("]");
        return buf.toString();
    }

    public static void process(QpidByteBuffer buffer, ChannelMethodProcessor dispatcher) {
        boolean active;
        boolean bl = active = (buffer.get() & 1) == 1;
        if (!dispatcher.ignoreAllButCloseOk()) {
            dispatcher.receiveChannelFlow(active);
        }
    }
}

