/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing;

import org.apache.qpid.QpidException;
import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyImpl;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.EncodableAMQDataBlock;
import org.apache.qpid.framing.MethodDispatcher;
import org.apache.qpid.framing.ServerChannelMethodProcessor;

public class QueueDeleteBody
extends AMQMethodBodyImpl
implements EncodableAMQDataBlock,
AMQMethodBody {
    public static final int CLASS_ID = 50;
    public static final int METHOD_ID = 40;
    private final int _ticket;
    private final AMQShortString _queue;
    private final byte _bitfield0;

    public QueueDeleteBody(int ticket, AMQShortString queue, boolean ifUnused, boolean ifEmpty, boolean nowait) {
        this._ticket = ticket;
        this._queue = queue;
        byte bitfield0 = 0;
        if (ifUnused) {
            bitfield0 = (byte)(bitfield0 | 1);
        }
        if (ifEmpty) {
            bitfield0 = (byte)(bitfield0 | 2);
        }
        if (nowait) {
            bitfield0 = (byte)(bitfield0 | 4);
        }
        this._bitfield0 = bitfield0;
    }

    @Override
    public int getClazz() {
        return 50;
    }

    @Override
    public int getMethod() {
        return 40;
    }

    public final int getTicket() {
        return this._ticket;
    }

    public final AMQShortString getQueue() {
        return this._queue;
    }

    public final boolean getIfUnused() {
        return (this._bitfield0 & 1) != 0;
    }

    public final boolean getIfEmpty() {
        return (this._bitfield0 & 2) != 0;
    }

    public final boolean getNowait() {
        return (this._bitfield0 & 4) != 0;
    }

    @Override
    protected int getBodySize() {
        int size = 3;
        return size += this.getSizeOf(this._queue);
    }

    @Override
    public void writeMethodPayload(QpidByteBuffer buffer) {
        this.writeUnsignedShort(buffer, this._ticket);
        this.writeAMQShortString(buffer, this._queue);
        this.writeBitfield(buffer, this._bitfield0);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws QpidException {
        return dispatcher.dispatchQueueDelete(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[QueueDeleteBodyImpl: ");
        buf.append("ticket=");
        buf.append(this.getTicket());
        buf.append(", ");
        buf.append("queue=");
        buf.append(this.getQueue());
        buf.append(", ");
        buf.append("ifUnused=");
        buf.append(this.getIfUnused());
        buf.append(", ");
        buf.append("ifEmpty=");
        buf.append(this.getIfEmpty());
        buf.append(", ");
        buf.append("nowait=");
        buf.append(this.getNowait());
        buf.append("]");
        return buf.toString();
    }

    public static void process(QpidByteBuffer buffer, ServerChannelMethodProcessor dispatcher) {
        boolean nowait;
        int ticket = buffer.getUnsignedShort();
        AMQShortString queue = AMQShortString.readAMQShortString(buffer);
        byte bitfield = buffer.get();
        boolean ifUnused = (bitfield & 1) == 1;
        boolean ifEmpty = (bitfield & 2) == 2;
        boolean bl = nowait = (bitfield & 4) == 4;
        if (!dispatcher.ignoreAllButCloseOk()) {
            dispatcher.receiveQueueDelete(queue, ifUnused, ifEmpty, nowait);
        }
    }
}

