/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport;

import java.util.HashMap;
import java.util.List;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.apache.qpid.configuration.CommonProperties;
import org.apache.qpid.properties.ConnectionStartProperties;
import org.apache.qpid.transport.Connection;
import org.apache.qpid.transport.ConnectionDelegate;
import org.apache.qpid.transport.ConnectionException;
import org.apache.qpid.transport.ConnectionHeartbeat;
import org.apache.qpid.transport.ConnectionListener;
import org.apache.qpid.transport.ConnectionOpenOk;
import org.apache.qpid.transport.ConnectionRedirect;
import org.apache.qpid.transport.ConnectionSecure;
import org.apache.qpid.transport.ConnectionSettings;
import org.apache.qpid.transport.ConnectionStart;
import org.apache.qpid.transport.ConnectionTune;
import org.apache.qpid.transport.Option;
import org.apache.qpid.transport.ProtocolHeader;
import org.apache.qpid.transport.ProtocolVersionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientDelegate
extends ConnectionDelegate {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientDelegate.class);
    private final ConnectionSettings _connectionSettings;

    public ClientDelegate(ConnectionSettings settings) {
        this._connectionSettings = settings;
    }

    @Override
    public void init(Connection conn, ProtocolHeader hdr) {
        if (hdr.getMajor() != 0 || hdr.getMinor() != 10) {
            conn.exception(new ProtocolVersionException(hdr.getMajor(), hdr.getMinor()));
        }
    }

    @Override
    public void connectionStart(Connection conn, ConnectionStart start) {
        HashMap<String, Object> clientProperties = new HashMap<String, Object>();
        if (this._connectionSettings.getClientProperties() != null) {
            clientProperties.putAll(this._connectionSettings.getClientProperties());
        }
        clientProperties.put("qpid.session_flow", 1);
        clientProperties.put("qpid.client_pid", ConnectionStartProperties.getPID());
        clientProperties.put("qpid.client_process", System.getProperty("qpid.client_process", "Apache Qpid JMS Client for AMQP 0-9-1/0-10"));
        clientProperties.put("qpid.client_version", CommonProperties.getReleaseVersion());
        clientProperties.put("product", CommonProperties.getProductName());
        clientProperties.put("platform", ConnectionStartProperties.getPlatformInfo());
        List<Object> brokerMechs = start.getMechanisms();
        if (brokerMechs == null || brokerMechs.isEmpty()) {
            conn.connectionStartOk(clientProperties, null, null, conn.getLocale(), new Option[0]);
            return;
        }
        conn.setServerProperties(start.getServerProperties());
        try {
            SaslClient sc = this.createSaslClient(brokerMechs);
            conn.setSaslClient(sc);
            byte[] response = sc.hasInitialResponse() ? sc.evaluateChallenge(new byte[0]) : null;
            conn.connectionStartOk(clientProperties, sc.getMechanismName(), response, conn.getLocale(), new Option[0]);
        }
        catch (ConnectionException ce) {
            conn.exception(ce);
        }
        catch (SaslException e) {
            conn.exception(e);
        }
    }

    protected SaslClient createSaslClient(List<Object> brokerMechs) throws ConnectionException, SaslException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void connectionSecure(Connection conn, ConnectionSecure secure) {
        SaslClient sc = conn.getSaslClient();
        try {
            byte[] response = sc.evaluateChallenge(secure.getChallenge());
            conn.connectionSecureOk(response, new Option[0]);
        }
        catch (SaslException e) {
            conn.exception(e);
        }
    }

    @Override
    public void connectionTune(Connection conn, ConnectionTune tune) {
        int heartbeatInterval = this._connectionSettings.getHeartbeatInterval010();
        float heartbeatTimeoutFactor = this._connectionSettings.getHeartbeatTimeoutFactor();
        int actualHeartbeatInterval = this.calculateHeartbeatInterval(heartbeatInterval, tune.getHeartbeatMin(), tune.getHeartbeatMax());
        int maxFrameSize = tune.getMaxFrameSize();
        int settingsMaxFrameSize = conn.getConnectionSettings().getMaxFrameSize();
        if (maxFrameSize == 0 && settingsMaxFrameSize != 0 && settingsMaxFrameSize < 65535) {
            maxFrameSize = Math.max(4096, settingsMaxFrameSize);
        } else if (maxFrameSize != 0 && settingsMaxFrameSize != 0) {
            maxFrameSize = Math.max(4096, Math.min(maxFrameSize, settingsMaxFrameSize));
        }
        conn.connectionTuneOk(tune.getChannelMax(), maxFrameSize, actualHeartbeatInterval, new Option[0]);
        conn.getNetworkConnection().setMaxReadIdleMillis((long)(1000.0f * ((float)actualHeartbeatInterval * heartbeatTimeoutFactor)));
        conn.getNetworkConnection().setMaxWriteIdleMillis(1000L * (long)actualHeartbeatInterval);
        conn.setMaxFrameSize(maxFrameSize == 0 ? 65535 : maxFrameSize);
        int channelMax = tune.getChannelMax();
        conn.setChannelMax(channelMax == 0 ? 65535 : channelMax);
        conn.connectionOpen(this._connectionSettings.getVhost(), null, Option.INSIST);
    }

    @Override
    public void connectionOpenOk(Connection conn, ConnectionOpenOk ok) {
        if (conn.isConnectionResuming()) {
            conn.setState(Connection.State.RESUMING);
        } else {
            conn.setState(Connection.State.OPEN);
        }
    }

    @Override
    public void connectionRedirect(Connection conn, ConnectionRedirect redir) {
        conn.setRedirecting(true);
        conn.getSender().close();
        for (ConnectionListener listener : conn.getListeners()) {
            if (listener.redirect(redir.getHost(), redir.getKnownHosts())) break;
        }
    }

    @Override
    public void connectionHeartbeat(Connection conn, ConnectionHeartbeat hearbeat) {
        conn.connectionHeartbeat(new Option[0]);
    }

    int calculateHeartbeatInterval(int heartbeat, int min, int max) {
        int i = heartbeat;
        if (i == 0) {
            LOGGER.info("Heartbeat interval is 0 sec. Heartbeats are disabled.");
            return 0;
        }
        if (i >= min && i <= max) {
            return i;
        }
        LOGGER.info("The broker does not support the configured connection heartbeat interval of {} sec, using the brokers max supported value of {} sec instead.", (Object)i, (Object)max);
        return max;
    }

    public ConnectionSettings getConnectionSettings() {
        return this._connectionSettings;
    }
}

