/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.InvalidClientIDException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import org.apache.qpid.jms.JmsConnectionListener;
import org.apache.qpid.jms.JmsConnectionMetaData;
import org.apache.qpid.jms.JmsDestination;
import org.apache.qpid.jms.JmsMessageDispatcher;
import org.apache.qpid.jms.JmsPrefetchPolicy;
import org.apache.qpid.jms.JmsQueueSession;
import org.apache.qpid.jms.JmsSession;
import org.apache.qpid.jms.JmsTemporaryDestination;
import org.apache.qpid.jms.JmsTemporaryQueue;
import org.apache.qpid.jms.JmsTemporaryTopic;
import org.apache.qpid.jms.JmsTopicSession;
import org.apache.qpid.jms.exceptions.JmsConnectionFailedException;
import org.apache.qpid.jms.exceptions.JmsExceptionSupport;
import org.apache.qpid.jms.message.JmsInboundMessageDispatch;
import org.apache.qpid.jms.message.JmsMessage;
import org.apache.qpid.jms.message.JmsMessageFactory;
import org.apache.qpid.jms.message.JmsOutboundMessageDispatch;
import org.apache.qpid.jms.meta.JmsConnectionId;
import org.apache.qpid.jms.meta.JmsConnectionInfo;
import org.apache.qpid.jms.meta.JmsConsumerId;
import org.apache.qpid.jms.meta.JmsConsumerInfo;
import org.apache.qpid.jms.meta.JmsProducerInfo;
import org.apache.qpid.jms.meta.JmsResource;
import org.apache.qpid.jms.meta.JmsSessionId;
import org.apache.qpid.jms.meta.JmsSessionInfo;
import org.apache.qpid.jms.meta.JmsTransactionId;
import org.apache.qpid.jms.provider.Provider;
import org.apache.qpid.jms.provider.ProviderClosedException;
import org.apache.qpid.jms.provider.ProviderConstants;
import org.apache.qpid.jms.provider.ProviderFuture;
import org.apache.qpid.jms.provider.ProviderListener;
import org.apache.qpid.jms.util.IdGenerator;
import org.apache.qpid.jms.util.ThreadPoolUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsConnection
implements Connection,
TopicConnection,
QueueConnection,
ProviderListener {
    private static final Logger LOG = LoggerFactory.getLogger(JmsConnection.class);
    private final IdGenerator clientIdGenerator;
    private final Map<JmsSessionId, JmsSession> sessions = new ConcurrentHashMap<JmsSessionId, JmsSession>();
    private final Map<JmsConsumerId, JmsMessageDispatcher> dispatchers = new ConcurrentHashMap<JmsConsumerId, JmsMessageDispatcher>();
    private final AtomicBoolean connected = new AtomicBoolean();
    private final AtomicBoolean closed = new AtomicBoolean();
    private final AtomicBoolean closing = new AtomicBoolean();
    private final AtomicBoolean started = new AtomicBoolean();
    private final AtomicBoolean failed = new AtomicBoolean();
    private final Object connectLock = new Object();
    private IOException firstFailureError;
    private JmsConnectionInfo connectionInfo;
    private URI configuredURI;
    private URI connectedURI;
    private JmsPrefetchPolicy prefetchPolicy = new JmsPrefetchPolicy();
    private boolean localMessagePriority;
    private boolean clientIdSet;
    private boolean sendAcksAsync;
    private ExceptionListener exceptionListener;
    private final ThreadPoolExecutor executor;
    private Provider provider;
    private final Set<JmsConnectionListener> connectionListeners = new CopyOnWriteArraySet<JmsConnectionListener>();
    private final Map<JmsTemporaryDestination, JmsTemporaryDestination> tempDestinations = new ConcurrentHashMap<JmsTemporaryDestination, JmsTemporaryDestination>();
    private final AtomicLong sessionIdGenerator = new AtomicLong();
    private final AtomicLong tempDestIdGenerator = new AtomicLong();
    private final AtomicLong transactionIdGenerator = new AtomicLong();
    private JmsMessageFactory messageFactory;

    protected JmsConnection(final String connectionId, Provider provider, IdGenerator clientIdGenerator) throws JMSException {
        this.executor = new ThreadPoolExecutor(1, 1, 5L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r, "QpidJMS Connection Executor: " + connectionId);
                thread.setDaemon(false);
                return thread;
            }
        });
        this.provider = provider;
        this.provider.setProviderListener(this);
        try {
            this.provider.start();
        }
        catch (Exception e) {
            this.executor.shutdown();
            throw JmsExceptionSupport.create(e);
        }
        this.clientIdGenerator = clientIdGenerator;
        this.connectionInfo = new JmsConnectionInfo(new JmsConnectionId(connectionId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        boolean interrupted = Thread.interrupted();
        try {
            if (!this.closed.get() && !this.failed.get()) {
                this.doStop(false);
            }
            JmsConnection jmsConnection = this;
            synchronized (jmsConnection) {
                block26: {
                    if (!this.closed.get()) break block26;
                    return;
                }
                this.closing.set(true);
                for (JmsSession session : this.sessions.values()) {
                    session.shutdown();
                }
                this.sessions.clear();
                this.tempDestinations.clear();
                if (this.isConnected() && !this.failed.get()) {
                    ProviderFuture request = new ProviderFuture();
                    try {
                        this.provider.destroy(this.connectionInfo, request);
                        try {
                            request.sync();
                        }
                        catch (Exception ex) {
                            if (ex.getCause() instanceof InterruptedException) {
                                throw (InterruptedException)ex.getCause();
                            }
                            LOG.debug("Failed destroying Connection resource: {}", (Object)ex.getMessage());
                        }
                    }
                    catch (ProviderClosedException pce) {
                        LOG.debug("Ignoring provider closed exception during connection close");
                    }
                }
                this.connected.set(false);
                this.started.set(false);
                this.closing.set(false);
                this.closed.set(true);
            }
        }
        catch (Exception e) {
            throw JmsExceptionSupport.create(e);
        }
        finally {
            try {
                ThreadPoolUtils.shutdown(this.executor);
            }
            catch (Throwable e) {
                LOG.warn("Error shutting down thread pool: " + this.executor + ". This exception will be ignored.", e);
            }
            if (this.provider != null) {
                this.provider.close();
                this.provider = null;
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    protected void shutdown() throws JMSException {
        for (JmsSession session : this.sessions.values()) {
            session.shutdown();
        }
        if (this.isConnected() && !this.failed.get() && !this.closing.get()) {
            this.destroyResource(this.connectionInfo);
        }
        this.tempDestinations.clear();
        this.started.set(false);
        this.connected.set(false);
    }

    public Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        this.checkClosedOrFailed();
        this.connect();
        int ackMode = this.getSessionAcknowledgeMode(transacted, acknowledgeMode);
        JmsSession result = new JmsSession(this, this.getNextSessionId(), ackMode);
        this.addSession(result.getSessionInfo(), result);
        if (this.started.get()) {
            result.start();
        }
        return result;
    }

    public synchronized String getClientID() throws JMSException {
        this.checkClosedOrFailed();
        return this.connectionInfo.getClientId();
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        this.checkClosedOrFailed();
        return JmsConnectionMetaData.INSTANCE;
    }

    public synchronized void setClientID(String clientID) throws JMSException {
        this.checkClosedOrFailed();
        if (this.clientIdSet) {
            throw new IllegalStateException("The clientID has already been set");
        }
        if (clientID == null || clientID.isEmpty()) {
            throw new InvalidClientIDException("Cannot have a null or empty clientID");
        }
        if (this.connected.get()) {
            throw new IllegalStateException("Cannot set the client id once connected.");
        }
        this.connectionInfo.setClientId(clientID);
        this.clientIdSet = true;
        this.connect();
    }

    public void start() throws JMSException {
        this.checkClosedOrFailed();
        this.connect();
        if (this.started.compareAndSet(false, true)) {
            try {
                for (JmsSession s : this.sessions.values()) {
                    s.start();
                }
            }
            catch (Exception e) {
                throw JmsExceptionSupport.create(e);
            }
        }
    }

    public void stop() throws JMSException {
        this.doStop(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doStop(boolean checkClosed) throws JMSException {
        if (checkClosed) {
            this.checkClosedOrFailed();
        }
        if (this.started.compareAndSet(true, false)) {
            Map<JmsSessionId, JmsSession> map = this.sessions;
            synchronized (map) {
                for (JmsSession s : this.sessions.values()) {
                    s.stop();
                }
            }
        }
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        this.checkClosedOrFailed();
        this.connect();
        throw new JMSException("Not supported");
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        this.checkClosedOrFailed();
        this.connect();
        throw new JMSException("Not supported");
    }

    public ConnectionConsumer createConnectionConsumer(Topic topic, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        this.checkClosedOrFailed();
        this.connect();
        throw new JMSException("Not supported");
    }

    public ConnectionConsumer createConnectionConsumer(Queue queue, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        this.checkClosedOrFailed();
        this.connect();
        throw new JMSException("Not supported");
    }

    public TopicSession createTopicSession(boolean transacted, int acknowledgeMode) throws JMSException {
        this.checkClosedOrFailed();
        this.connect();
        int ackMode = this.getSessionAcknowledgeMode(transacted, acknowledgeMode);
        JmsTopicSession result = new JmsTopicSession(this, this.getNextSessionId(), ackMode);
        this.addSession(result.getSessionInfo(), result);
        if (this.started.get()) {
            result.start();
        }
        return result;
    }

    public QueueSession createQueueSession(boolean transacted, int acknowledgeMode) throws JMSException {
        this.checkClosedOrFailed();
        this.connect();
        int ackMode = this.getSessionAcknowledgeMode(transacted, acknowledgeMode);
        JmsQueueSession result = new JmsQueueSession(this, this.getNextSessionId(), ackMode);
        this.addSession(result.getSessionInfo(), result);
        if (this.started.get()) {
            result.start();
        }
        return result;
    }

    public void onException(Exception ex) {
        this.onException(JmsExceptionSupport.create(ex));
    }

    public void onException(JMSException ex) {
        ExceptionListener l = this.exceptionListener;
        if (l != null) {
            l.onException(JmsExceptionSupport.create((Exception)((Object)ex)));
        }
    }

    protected int getSessionAcknowledgeMode(boolean transacted, int acknowledgeMode) throws JMSException {
        int result = acknowledgeMode;
        if (!transacted && acknowledgeMode == 0) {
            throw new JMSException("acknowledgeMode SESSION_TRANSACTED cannot be used for an non-transacted Session");
        }
        if (transacted) {
            result = 0;
        } else if (acknowledgeMode < 0 || acknowledgeMode > 3) {
            throw new JMSException("acknowledgeMode " + acknowledgeMode + " cannot be used for an non-transacted Session");
        }
        return result;
    }

    protected void removeSession(JmsSessionInfo sessionInfo) throws JMSException {
        this.sessions.remove(sessionInfo.getSessionId());
    }

    protected void addSession(JmsSessionInfo sessionInfo, JmsSession session) {
        this.sessions.put(sessionInfo.getSessionId(), session);
    }

    protected void addDispatcher(JmsConsumerId consumerId, JmsMessageDispatcher dispatcher) {
        this.dispatchers.put(consumerId, dispatcher);
    }

    protected void removeDispatcher(JmsConsumerId consumerId) {
        this.dispatchers.remove(consumerId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect() throws JMSException {
        Object object = this.connectLock;
        synchronized (object) {
            if (this.isConnected() || this.closed.get()) {
                return;
            }
            if (this.connectionInfo.getClientId() == null || this.connectionInfo.getClientId().trim().isEmpty()) {
                this.connectionInfo.setClientId(this.clientIdGenerator.generateId());
            }
            this.createResource(this.connectionInfo);
            this.connected.set(true);
        }
    }

    protected TemporaryQueue createTemporaryQueue() throws JMSException {
        String destinationName = this.connectionInfo.getConnectionId() + ":" + this.tempDestIdGenerator.incrementAndGet();
        JmsTemporaryQueue queue = new JmsTemporaryQueue(destinationName);
        this.createResource(queue);
        this.tempDestinations.put(queue, queue);
        queue.setConnection(this);
        return queue;
    }

    protected TemporaryTopic createTemporaryTopic() throws JMSException {
        String destinationName = this.connectionInfo.getConnectionId() + ":" + this.tempDestIdGenerator.incrementAndGet();
        JmsTemporaryTopic topic = new JmsTemporaryTopic(destinationName);
        this.createResource(topic);
        this.tempDestinations.put(topic, topic);
        topic.setConnection(this);
        return topic;
    }

    protected void deleteTemporaryDestination(JmsTemporaryDestination destination) throws JMSException {
        this.checkClosedOrFailed();
        this.connect();
        try {
            for (JmsSession session : this.sessions.values()) {
                if (!session.isDestinationInUse(destination)) continue;
                throw new IllegalStateException("A consumer is consuming from the temporary destination");
            }
            this.tempDestinations.remove(destination);
            this.destroyResource(destination);
        }
        catch (Exception e) {
            throw JmsExceptionSupport.create(e);
        }
    }

    protected void checkClosedOrFailed() throws JMSException {
        this.checkClosed();
        if (this.failed.get()) {
            throw new JmsConnectionFailedException(this.firstFailureError);
        }
    }

    protected void checkConsumeFromTemporaryDestination(JmsTemporaryDestination destination) throws JMSException {
        if (!this.equals(destination.getConnection())) {
            throw new InvalidDestinationException("Can't consume from a temporary destination created using another connection");
        }
    }

    protected boolean isTemporaryDestinationDeleted(JmsDestination destination) {
        return !this.tempDestinations.containsKey(destination);
    }

    protected void checkClosed() throws IllegalStateException {
        if (this.closed.get()) {
            throw new IllegalStateException("The Connection is closed");
        }
    }

    protected JmsSessionId getNextSessionId() {
        return new JmsSessionId(this.connectionInfo.getConnectionId(), this.sessionIdGenerator.incrementAndGet());
    }

    protected JmsTransactionId getNextTransactionId() {
        return new JmsTransactionId(this.connectionInfo.getConnectionId(), this.transactionIdGenerator.incrementAndGet());
    }

    protected synchronized boolean isExplicitClientID() {
        return this.clientIdSet;
    }

    void createResource(JmsResource resource) throws JMSException {
        this.checkClosedOrFailed();
        try {
            ProviderFuture request = new ProviderFuture();
            this.provider.create(resource, request);
            request.sync();
        }
        catch (Exception ex) {
            throw JmsExceptionSupport.create(ex);
        }
    }

    void startResource(JmsResource resource) throws JMSException {
        this.connect();
        try {
            ProviderFuture request = new ProviderFuture();
            this.provider.start(resource, request);
            request.sync();
        }
        catch (Exception ioe) {
            throw JmsExceptionSupport.create(ioe);
        }
    }

    void stopResource(JmsResource resource) throws JMSException {
        this.connect();
        try {
            ProviderFuture request = new ProviderFuture();
            this.provider.stop(resource, request);
            request.sync();
        }
        catch (Exception ioe) {
            throw JmsExceptionSupport.create(ioe);
        }
    }

    void destroyResource(JmsResource resource) throws JMSException {
        this.connect();
        try {
            ProviderFuture request = new ProviderFuture();
            this.provider.destroy(resource, request);
            request.sync();
        }
        catch (Exception ioe) {
            throw JmsExceptionSupport.create(ioe);
        }
    }

    void send(JmsOutboundMessageDispatch envelope) throws JMSException {
        this.checkClosedOrFailed();
        this.connect();
        try {
            ProviderFuture request = new ProviderFuture();
            this.provider.send(envelope, request);
            request.sync();
        }
        catch (Exception ioe) {
            throw JmsExceptionSupport.create(ioe);
        }
    }

    void acknowledge(JmsInboundMessageDispatch envelope, ProviderConstants.ACK_TYPE ackType) throws JMSException {
        this.checkClosedOrFailed();
        this.connect();
        try {
            ProviderFuture request = new ProviderFuture();
            this.provider.acknowledge(envelope, ackType, request);
            request.sync();
        }
        catch (Exception ioe) {
            throw JmsExceptionSupport.create(ioe);
        }
    }

    void acknowledge(JmsSessionId sessionId) throws JMSException {
        this.checkClosedOrFailed();
        this.connect();
        try {
            ProviderFuture request = new ProviderFuture();
            this.provider.acknowledge(sessionId, request);
            request.sync();
        }
        catch (Exception ioe) {
            throw JmsExceptionSupport.create(ioe);
        }
    }

    void unsubscribe(String name) throws JMSException {
        this.checkClosedOrFailed();
        this.connect();
        try {
            ProviderFuture request = new ProviderFuture();
            this.provider.unsubscribe(name, request);
            request.sync();
        }
        catch (Exception ioe) {
            throw JmsExceptionSupport.create(ioe);
        }
    }

    void commit(JmsSessionId sessionId) throws JMSException {
        this.checkClosedOrFailed();
        this.connect();
        try {
            ProviderFuture request = new ProviderFuture();
            this.provider.commit(sessionId, request);
            request.sync();
        }
        catch (Exception ioe) {
            throw JmsExceptionSupport.create(ioe);
        }
    }

    void rollback(JmsSessionId sessionId) throws JMSException {
        this.checkClosedOrFailed();
        this.connect();
        try {
            ProviderFuture request = new ProviderFuture();
            this.provider.rollback(sessionId, request);
            request.sync();
        }
        catch (Exception ioe) {
            throw JmsExceptionSupport.create(ioe);
        }
    }

    void recover(JmsSessionId sessionId) throws JMSException {
        this.checkClosedOrFailed();
        this.connect();
        try {
            ProviderFuture request = new ProviderFuture();
            this.provider.recover(sessionId, request);
            request.sync();
        }
        catch (Exception ioe) {
            throw JmsExceptionSupport.create(ioe);
        }
    }

    void pull(JmsConsumerId consumerId, long timeout) throws JMSException {
        this.checkClosedOrFailed();
        this.connect();
        try {
            ProviderFuture request = new ProviderFuture();
            this.provider.pull(consumerId, timeout, request);
            request.sync();
        }
        catch (Exception ioe) {
            throw JmsExceptionSupport.create(ioe);
        }
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        this.checkClosedOrFailed();
        return this.exceptionListener;
    }

    public void setExceptionListener(ExceptionListener listener) throws JMSException {
        this.checkClosedOrFailed();
        this.exceptionListener = listener;
    }

    public void addConnectionListener(JmsConnectionListener listener) {
        this.connectionListeners.add(listener);
    }

    public boolean removeConnectionListener(JmsConnectionListener listener) {
        return this.connectionListeners.remove(listener);
    }

    public boolean isForceAsyncSend() {
        return this.connectionInfo.isForceAsyncSend();
    }

    public void setForceAsyncSend(boolean forceAsyncSend) {
        this.connectionInfo.setForceAsyncSends(forceAsyncSend);
    }

    public boolean isAlwaysSyncSend() {
        return this.connectionInfo.isAlwaysSyncSend();
    }

    public void setAlwaysSyncSend(boolean alwaysSyncSend) {
        this.connectionInfo.setAlwaysSyncSend(alwaysSyncSend);
    }

    public String getTopicPrefix() {
        return this.connectionInfo.getTopicPrefix();
    }

    public void setTopicPrefix(String topicPrefix) {
        this.connectionInfo.setTopicPrefix(topicPrefix);
    }

    public String getQueuePrefix() {
        return this.connectionInfo.getQueuePrefix();
    }

    public void setQueuePrefix(String queuePrefix) {
        this.connectionInfo.setQueuePrefix(queuePrefix);
    }

    public JmsPrefetchPolicy getPrefetchPolicy() {
        return this.prefetchPolicy;
    }

    public void setPrefetchPolicy(JmsPrefetchPolicy prefetchPolicy) {
        this.prefetchPolicy = prefetchPolicy;
    }

    public boolean isLocalMessagePriority() {
        return this.localMessagePriority;
    }

    public void setLocalMessagePriority(boolean localMessagePriority) {
        this.localMessagePriority = localMessagePriority;
    }

    public long getCloseTimeout() {
        return this.connectionInfo.getCloseTimeout();
    }

    public void setCloseTimeout(long closeTimeout) {
        this.connectionInfo.setCloseTimeout(closeTimeout);
    }

    public long getConnectTimeout() {
        return this.connectionInfo.getConnectTimeout();
    }

    public void setConnectTimeout(long connectTimeout) {
        this.connectionInfo.setConnectTimeout(connectTimeout);
    }

    public long getSendTimeout() {
        return this.connectionInfo.getSendTimeout();
    }

    public void setSendTimeout(long sendTimeout) {
        this.connectionInfo.setSendTimeout(sendTimeout);
    }

    public long getRequestTimeout() {
        return this.connectionInfo.getRequestTimeout();
    }

    public void setRequestTimeout(long requestTimeout) {
        this.connectionInfo.setRequestTimeout(requestTimeout);
    }

    public URI getConfiguredURI() {
        return this.configuredURI;
    }

    void setConfiguredURI(URI uri) {
        this.configuredURI = uri;
    }

    public URI getConnectedURI() {
        return this.connectedURI;
    }

    void setConnectedURI(URI connectedURI) {
        this.connectedURI = connectedURI;
    }

    public String getUsername() {
        return this.connectionInfo.getUsername();
    }

    void setUsername(String username) {
        this.connectionInfo.setUsername(username);
    }

    public String getPassword() {
        return this.connectionInfo.getPassword();
    }

    void setPassword(String password) {
        this.connectionInfo.setPassword(password);
    }

    public boolean isConnected() {
        return this.connected.get();
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public JmsConnectionId getConnectionId() {
        return this.connectionInfo.getConnectionId();
    }

    public JmsMessageFactory getMessageFactory() {
        if (this.messageFactory == null) {
            throw new RuntimeException("Message factory should never be null");
        }
        return this.messageFactory;
    }

    void setMessageFactory(JmsMessageFactory factory) {
        this.messageFactory = factory;
    }

    public boolean isSendAcksAsync() {
        return this.sendAcksAsync;
    }

    public void setSendAcksAsync(boolean sendAcksAsync) {
        this.sendAcksAsync = sendAcksAsync;
    }

    @Override
    public void onInboundMessage(final JmsInboundMessageDispatch envelope) {
        JmsMessageDispatcher dispatcher;
        JmsMessage incoming = envelope.getMessage();
        if (incoming != null) {
            incoming.setReadOnlyBody(true);
            incoming.setReadOnlyProperties(true);
        }
        if ((dispatcher = this.dispatchers.get(envelope.getConsumerId())) != null) {
            dispatcher.onInboundMessage(envelope);
        }
        for (final JmsConnectionListener listener : this.connectionListeners) {
            this.executor.submit(new Runnable(){

                @Override
                public void run() {
                    listener.onInboundMessage(envelope);
                }
            });
        }
    }

    @Override
    public void onConnectionInterrupted(final URI remoteURI) {
        for (JmsSession session : this.sessions.values()) {
            session.onConnectionInterrupted();
        }
        for (final JmsConnectionListener listener : this.connectionListeners) {
            this.executor.submit(new Runnable(){

                @Override
                public void run() {
                    listener.onConnectionInterrupted(remoteURI);
                }
            });
        }
    }

    @Override
    public void onConnectionRecovery(Provider provider) throws Exception {
        LOG.debug("Connection {} is starting recovery.", (Object)this.connectionInfo.getConnectionId());
        ProviderFuture request = new ProviderFuture();
        provider.create(this.connectionInfo, request);
        request.sync();
        for (JmsTemporaryDestination tempDestination : this.tempDestinations.values()) {
            this.createResource(tempDestination);
        }
        for (JmsSession session : this.sessions.values()) {
            session.onConnectionRecovery(provider);
        }
    }

    @Override
    public void onConnectionRecovered(Provider provider) throws Exception {
        LOG.debug("Connection {} is finalizing recovery.", (Object)this.connectionInfo.getConnectionId());
        this.setMessageFactory(provider.getMessageFactory());
        this.setConnectedURI(provider.getRemoteURI());
        for (JmsSession session : this.sessions.values()) {
            session.onConnectionRecovered(provider);
        }
    }

    @Override
    public void onConnectionRestored(final URI remoteURI) {
        for (JmsSession session : this.sessions.values()) {
            session.onConnectionRestored();
        }
        for (final JmsConnectionListener listener : this.connectionListeners) {
            this.executor.submit(new Runnable(){

                @Override
                public void run() {
                    listener.onConnectionRestored(remoteURI);
                }
            });
        }
    }

    @Override
    public void onConnectionEstablished(final URI remoteURI) {
        LOG.info("Connection {} connected to remote Broker: {}", (Object)this.connectionInfo.getConnectionId(), (Object)remoteURI);
        this.setMessageFactory(this.provider.getMessageFactory());
        this.setConnectedURI(this.provider.getRemoteURI());
        for (final JmsConnectionListener listener : this.connectionListeners) {
            this.executor.submit(new Runnable(){

                @Override
                public void run() {
                    listener.onConnectionEstablished(remoteURI);
                }
            });
        }
    }

    @Override
    public void onConnectionFailure(final IOException ex) {
        this.onAsyncException(ex);
        if (!this.closing.get() && !this.closed.get()) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    JmsConnection.this.providerFailed(ex);
                    if (JmsConnection.this.provider != null) {
                        try {
                            JmsConnection.this.provider.close();
                        }
                        catch (Throwable error) {
                            LOG.debug("Error while closing failed Provider: {}", (Object)error.getMessage());
                        }
                    }
                    try {
                        JmsConnection.this.shutdown();
                    }
                    catch (JMSException e) {
                        LOG.warn("Exception during connection cleanup, " + (Object)((Object)e), (Throwable)e);
                    }
                    for (JmsConnectionListener listener : JmsConnection.this.connectionListeners) {
                        listener.onConnectionFailure(ex);
                    }
                }
            });
        }
    }

    @Override
    public void onResourceRemotelyClosed(final JmsResource resource, final Exception cause) {
        if (!this.closing.get() && !this.closed.get()) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (resource instanceof JmsSessionInfo) {
                        JmsSession session = (JmsSession)JmsConnection.this.sessions.get(((JmsSessionInfo)resource).getSessionId());
                        if (session != null) {
                            session.remotelyClosed(cause);
                        }
                    } else if (resource instanceof JmsProducerInfo) {
                        JmsSessionId parentId = ((JmsProducerInfo)resource).getParentId();
                        JmsSession session = (JmsSession)JmsConnection.this.sessions.get(parentId);
                        if (session != null) {
                            session.resourceRemotelyClosed(resource, cause);
                        }
                    } else if (resource instanceof JmsConsumerInfo) {
                        JmsSessionId parentId = ((JmsConsumerInfo)resource).getParentId();
                        JmsSession session = (JmsSession)JmsConnection.this.sessions.get(parentId);
                        if (session != null) {
                            session.resourceRemotelyClosed(resource, cause);
                        }
                    } else {
                        LOG.info("A JMS resource has been remotely closed: {}", (Object)resource);
                    }
                }
            });
        }
    }

    public void onAsyncException(Throwable error) {
        if (!this.closed.get() && !this.closing.get()) {
            if (this.exceptionListener != null) {
                if (!(error instanceof JMSException)) {
                    error = JmsExceptionSupport.create(error);
                }
                final JMSException jmsError = (JMSException)error;
                this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        JmsConnection.this.exceptionListener.onException(jmsError);
                    }
                });
            } else {
                LOG.debug("Async exception with no exception listener: {}", (Object)error, (Object)error);
            }
        }
    }

    protected void providerFailed(IOException error) {
        this.failed.set(true);
        if (this.firstFailureError == null) {
            this.firstFailureError = error;
        }
    }
}

