/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import org.apache.qpid.jms.JmsDestination;
import org.apache.qpid.jms.JmsMessageConsumer;
import org.apache.qpid.jms.JmsSession;
import org.apache.qpid.jms.message.JmsInboundMessageDispatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsQueueBrowser
implements QueueBrowser,
Enumeration<Message> {
    protected static final Logger LOG = LoggerFactory.getLogger(JmsQueueBrowser.class);
    private final JmsSession session;
    private final JmsDestination destination;
    private final String selector;
    private JmsMessageConsumer consumer;
    private final AtomicBoolean browseDone = new AtomicBoolean(false);
    private Message next;
    private final AtomicBoolean closed = new AtomicBoolean();
    private final Object semaphore = new Object();

    protected JmsQueueBrowser(JmsSession session, JmsDestination destination, String selector) throws JMSException {
        this.session = session;
        this.destination = destination;
        this.selector = selector;
    }

    private void destroyConsumer() {
        if (this.consumer == null) {
            return;
        }
        try {
            if (this.session.getTransacted()) {
                this.session.commit();
            }
            this.consumer.close();
            this.consumer = null;
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
    }

    public Enumeration<Message> getEnumeration() throws JMSException {
        this.checkClosed();
        if (this.consumer == null) {
            this.consumer = this.createConsumer();
        }
        return this;
    }

    private void checkClosed() throws IllegalStateException {
        if (this.closed.get()) {
            throw new IllegalStateException("The Consumer is closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasMoreElements() {
        while (true) {
            JmsQueueBrowser jmsQueueBrowser = this;
            synchronized (jmsQueueBrowser) {
                if (this.consumer == null) {
                    return false;
                }
            }
            if (this.next == null) {
                try {
                    this.next = this.consumer.receiveNoWait();
                }
                catch (JMSException e) {
                    LOG.warn("Error while receive the next message: {}", (Object)e.getMessage());
                }
                if (this.next != null) {
                    return true;
                }
            } else {
                return true;
            }
            if (this.browseDone.get() || !this.session.isStarted()) {
                this.destroyConsumer();
                return false;
            }
            this.waitForMessage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message nextElement() {
        JmsQueueBrowser jmsQueueBrowser = this;
        synchronized (jmsQueueBrowser) {
            if (this.consumer == null) {
                return null;
            }
        }
        if (this.hasMoreElements()) {
            Message message = this.next;
            this.next = null;
            return message;
        }
        if (this.browseDone.get() || !this.session.isStarted()) {
            this.destroyConsumer();
            return null;
        }
        throw new NoSuchElementException();
    }

    public void close() throws JMSException {
        if (this.closed.compareAndSet(false, true)) {
            this.browseDone.set(true);
            this.destroyConsumer();
        }
    }

    public Queue getQueue() throws JMSException {
        return (Queue)this.destination;
    }

    public String getMessageSelector() throws JMSException {
        return this.selector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForMessage() {
        try {
            Object object = this.semaphore;
            synchronized (object) {
                this.semaphore.wait(2000L);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyMessageAvailable() {
        Object object = this.semaphore;
        synchronized (object) {
            this.semaphore.notifyAll();
        }
    }

    public String toString() {
        JmsMessageConsumer consumer = this.consumer;
        return "JmsQueueBrowser { value=" + (consumer != null ? consumer.getConsumerId() : "null") + " }";
    }

    private JmsMessageConsumer createConsumer() throws JMSException {
        this.browseDone.set(false);
        JmsMessageConsumer rc = new JmsMessageConsumer(this.session.getNextConsumerId(), this.session, this.destination, this.selector, false){

            @Override
            public boolean isBrowser() {
                return true;
            }

            @Override
            public void onInboundMessage(JmsInboundMessageDispatch envelope) {
                if (envelope.getMessage() == null) {
                    JmsQueueBrowser.this.browseDone.set(true);
                } else {
                    super.onInboundMessage(envelope);
                }
                JmsQueueBrowser.this.notifyMessageAvailable();
            }
        };
        rc.init();
        return rc;
    }
}

