/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp;

import java.util.HashMap;
import java.util.Map;
import javax.jms.IllegalStateException;
import org.apache.qpid.jms.meta.JmsConsumerId;
import org.apache.qpid.jms.meta.JmsConsumerInfo;
import org.apache.qpid.jms.meta.JmsProducerId;
import org.apache.qpid.jms.meta.JmsProducerInfo;
import org.apache.qpid.jms.meta.JmsSessionId;
import org.apache.qpid.jms.meta.JmsSessionInfo;
import org.apache.qpid.jms.meta.JmsTransactionId;
import org.apache.qpid.jms.provider.AsyncResult;
import org.apache.qpid.jms.provider.amqp.AmqpAbstractResource;
import org.apache.qpid.jms.provider.amqp.AmqpAnonymousFallbackProducer;
import org.apache.qpid.jms.provider.amqp.AmqpConnection;
import org.apache.qpid.jms.provider.amqp.AmqpConsumer;
import org.apache.qpid.jms.provider.amqp.AmqpFixedProducer;
import org.apache.qpid.jms.provider.amqp.AmqpProducer;
import org.apache.qpid.jms.provider.amqp.AmqpProvider;
import org.apache.qpid.jms.provider.amqp.AmqpQueueBrowser;
import org.apache.qpid.jms.provider.amqp.AmqpTransactionContext;
import org.apache.qpid.proton.engine.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpSession
extends AmqpAbstractResource<JmsSessionInfo, Session> {
    private static final Logger LOG = LoggerFactory.getLogger(AmqpSession.class);
    private final AmqpConnection connection;
    private final AmqpTransactionContext txContext;
    private final Map<JmsConsumerId, AmqpConsumer> consumers = new HashMap<JmsConsumerId, AmqpConsumer>();

    public AmqpSession(AmqpConnection connection, JmsSessionInfo info) {
        super(info, connection.getProtonConnection().session());
        this.connection = connection;
        ((JmsSessionInfo)this.resource).getSessionId().setProviderHint(this);
        this.txContext = ((JmsSessionInfo)this.resource).isTransacted() ? new AmqpTransactionContext(this) : null;
    }

    @Override
    public void opened() {
        if (this.txContext != null) {
            this.txContext.open(this.openRequest);
        } else {
            super.opened();
        }
    }

    @Override
    protected void doOpen() {
        ((Session)this.getEndpoint()).setIncomingCapacity(Integer.MAX_VALUE);
        this.connection.addSession(this);
        super.doOpen();
    }

    @Override
    protected void doClose() {
        this.connection.removeSession(this);
        super.doClose();
    }

    public void acknowledge() {
        for (AmqpConsumer consumer : this.consumers.values()) {
            consumer.acknowledge();
        }
    }

    public void recover() throws Exception {
        for (AmqpConsumer consumer : this.consumers.values()) {
            consumer.recover();
        }
    }

    public AmqpProducer createProducer(JmsProducerInfo producerInfo) {
        AmqpProducer producer = null;
        if (producerInfo.getDestination() != null || this.connection.getProperties().isAnonymousRelaySupported()) {
            LOG.debug("Creating AmqpFixedProducer for: {}", (Object)producerInfo.getDestination());
            producer = new AmqpFixedProducer(this, producerInfo);
        } else {
            LOG.debug("Creating an AmqpAnonymousFallbackProducer");
            producer = new AmqpAnonymousFallbackProducer(this, producerInfo);
        }
        ((AmqpProducer)producer).setPresettle(this.connection.isPresettleProducers());
        return producer;
    }

    public AmqpProducer getProducer(JmsProducerInfo producerInfo) {
        return this.getProducer(producerInfo.getProducerId());
    }

    public AmqpProducer getProducer(JmsProducerId producerId) {
        if (producerId.getProviderHint() instanceof AmqpProducer) {
            return (AmqpProducer)producerId.getProviderHint();
        }
        return null;
    }

    public AmqpConsumer createConsumer(JmsConsumerInfo consumerInfo) {
        AmqpConsumer result = null;
        result = consumerInfo.isBrowser() ? new AmqpQueueBrowser(this, consumerInfo) : new AmqpConsumer(this, consumerInfo);
        result.setPresettle(this.connection.isPresettleConsumers());
        return result;
    }

    public AmqpConsumer getConsumer(JmsConsumerInfo consumerInfo) {
        return this.getConsumer(consumerInfo.getConsumerId());
    }

    public AmqpConsumer getConsumer(JmsConsumerId consumerId) {
        if (consumerId.getProviderHint() instanceof AmqpConsumer) {
            return (AmqpConsumer)consumerId.getProviderHint();
        }
        return this.consumers.get(consumerId);
    }

    public AmqpTransactionContext getTransactionContext() {
        return this.txContext;
    }

    public void begin(JmsTransactionId txId, AsyncResult request) throws Exception {
        if (!((JmsSessionInfo)this.resource).isTransacted()) {
            throw new IllegalStateException("Non-transacted Session cannot start a TX.");
        }
        this.getTransactionContext().begin(txId, request);
    }

    public void commit(AsyncResult request) throws Exception {
        if (!((JmsSessionInfo)this.resource).isTransacted()) {
            throw new IllegalStateException("Non-transacted Session cannot start a TX.");
        }
        this.getTransactionContext().commit(request);
    }

    public void rollback(AsyncResult request) throws Exception {
        if (!((JmsSessionInfo)this.resource).isTransacted()) {
            throw new IllegalStateException("Non-transacted Session cannot start a TX.");
        }
        this.getTransactionContext().rollback(request);
    }

    void addResource(AmqpConsumer consumer) {
        this.consumers.put(consumer.getConsumerId(), consumer);
    }

    void removeResource(AmqpConsumer consumer) {
        this.consumers.remove(consumer.getConsumerId());
    }

    public boolean containsSubscription(String subscriptionName) {
        for (AmqpConsumer consumer : this.consumers.values()) {
            if (!subscriptionName.equals(((JmsConsumerInfo)consumer.getJmsResource()).getSubscriptionName())) continue;
            return true;
        }
        return false;
    }

    public void reportError(Exception error) {
        this.getConnection().getProvider().fireProviderException(error);
    }

    public AmqpProvider getProvider() {
        return this.connection.getProvider();
    }

    public AmqpConnection getConnection() {
        return this.connection;
    }

    public JmsSessionId getSessionId() {
        return ((JmsSessionInfo)this.resource).getSessionId();
    }

    public Session getProtonSession() {
        return (Session)this.getEndpoint();
    }

    boolean isTransacted() {
        return ((JmsSessionInfo)this.resource).isTransacted();
    }

    boolean isAsyncAck() {
        return ((JmsSessionInfo)this.resource).isSendAcksAsync() || this.isTransacted();
    }

    public String toString() {
        return "AmqpSession { " + this.getSessionId() + " }";
    }
}

