/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.failover;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.jms.JMSException;
import org.apache.qpid.jms.message.JmsInboundMessageDispatch;
import org.apache.qpid.jms.message.JmsMessageFactory;
import org.apache.qpid.jms.message.JmsOutboundMessageDispatch;
import org.apache.qpid.jms.meta.JmsConnectionInfo;
import org.apache.qpid.jms.meta.JmsConsumerId;
import org.apache.qpid.jms.meta.JmsResource;
import org.apache.qpid.jms.meta.JmsSessionId;
import org.apache.qpid.jms.provider.AsyncResult;
import org.apache.qpid.jms.provider.DefaultProviderListener;
import org.apache.qpid.jms.provider.Provider;
import org.apache.qpid.jms.provider.ProviderConstants;
import org.apache.qpid.jms.provider.ProviderFactory;
import org.apache.qpid.jms.provider.ProviderFuture;
import org.apache.qpid.jms.provider.ProviderListener;
import org.apache.qpid.jms.provider.failover.FailoverUriPool;
import org.apache.qpid.jms.util.IOExceptionSupport;
import org.apache.qpid.jms.util.ThreadPoolUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailoverProvider
extends DefaultProviderListener
implements Provider {
    private static final Logger LOG = LoggerFactory.getLogger(FailoverProvider.class);
    public static final int UNLIMITED = -1;
    public static final int DEFAULT_MAX_RECONNECT_ATTEMPTS = -1;
    public static final int DEFAULT_STARTUP_MAX_RECONNECT_ATTEMPTS = -1;
    public static final long DEFAULT_INITIAL_RECONNECT_DELAY = 0L;
    public static final long DEFAULT_RECONNECT_DELAY = 10L;
    public static final long DEFAULT_MAX_RECONNECT_DELAY = TimeUnit.SECONDS.toMillis(30L);
    public static final boolean DEFAULT_USE_RECONNECT_BACKOFF = true;
    public static final double DEFAULT_RECONNECT_BACKOFF_MULTIPLIER = 2.0;
    public static final int DEFAULT_WARN_AFTER_RECONNECT_ATTEMPTS = 10;
    private ProviderListener listener;
    private Provider provider;
    private final FailoverUriPool uris;
    private final ExecutorService serializer;
    private final ScheduledExecutorService connectionHub;
    private final AtomicBoolean closed = new AtomicBoolean();
    private final AtomicBoolean failed = new AtomicBoolean();
    private final AtomicLong requestId = new AtomicLong();
    private final Map<Long, FailoverRequest> requests = new LinkedHashMap<Long, FailoverRequest>();
    private final DefaultProviderListener closedListener = new DefaultProviderListener();
    private final AtomicReference<JmsMessageFactory> messageFactory = new AtomicReference();
    private boolean firstConnection = true;
    private long reconnectAttempts;
    private long nextReconnectDelay = -1L;
    private IOException failureCause;
    private URI connectedURI;
    private long connectTimeout = 15000L;
    private long closeTimeout = 15000L;
    private long sendTimeout = -1L;
    private long requestTimeout = -1L;
    private long initialReconnectDelay = 0L;
    private long reconnectDelay = 10L;
    private long maxReconnectDelay = DEFAULT_MAX_RECONNECT_DELAY;
    private boolean useReconnectBackOff = true;
    private double reconnectBackOffMultiplier = 2.0;
    private int maxReconnectAttempts = -1;
    private int startupMaxReconnectAttempts = -1;
    private int warnAfterReconnectAttempts = 10;

    public FailoverProvider(Map<String, String> nestedOptions) {
        this(null, nestedOptions);
    }

    public FailoverProvider(List<URI> uris) {
        this(uris, null);
    }

    public FailoverProvider(List<URI> uris, Map<String, String> nestedOptions) {
        this.uris = new FailoverUriPool(uris, nestedOptions);
        this.serializer = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runner) {
                Thread serial = new Thread(runner);
                serial.setDaemon(true);
                serial.setName("FailoverProvider: serialization thread");
                return serial;
            }
        });
        this.connectionHub = Executors.newScheduledThreadPool(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runner) {
                Thread serial = new Thread(runner);
                serial.setDaemon(true);
                serial.setName("FailoverProvider: connect thread");
                return serial;
            }
        });
    }

    @Override
    public void connect() throws IOException {
        this.checkClosed();
        LOG.debug("Initiating initial connection attempt task");
        this.triggerReconnectionAttempt();
    }

    @Override
    public void start() throws IOException, IllegalStateException {
        this.checkClosed();
        if (this.listener == null) {
            throw new IllegalStateException("No ProviderListener registered.");
        }
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            final ProviderFuture request = new ProviderFuture();
            this.serializer.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        IOException error = FailoverProvider.this.failureCause != null ? FailoverProvider.this.failureCause : new IOException("Connection closed");
                        ArrayList pending = new ArrayList(FailoverProvider.this.requests.values());
                        for (FailoverRequest request2 : pending) {
                            request2.onFailure(error);
                        }
                        if (FailoverProvider.this.provider != null) {
                            FailoverProvider.this.provider.close();
                        }
                    }
                    catch (Exception e) {
                        LOG.debug("Caught exception while closing connection");
                    }
                    finally {
                        ThreadPoolUtils.shutdownGraceful(FailoverProvider.this.connectionHub);
                        if (FailoverProvider.this.serializer != null) {
                            FailoverProvider.this.serializer.shutdown();
                        }
                        request.onSuccess();
                    }
                }
            });
            try {
                if (this.closeTimeout < 0L) {
                    request.sync();
                } else {
                    request.sync(this.closeTimeout, TimeUnit.MILLISECONDS);
                }
            }
            catch (IOException e) {
                LOG.warn("Error caught while closing Provider: ", (Object)e.getMessage());
            }
        }
    }

    @Override
    public void create(final JmsResource resource, AsyncResult request) throws IOException, JMSException, UnsupportedOperationException {
        this.checkClosed();
        FailoverRequest pending = null;
        pending = resource instanceof JmsConnectionInfo ? new CreateConnectionRequest(request){

            @Override
            public void doTask() throws Exception {
                JmsConnectionInfo connectionInfo = (JmsConnectionInfo)resource;
                FailoverProvider.this.connectTimeout = connectionInfo.getConnectTimeout();
                FailoverProvider.this.closeTimeout = connectionInfo.getCloseTimeout();
                FailoverProvider.this.sendTimeout = connectionInfo.getSendTimeout();
                FailoverProvider.this.requestTimeout = connectionInfo.getRequestTimeout();
                FailoverProvider.this.provider.create(resource, this);
            }

            public String toString() {
                return "create -> " + resource;
            }
        } : new FailoverRequest(request){

            @Override
            public void doTask() throws Exception {
                FailoverProvider.this.provider.create(resource, this);
            }

            public String toString() {
                return "create -> " + resource;
            }
        };
        this.serializer.execute(pending);
    }

    @Override
    public void start(final JmsResource resource, AsyncResult request) throws IOException, JMSException {
        this.checkClosed();
        FailoverRequest pending = new FailoverRequest(request){

            @Override
            public void doTask() throws Exception {
                FailoverProvider.this.provider.start(resource, this);
            }

            public String toString() {
                return "start -> " + resource;
            }
        };
        this.serializer.execute(pending);
    }

    @Override
    public void stop(final JmsResource resource, AsyncResult request) throws IOException, JMSException {
        this.checkClosed();
        FailoverRequest pending = new FailoverRequest(request){

            @Override
            public void doTask() throws Exception {
                FailoverProvider.this.provider.stop(resource, this);
            }

            public String toString() {
                return "stop -> " + resource;
            }
        };
        this.serializer.execute(pending);
    }

    @Override
    public void destroy(final JmsResource resourceId, AsyncResult request) throws IOException, JMSException, UnsupportedOperationException {
        this.checkClosed();
        FailoverRequest pending = new FailoverRequest(request){

            @Override
            public void doTask() throws IOException, JMSException, UnsupportedOperationException {
                FailoverProvider.this.provider.destroy(resourceId, this);
            }

            @Override
            public boolean succeedsWhenOffline() {
                return true;
            }

            public String toString() {
                return "destroy -> " + resourceId;
            }
        };
        this.serializer.execute(pending);
    }

    @Override
    public void send(final JmsOutboundMessageDispatch envelope, AsyncResult request) throws IOException, JMSException {
        this.checkClosed();
        FailoverRequest pending = new FailoverRequest(request){

            @Override
            public void doTask() throws Exception {
                FailoverProvider.this.provider.send(envelope, this);
            }

            public String toString() {
                return "send -> " + envelope;
            }
        };
        this.serializer.execute(pending);
    }

    @Override
    public void acknowledge(final JmsSessionId sessionId, AsyncResult request) throws IOException, JMSException {
        this.checkClosed();
        FailoverRequest pending = new FailoverRequest(request){

            @Override
            public void doTask() throws Exception {
                FailoverProvider.this.provider.acknowledge(sessionId, this);
            }

            @Override
            public boolean succeedsWhenOffline() {
                return true;
            }

            public String toString() {
                return "session acknowledge -> " + sessionId;
            }
        };
        this.serializer.execute(pending);
    }

    @Override
    public void acknowledge(final JmsInboundMessageDispatch envelope, final ProviderConstants.ACK_TYPE ackType, AsyncResult request) throws IOException, JMSException {
        this.checkClosed();
        FailoverRequest pending = new FailoverRequest(request){

            @Override
            public void doTask() throws Exception {
                FailoverProvider.this.provider.acknowledge(envelope, ackType, this);
            }

            @Override
            public boolean succeedsWhenOffline() {
                return true;
            }

            public String toString() {
                return "message acknowledge -> " + envelope + " ackType: " + (Object)((Object)ackType);
            }
        };
        this.serializer.execute(pending);
    }

    @Override
    public void commit(final JmsSessionId sessionId, AsyncResult request) throws IOException, JMSException, UnsupportedOperationException {
        this.checkClosed();
        FailoverRequest pending = new FailoverRequest(request){

            @Override
            public void doTask() throws Exception {
                FailoverProvider.this.provider.commit(sessionId, this);
            }

            @Override
            public boolean failureWhenOffline() {
                return true;
            }

            public String toString() {
                return "TX commit -> " + sessionId;
            }
        };
        this.serializer.execute(pending);
    }

    @Override
    public void rollback(final JmsSessionId sessionId, AsyncResult request) throws IOException, JMSException, UnsupportedOperationException {
        this.checkClosed();
        FailoverRequest pending = new FailoverRequest(request){

            @Override
            public void doTask() throws Exception {
                FailoverProvider.this.provider.rollback(sessionId, this);
            }

            @Override
            public boolean failureWhenOffline() {
                return true;
            }

            public String toString() {
                return "TX rollback -> " + sessionId;
            }
        };
        this.serializer.execute(pending);
    }

    @Override
    public void recover(final JmsSessionId sessionId, AsyncResult request) throws IOException, UnsupportedOperationException {
        this.checkClosed();
        FailoverRequest pending = new FailoverRequest(request){

            @Override
            public void doTask() throws Exception {
                FailoverProvider.this.provider.recover(sessionId, this);
            }

            @Override
            public boolean succeedsWhenOffline() {
                return true;
            }

            public String toString() {
                return "recover -> " + sessionId;
            }
        };
        this.serializer.execute(pending);
    }

    @Override
    public void unsubscribe(final String subscription, AsyncResult request) throws IOException, JMSException, UnsupportedOperationException {
        this.checkClosed();
        FailoverRequest pending = new FailoverRequest(request){

            @Override
            public void doTask() throws Exception {
                FailoverProvider.this.provider.unsubscribe(subscription, this);
            }

            public String toString() {
                return "unsubscribe -> " + subscription;
            }
        };
        this.serializer.execute(pending);
    }

    @Override
    public void pull(final JmsConsumerId consumerId, final long timeout, AsyncResult request) throws IOException, UnsupportedOperationException {
        this.checkClosed();
        FailoverRequest pending = new FailoverRequest(request){

            @Override
            public void doTask() throws Exception {
                FailoverProvider.this.provider.pull(consumerId, timeout, this);
            }

            public String toString() {
                return "message pull -> " + consumerId;
            }
        };
        this.serializer.execute(pending);
    }

    @Override
    public JmsMessageFactory getMessageFactory() {
        return this.messageFactory.get();
    }

    private void handleProviderFailure(IOException cause) {
        LOG.debug("handling Provider failure: {}", (Object)cause.getMessage());
        LOG.trace("stack", (Throwable)cause);
        this.provider.setProviderListener(this.closedListener);
        URI failedURI = this.provider.getRemoteURI();
        try {
            this.provider.close();
        }
        catch (Throwable error) {
            LOG.trace("Caught exception while closing failed provider: {}", (Object)error.getMessage());
        }
        this.provider = null;
        if (this.reconnectAllowed()) {
            ProviderListener listener = this.listener;
            if (listener != null) {
                listener.onConnectionInterrupted(failedURI);
            }
            this.triggerReconnectionAttempt();
        } else {
            ProviderListener listener = this.listener;
            if (listener != null) {
                listener.onConnectionFailure(cause);
            }
        }
    }

    private void initializeNewConnection(final Provider provider) {
        this.serializer.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    FailoverProvider.this.provider = provider;
                    provider.setProviderListener(FailoverProvider.this);
                    if (!FailoverProvider.this.firstConnection) {
                        LOG.debug("Signalling connection recovery: {}", (Object)provider);
                        FailoverProvider.this.listener.onConnectionRecovery(provider);
                        FailoverProvider.this.messageFactory.set(provider.getMessageFactory());
                        FailoverProvider.this.listener.onConnectionRecovered(provider);
                        FailoverProvider.this.listener.onConnectionRestored(provider.getRemoteURI());
                    }
                    ArrayList pending = new ArrayList(FailoverProvider.this.requests.values());
                    for (FailoverRequest request : pending) {
                        request.run();
                    }
                    FailoverProvider.this.nextReconnectDelay = FailoverProvider.this.reconnectDelay;
                    FailoverProvider.this.reconnectAttempts = 0L;
                    FailoverProvider.this.connectedURI = provider.getRemoteURI();
                    FailoverProvider.this.uris.connected();
                }
                catch (Throwable error) {
                    FailoverProvider.this.handleProviderFailure(IOExceptionSupport.create(error));
                }
            }
        });
    }

    private void triggerReconnectionAttempt() {
        if (this.closed.get() || this.failed.get()) {
            return;
        }
        this.connectionHub.execute(new Runnable(){

            @Override
            public void run() {
                if (FailoverProvider.this.provider != null || FailoverProvider.this.closed.get() || FailoverProvider.this.failed.get()) {
                    return;
                }
                int reconnectLimit = FailoverProvider.this.reconnectAttemptLimit();
                if (reconnectLimit != -1 && FailoverProvider.this.reconnectAttempts >= (long)reconnectLimit) {
                    return;
                }
                if (FailoverProvider.this.initialReconnectDelay > 0L && FailoverProvider.this.reconnectAttempts == 0L) {
                    LOG.trace("Delayed initial reconnect attempt will be in {} milliseconds", (Object)FailoverProvider.this.initialReconnectDelay);
                    FailoverProvider.this.connectionHub.schedule(this, FailoverProvider.this.initialReconnectDelay, TimeUnit.MILLISECONDS);
                    return;
                }
                FailoverProvider.this.reconnectAttempts++;
                Throwable failure = null;
                URI target = FailoverProvider.this.uris.getNext();
                if (target != null) {
                    Provider provider = null;
                    try {
                        LOG.debug("Connection attempt:[{}] to: {} in-progress", (Object)FailoverProvider.this.reconnectAttempts, (Object)target);
                        provider = ProviderFactory.create(target);
                        provider.connect();
                        FailoverProvider.this.initializeNewConnection(provider);
                        return;
                    }
                    catch (Throwable e) {
                        LOG.info("Connection attempt:[{}] to: {} failed", (Object)FailoverProvider.this.reconnectAttempts, (Object)target);
                        failure = e;
                        try {
                            provider.close();
                        }
                        catch (Throwable ex) {
                            // empty catch block
                        }
                    }
                }
                if (reconnectLimit != -1 && FailoverProvider.this.reconnectAttempts >= (long)reconnectLimit) {
                    LOG.error("Failed to connect after: " + FailoverProvider.this.reconnectAttempts + " attempt(s)");
                    FailoverProvider.this.failed.set(true);
                    FailoverProvider.this.failureCause = IOExceptionSupport.create(failure);
                    if (FailoverProvider.this.listener != null) {
                        FailoverProvider.this.listener.onConnectionFailure(FailoverProvider.this.failureCause);
                    }
                    return;
                }
                int warnInterval = FailoverProvider.this.getWarnAfterReconnectAttempts();
                if (warnInterval > 0 && FailoverProvider.this.reconnectAttempts % (long)warnInterval == 0L) {
                    LOG.warn("Failed to connect after: {} attempt(s) continuing to retry.", (Object)FailoverProvider.this.reconnectAttempts);
                }
                long delay = FailoverProvider.this.nextReconnectDelay();
                LOG.trace("Next reconnect attempt will be in {} milliseconds", (Object)delay);
                FailoverProvider.this.connectionHub.schedule(this, delay, TimeUnit.MILLISECONDS);
            }
        });
    }

    private boolean reconnectAllowed() {
        return this.reconnectAttemptLimit() != 0;
    }

    private int reconnectAttemptLimit() {
        int maxReconnectValue = this.maxReconnectAttempts;
        if (this.firstConnection && this.startupMaxReconnectAttempts != -1) {
            maxReconnectValue = this.startupMaxReconnectAttempts;
        }
        return maxReconnectValue;
    }

    private long nextReconnectDelay() {
        if (this.nextReconnectDelay == -1L) {
            this.nextReconnectDelay = this.reconnectDelay;
        }
        if (this.isUseReconnectBackOff() && this.reconnectAttempts > 1L) {
            this.nextReconnectDelay = (long)((double)this.nextReconnectDelay * this.getReconnectBackOffMultiplier());
            if (this.nextReconnectDelay > this.maxReconnectDelay) {
                this.nextReconnectDelay = this.maxReconnectDelay;
            }
        }
        return this.nextReconnectDelay;
    }

    protected void checkClosed() throws IOException {
        if (this.closed.get()) {
            throw new IOException("The Provider is already closed");
        }
    }

    @Override
    public void onInboundMessage(final JmsInboundMessageDispatch envelope) {
        if (this.closed.get() || this.failed.get()) {
            return;
        }
        this.serializer.execute(new Runnable(){

            @Override
            public void run() {
                if (!FailoverProvider.this.closed.get()) {
                    FailoverProvider.this.listener.onInboundMessage(envelope);
                }
            }
        });
    }

    @Override
    public void onConnectionFailure(final IOException ex) {
        if (this.closed.get() || this.failed.get()) {
            return;
        }
        this.serializer.execute(new Runnable(){

            @Override
            public void run() {
                if (!FailoverProvider.this.closed.get() && !FailoverProvider.this.failed.get()) {
                    LOG.debug("Failover: the provider reports failure: {}", (Object)ex.getMessage());
                    FailoverProvider.this.handleProviderFailure(ex);
                }
            }
        });
    }

    public void add(final URI uri) {
        this.serializer.execute(new Runnable(){

            @Override
            public void run() {
                FailoverProvider.this.uris.add(uri);
            }
        });
    }

    public void remove(final URI uri) {
        this.serializer.execute(new Runnable(){

            @Override
            public void run() {
                FailoverProvider.this.uris.remove(uri);
            }
        });
    }

    @Override
    public URI getRemoteURI() {
        Provider provider = this.provider;
        if (provider != null) {
            return provider.getRemoteURI();
        }
        return null;
    }

    @Override
    public void setProviderListener(ProviderListener listener) {
        this.listener = listener;
    }

    @Override
    public ProviderListener getProviderListener() {
        return this.listener;
    }

    public boolean isRandomize() {
        return this.uris.isRandomize();
    }

    public void setRandomize(boolean value) {
        this.uris.setRandomize(value);
    }

    public long getInitialReconnectDelay() {
        return this.initialReconnectDelay;
    }

    public void setInitialReconnectDelay(long initialReconnectDelay) {
        this.initialReconnectDelay = initialReconnectDelay;
    }

    public long getReconnectDelay() {
        return this.reconnectDelay;
    }

    public void setReconnectDelay(long reconnectDealy) {
        this.reconnectDelay = reconnectDealy;
    }

    public long getMaxReconnectDelay() {
        return this.maxReconnectDelay;
    }

    public void setMaxReconnectDelay(long maxReconnectDelay) {
        this.maxReconnectDelay = maxReconnectDelay;
    }

    public int getMaxReconnectAttempts() {
        return this.maxReconnectAttempts;
    }

    public void setMaxReconnectAttempts(int maxReconnectAttempts) {
        this.maxReconnectAttempts = maxReconnectAttempts;
    }

    public int getStartupMaxReconnectAttempts() {
        return this.startupMaxReconnectAttempts;
    }

    public void setStartupMaxReconnectAttempts(int startupMaxReconnectAttempts) {
        this.startupMaxReconnectAttempts = startupMaxReconnectAttempts;
    }

    public int getWarnAfterReconnectAttempts() {
        return this.warnAfterReconnectAttempts;
    }

    public void setWarnAfterReconnectAttempts(int warnAfterReconnectAttempts) {
        this.warnAfterReconnectAttempts = warnAfterReconnectAttempts;
    }

    public double getReconnectBackOffMultiplier() {
        return this.reconnectBackOffMultiplier;
    }

    public void setReconnectBackOffMultiplier(double reconnectBackOffMultiplier) {
        this.reconnectBackOffMultiplier = reconnectBackOffMultiplier;
    }

    public boolean isUseReconnectBackOff() {
        return this.useReconnectBackOff;
    }

    public void setUseReconnectBackOff(boolean useReconnectBackOff) {
        this.useReconnectBackOff = useReconnectBackOff;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public long getCloseTimeout() {
        return this.closeTimeout;
    }

    public long getSendTimeout() {
        return this.sendTimeout;
    }

    public long getRequestTimeout() {
        return this.requestTimeout;
    }

    public Map<String, String> getNestedOptions() {
        return this.uris.getNestedOptions();
    }

    public String toString() {
        return "FailoverProvider: " + (this.connectedURI == null ? "unconnected" : this.connectedURI.toString());
    }

    protected abstract class CreateConnectionRequest
    extends FailoverRequest {
        public CreateConnectionRequest(AsyncResult watcher) {
            super(watcher);
        }

        @Override
        public void onSuccess() {
            FailoverProvider.this.serializer.execute(new Runnable(){

                @Override
                public void run() {
                    if (FailoverProvider.this.firstConnection) {
                        LOG.trace("First connection requst has completed:");
                        FailoverProvider.this.messageFactory.set(FailoverProvider.this.provider.getMessageFactory());
                        FailoverProvider.this.listener.onConnectionEstablished(FailoverProvider.this.provider.getRemoteURI());
                        FailoverProvider.this.firstConnection = false;
                    } else {
                        LOG.warn("A second call to a CreateConnectionRequest not expected.");
                    }
                    CreateConnectionRequest.this.signalConnected();
                }
            });
        }

        public void signalConnected() {
            super.onSuccess();
        }
    }

    protected abstract class FailoverRequest
    extends ProviderFuture
    implements Runnable {
        private final long id;

        public FailoverRequest(AsyncResult watcher) {
            super(watcher);
            this.id = FailoverProvider.this.requestId.incrementAndGet();
        }

        @Override
        public void run() {
            FailoverProvider.this.requests.put(this.id, this);
            if (FailoverProvider.this.provider == null) {
                this.whenOffline(IOExceptionSupport.create(new IOException("Connection failed.")));
            } else {
                try {
                    LOG.debug("Executing Failover Task: {}", (Object)this);
                    this.doTask();
                }
                catch (UnsupportedOperationException e) {
                    FailoverProvider.this.requests.remove(this.id);
                    this.getWrappedRequest().onFailure(e);
                }
                catch (JMSException jmsEx) {
                    FailoverProvider.this.requests.remove(this.id);
                    this.getWrappedRequest().onFailure(jmsEx);
                }
                catch (Throwable e) {
                    LOG.debug("Caught exception while executing task: {} - {}", (Object)this, (Object)e.getMessage());
                    this.whenOffline(IOExceptionSupport.create(e));
                    FailoverProvider.this.handleProviderFailure(IOExceptionSupport.create(e));
                }
            }
        }

        @Override
        public void onFailure(final Throwable result) {
            if (FailoverProvider.this.closed.get() || FailoverProvider.this.failed.get()) {
                FailoverProvider.this.requests.remove(this.id);
                super.onFailure(result);
            } else {
                LOG.debug("Request received error: {}", (Object)result.getMessage());
                FailoverProvider.this.serializer.execute(new Runnable(){

                    @Override
                    public void run() {
                        FailoverProvider.this.handleProviderFailure(IOExceptionSupport.create(result));
                    }
                });
            }
        }

        @Override
        public void onSuccess() {
            FailoverProvider.this.requests.remove(this.id);
            super.onSuccess();
        }

        public abstract void doTask() throws Exception;

        public boolean succeedsWhenOffline() {
            return false;
        }

        public boolean failureWhenOffline() {
            return false;
        }

        private void whenOffline(IOException error) {
            if (this.failureWhenOffline()) {
                FailoverProvider.this.requests.remove(this.id);
                this.getWrappedRequest().onFailure(IOExceptionSupport.create(error));
            } else if (this.succeedsWhenOffline()) {
                this.onSuccess();
            } else {
                LOG.trace("Task {} held until connection recovered:", (Object)this);
            }
        }
    }
}

