/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.sasl;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.security.sasl.SaslException;
import org.apache.qpid.jms.sasl.AbstractMechanism;
import org.apache.qpid.jms.sasl.Mechanism;

public class CramMD5Mechanism
extends AbstractMechanism {
    private static final String ASCII = "ASCII";
    private static final String HMACMD5 = "HMACMD5";
    private boolean _sentResponse;

    @Override
    public int getPriority() {
        return Mechanism.PRIORITY.MEDIUM.getValue();
    }

    @Override
    public String getName() {
        return "CRAM-MD5";
    }

    @Override
    public byte[] getInitialResponse() {
        return EMPTY;
    }

    @Override
    public byte[] getChallengeResponse(byte[] challenge) throws SaslException {
        if (!this._sentResponse && challenge != null && challenge.length != 0) {
            try {
                SecretKeySpec key = new SecretKeySpec(this.getPassword().getBytes(ASCII), HMACMD5);
                Mac mac = Mac.getInstance(HMACMD5);
                mac.init(key);
                byte[] bytes = mac.doFinal(challenge);
                StringBuffer hash = new StringBuffer(this.getUsername());
                hash.append(' ');
                for (int i = 0; i < bytes.length; ++i) {
                    String hex = Integer.toHexString(0xFF & bytes[i]);
                    if (hex.length() == 1) {
                        hash.append('0');
                    }
                    hash.append(hex);
                }
                this._sentResponse = true;
                return hash.toString().getBytes(ASCII);
            }
            catch (UnsupportedEncodingException e) {
                throw new SaslException("Unable to utilise required encoding", e);
            }
            catch (InvalidKeyException e) {
                throw new SaslException("Unable to utilise key", e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new SaslException("Unable to utilise required algorithm", e);
            }
        }
        return EMPTY;
    }
}

