/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.sasl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.qpid.jms.sasl.Mechanism;
import org.apache.qpid.jms.sasl.MechanismFactory;
import org.apache.qpid.jms.util.FactoryFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaslMechanismFinder {
    private static final Logger LOG = LoggerFactory.getLogger(SaslMechanismFinder.class);
    private static final FactoryFinder<MechanismFactory> MECHANISM_FACTORY_FINDER = new FactoryFinder<MechanismFactory>(MechanismFactory.class, "META-INF/services/" + SaslMechanismFinder.class.getPackage().getName().replace(".", "/") + "/");

    public static Mechanism findMatchingMechanism(String ... remoteMechanisms) {
        Mechanism match = null;
        ArrayList<Mechanism> found = new ArrayList<Mechanism>();
        for (String remoteMechanism : remoteMechanisms) {
            try {
                MechanismFactory factory = SaslMechanismFinder.findMechanismFactory(remoteMechanism);
                found.add(factory.createMechanism());
            }
            catch (IOException e) {
                LOG.warn("Caught exception while searching for SASL mechanisms: {}", (Object)e.getMessage());
            }
        }
        if (!found.isEmpty()) {
            Collections.sort(found);
            match = (Mechanism)found.get(found.size() - 1);
        }
        LOG.info("Best match for SASL auth was: {}", match);
        return match;
    }

    protected static MechanismFactory findMechanismFactory(String name) throws IOException {
        if (name == null || name.isEmpty()) {
            throw new IOException("No Mechanism name specified.");
        }
        MechanismFactory factory = null;
        try {
            factory = MECHANISM_FACTORY_FINDER.newInstance(name);
        }
        catch (Throwable e) {
            throw new IOException("Mechanism scheme NOT recognized: [" + name + "]", e);
        }
        return factory;
    }
}

