/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.transports;

import io.netty.handler.ssl.SslHandler;
import java.io.File;
import java.io.FileInputStream;
import java.net.URI;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.qpid.jms.transports.TransportSslOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportSupport {
    private static final Logger LOG = LoggerFactory.getLogger(TransportSupport.class);

    public static SslHandler createSslHandler(URI remote, TransportSslOptions options) throws Exception {
        return new SslHandler(TransportSupport.createSslEngine(remote, TransportSupport.createSslContext(options), options));
    }

    public static SSLContext createSslContext(TransportSslOptions options) throws Exception {
        try {
            SSLContext context = SSLContext.getInstance("TLS");
            KeyManager[] keyMgrs = TransportSupport.loadKeyManagers(options);
            TrustManager[] trustManagers = options.isTrustAll() ? new TrustManager[]{TransportSupport.createTrustAllTrustManager()} : TransportSupport.loadTrustManagers(options);
            context.init(keyMgrs, trustManagers, new SecureRandom());
            return context;
        }
        catch (Exception e) {
            LOG.error("Failed to create SSLContext: {}", (Object)e, (Object)e);
            throw e;
        }
    }

    public static SSLEngine createSslEngine(SSLContext context, TransportSslOptions options) throws Exception {
        SSLEngine engine = context.createSSLEngine();
        engine.setEnabledProtocols(options.getEnabledProtocols());
        engine.setUseClientMode(true);
        if (options.isVerifyHost()) {
            SSLParameters sslParameters = engine.getSSLParameters();
            sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
            engine.setSSLParameters(sslParameters);
        }
        return engine;
    }

    public static SSLEngine createSslEngine(URI remote, SSLContext context, TransportSslOptions options) throws Exception {
        SSLEngine engine = context.createSSLEngine(remote.getHost(), remote.getPort());
        engine.setEnabledProtocols(options.getEnabledProtocols());
        engine.setUseClientMode(true);
        if (options.isVerifyHost()) {
            SSLParameters sslParameters = engine.getSSLParameters();
            sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
            engine.setSSLParameters(sslParameters);
        }
        return engine;
    }

    private static TrustManager[] loadTrustManagers(TransportSslOptions options) throws Exception {
        if (options.getTrustStoreLocation() == null) {
            return null;
        }
        TrustManagerFactory fact = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        String storeLocation = options.getTrustStoreLocation();
        String storePassword = options.getTrustStorePassword();
        String storeType = options.getStoreType();
        LOG.trace("Attempt to load TrustStore from location {} of type {}", (Object)storeLocation, (Object)storeType);
        KeyStore trustStore = TransportSupport.loadStore(storeLocation, storePassword, storeType);
        fact.init(trustStore);
        return fact.getTrustManagers();
    }

    private static KeyManager[] loadKeyManagers(TransportSslOptions options) throws Exception {
        if (options.getKeyStoreLocation() == null) {
            return null;
        }
        KeyManagerFactory fact = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        String storeLocation = options.getKeyStoreLocation();
        String storePassword = options.getKeyStorePassword();
        String storeType = options.getStoreType();
        LOG.trace("Attempt to load KeyStore from location {} of type {}", (Object)storeLocation, (Object)storeType);
        KeyStore keyStore = TransportSupport.loadStore(storeLocation, storePassword, storeType);
        fact.init(keyStore, storePassword != null ? storePassword.toCharArray() : null);
        return fact.getKeyManagers();
    }

    private static KeyStore loadStore(String storePath, String password, String storeType) throws Exception {
        KeyStore store = KeyStore.getInstance(storeType);
        try (FileInputStream in = new FileInputStream(new File(storePath));){
            store.load(in, password != null ? password.toCharArray() : null);
        }
        return store;
    }

    private static TrustManager createTrustAllTrustManager() {
        return new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
    }
}

