/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms;

import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import org.apache.qpid.jms.JmsConnection;
import org.apache.qpid.jms.JmsQueueConnection;
import org.apache.qpid.jms.JmsTopicConnection;
import org.apache.qpid.jms.exceptions.JmsExceptionSupport;
import org.apache.qpid.jms.jndi.JNDIStorable;
import org.apache.qpid.jms.message.JmsMessageIDBuilder;
import org.apache.qpid.jms.policy.JmsDefaultDeserializationPolicy;
import org.apache.qpid.jms.policy.JmsDefaultMessageIDPolicy;
import org.apache.qpid.jms.policy.JmsDefaultPrefetchPolicy;
import org.apache.qpid.jms.policy.JmsDefaultPresettlePolicy;
import org.apache.qpid.jms.policy.JmsDefaultRedeliveryPolicy;
import org.apache.qpid.jms.policy.JmsDeserializationPolicy;
import org.apache.qpid.jms.policy.JmsMessageIDPolicy;
import org.apache.qpid.jms.policy.JmsPrefetchPolicy;
import org.apache.qpid.jms.policy.JmsPresettlePolicy;
import org.apache.qpid.jms.policy.JmsRedeliveryPolicy;
import org.apache.qpid.jms.provider.Provider;
import org.apache.qpid.jms.provider.ProviderFactory;
import org.apache.qpid.jms.util.IdGenerator;
import org.apache.qpid.jms.util.PropertyUtil;
import org.apache.qpid.jms.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsConnectionFactory
extends JNDIStorable
implements ConnectionFactory,
QueueConnectionFactory,
TopicConnectionFactory {
    private static final Logger LOG = LoggerFactory.getLogger(JmsConnectionFactory.class);
    private static final String CLIENT_ID_PROP = "clientID";
    private static final String DEFAULT_REMOTE_HOST = "localhost";
    private static final String DEFAULT_REMOTE_PORT = "5672";
    public static final String REMOTE_URI_PROP = "remoteURI";
    private static String DEFAULT_REMOTE_URI;
    private URI remoteURI;
    private String username;
    private String password;
    private String clientID;
    private boolean forceAsyncSend;
    private boolean forceSyncSend;
    private boolean forceAsyncAcks;
    private boolean localMessagePriority;
    private boolean localMessageExpiry = true;
    private boolean receiveLocalOnly;
    private boolean receiveNoWaitLocalOnly;
    private boolean populateJMSXUserID;
    private String queuePrefix = null;
    private String topicPrefix = null;
    private boolean validatePropertyNames = true;
    private long sendTimeout = -1L;
    private long requestTimeout = -1L;
    private long closeTimeout = 15000L;
    private long connectTimeout = 15000L;
    private IdGenerator clientIdGenerator;
    private String clientIDPrefix;
    private IdGenerator connectionIdGenerator;
    private String connectionIDPrefix;
    private ExceptionListener exceptionListener;
    private JmsPrefetchPolicy prefetchPolicy = new JmsDefaultPrefetchPolicy();
    private JmsRedeliveryPolicy redeliveryPolicy = new JmsDefaultRedeliveryPolicy();
    private JmsPresettlePolicy presettlePolicy = new JmsDefaultPresettlePolicy();
    private JmsMessageIDPolicy messageIDPolicy = new JmsDefaultMessageIDPolicy();
    private JmsDeserializationPolicy deserializationPolicy = new JmsDefaultDeserializationPolicy();

    public JmsConnectionFactory() {
    }

    public JmsConnectionFactory(String username, String password) {
        this.setUsername(username);
        this.setPassword(password);
    }

    public JmsConnectionFactory(String remoteURI) {
        this(JmsConnectionFactory.createURI(remoteURI));
    }

    public JmsConnectionFactory(URI remoteURI) {
        this.setRemoteURI(remoteURI.toString());
    }

    public JmsConnectionFactory(String userName, String password, URI remoteURI) {
        this.setUsername(userName);
        this.setPassword(password);
        this.setRemoteURI(remoteURI.toString());
    }

    public JmsConnectionFactory(String userName, String password, String remoteURI) {
        this.setUsername(userName);
        this.setPassword(password);
        this.setRemoteURI(remoteURI);
    }

    @Override
    protected Map<String, String> buildFromProperties(Map<String, String> props) {
        String remoteURI = props.remove(REMOTE_URI_PROP);
        if (remoteURI != null) {
            this.setRemoteURI(remoteURI);
        }
        return PropertyUtil.setProperties((Object)this, props);
    }

    @Override
    protected void populateProperties(Map<String, String> props) {
        try {
            Map<String, String> result = PropertyUtil.getProperties(this);
            props.putAll(result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public TopicConnection createTopicConnection() throws JMSException {
        return this.createTopicConnection(this.getUsername(), this.getPassword());
    }

    public TopicConnection createTopicConnection(String username, String password) throws JMSException {
        try {
            String connectionId = this.getConnectionIdGenerator().generateId();
            Provider provider = this.createProvider(this.remoteURI);
            JmsTopicConnection result = new JmsTopicConnection(connectionId, provider, this.getClientIdGenerator());
            return this.configureConnection(result, username, password);
        }
        catch (Exception e) {
            throw JmsExceptionSupport.create(e);
        }
    }

    public Connection createConnection() throws JMSException {
        return this.createConnection(this.getUsername(), this.getPassword());
    }

    public Connection createConnection(String username, String password) throws JMSException {
        try {
            String connectionId = this.getConnectionIdGenerator().generateId();
            Provider provider = this.createProvider(this.remoteURI);
            JmsConnection result = new JmsConnection(connectionId, provider, this.getClientIdGenerator());
            return this.configureConnection(result, username, password);
        }
        catch (Exception e) {
            throw JmsExceptionSupport.create("Failed to create connection to: " + this.getRemoteURI(), e);
        }
    }

    public QueueConnection createQueueConnection() throws JMSException {
        return this.createQueueConnection(this.getUsername(), this.getPassword());
    }

    public QueueConnection createQueueConnection(String username, String password) throws JMSException {
        try {
            String connectionId = this.getConnectionIdGenerator().generateId();
            Provider provider = this.createProvider(this.remoteURI);
            JmsQueueConnection result = new JmsQueueConnection(connectionId, provider, this.getClientIdGenerator());
            return this.configureConnection(result, username, password);
        }
        catch (Exception e) {
            throw JmsExceptionSupport.create(e);
        }
    }

    protected <T extends JmsConnection> T configureConnection(T connection, String username, String password) throws JMSException {
        try {
            Map<String, String> properties = PropertyUtil.getProperties(this);
            boolean setClientID = false;
            if (properties.containsKey(CLIENT_ID_PROP)) {
                setClientID = true;
                properties.remove(CLIENT_ID_PROP);
            }
            connection.setMessageIDPolicy(this.messageIDPolicy.copy());
            connection.setPrefetchPolicy(this.prefetchPolicy.copy());
            connection.setPresettlePolicy(this.presettlePolicy.copy());
            connection.setRedeliveryPolicy(this.redeliveryPolicy.copy());
            PropertyUtil.setProperties(connection, properties);
            connection.setExceptionListener(this.exceptionListener);
            connection.setUsername(username);
            connection.setPassword(password);
            connection.setConfiguredURI(this.remoteURI);
            if (setClientID) {
                connection.setClientID(this.clientID);
            }
            return connection;
        }
        catch (Exception e) {
            throw JmsExceptionSupport.create(e);
        }
    }

    protected Provider createProvider(URI remoteURI) throws Exception {
        if (remoteURI == null) {
            remoteURI = new URI(JmsConnectionFactory.getDefaultRemoteAddress());
        }
        Provider result = null;
        try {
            result = ProviderFactory.create(remoteURI);
            result.connect();
        }
        catch (Exception ex) {
            LOG.error("Failed to create JMS Provider instance for: {}", (Object)remoteURI.getScheme());
            LOG.trace("Error: ", (Throwable)ex);
            throw ex;
        }
        return result;
    }

    protected static URI createURI(String name) {
        if (name != null && !name.trim().isEmpty()) {
            try {
                return new URI(name);
            }
            catch (URISyntaxException e) {
                throw (IllegalArgumentException)new IllegalArgumentException("Invalid remote URI: " + name).initCause(e);
            }
        }
        return null;
    }

    protected synchronized IdGenerator getConnectionIdGenerator() {
        if (this.connectionIdGenerator == null) {
            this.connectionIdGenerator = this.connectionIDPrefix != null ? new IdGenerator(this.connectionIDPrefix) : new IdGenerator();
        }
        return this.connectionIdGenerator;
    }

    protected synchronized void setConnectionIdGenerator(IdGenerator connectionIdGenerator) {
        this.connectionIdGenerator = connectionIdGenerator;
    }

    public String getRemoteURI() {
        return this.remoteURI != null ? this.remoteURI.toString() : JmsConnectionFactory.getDefaultRemoteAddress();
    }

    public void setRemoteURI(String remoteURI) {
        if (remoteURI == null) {
            throw new IllegalArgumentException("remoteURI cannot be null");
        }
        this.remoteURI = JmsConnectionFactory.createURI(remoteURI);
        if (this.remoteURI.getRawUserInfo() != null) {
            throw new IllegalArgumentException("The supplied URI cannot contain a User-Info section");
        }
        try {
            if (this.remoteURI.getQuery() != null) {
                Map<String, String> map = PropertyUtil.parseQuery(this.remoteURI.getQuery());
                this.applyURIOptions(map);
                this.remoteURI = PropertyUtil.replaceQuery(this.remoteURI, map);
            } else if (URISupport.isCompositeURI(this.remoteURI)) {
                URISupport.CompositeData data = URISupport.parseComposite(this.remoteURI);
                this.applyURIOptions(data.getParameters());
                this.remoteURI = data.toURI();
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    private void applyURIOptions(Map<String, String> options) throws IllegalArgumentException {
        Map<String, String> jmsOptionsMap = PropertyUtil.filterProperties(options, "jms.");
        Map<String, String> unused = PropertyUtil.setProperties((Object)this, jmsOptionsMap);
        if (!unused.isEmpty()) {
            String msg = " Not all jms options could be set on the ConnectionFactory. Check the options are spelled correctly. Unused parameters=[" + unused + "]." + " This connection factory cannot be started.";
            throw new IllegalArgumentException(msg);
        }
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isForceSyncSend() {
        return this.forceSyncSend;
    }

    public void setForceSyncSend(boolean forceSyncSend) {
        this.forceSyncSend = forceSyncSend;
    }

    public boolean isForceAsyncSend() {
        return this.forceAsyncSend;
    }

    public void setForceAsyncSend(boolean forceAsyncSend) {
        this.forceAsyncSend = forceAsyncSend;
    }

    public boolean isLocalMessagePriority() {
        return this.localMessagePriority;
    }

    public void setLocalMessagePriority(boolean localMessagePriority) {
        this.localMessagePriority = localMessagePriority;
    }

    public String getQueuePrefix() {
        return this.queuePrefix;
    }

    public void setQueuePrefix(String queuePrefix) {
        this.queuePrefix = queuePrefix;
    }

    public String getTopicPrefix() {
        return this.topicPrefix;
    }

    public void setTopicPrefix(String topicPrefix) {
        this.topicPrefix = topicPrefix;
    }

    public boolean isValidatePropertyNames() {
        return this.validatePropertyNames;
    }

    public void setValidatePropertyNames(boolean validatePropertyNames) {
        this.validatePropertyNames = validatePropertyNames;
    }

    public long getCloseTimeout() {
        return this.closeTimeout;
    }

    public void setCloseTimeout(long closeTimeout) {
        this.closeTimeout = closeTimeout;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public long getSendTimeout() {
        return this.sendTimeout;
    }

    public void setSendTimeout(long sendTimeout) {
        this.sendTimeout = sendTimeout;
    }

    public long getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeout(long requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public JmsPrefetchPolicy getPrefetchPolicy() {
        return this.prefetchPolicy;
    }

    public void setPrefetchPolicy(JmsPrefetchPolicy prefetchPolicy) {
        if (prefetchPolicy == null) {
            prefetchPolicy = new JmsDefaultPrefetchPolicy();
        }
        this.prefetchPolicy = prefetchPolicy;
    }

    public JmsRedeliveryPolicy getRedeliveryPolicy() {
        return this.redeliveryPolicy;
    }

    public void setRedeliveryPolicy(JmsRedeliveryPolicy redeliveryPolicy) {
        if (redeliveryPolicy == null) {
            redeliveryPolicy = new JmsDefaultRedeliveryPolicy();
        }
        this.redeliveryPolicy = redeliveryPolicy;
    }

    public JmsPresettlePolicy getPresettlePolicy() {
        return this.presettlePolicy;
    }

    public void setPresettlePolicy(JmsPresettlePolicy presettlePolicy) {
        if (presettlePolicy == null) {
            presettlePolicy = new JmsDefaultPresettlePolicy();
        }
        this.presettlePolicy = presettlePolicy;
    }

    public JmsMessageIDPolicy getMessageIDPolicy() {
        return this.messageIDPolicy;
    }

    public void setMessageIDPolicy(JmsMessageIDPolicy messageIDPolicy) {
        if (messageIDPolicy == null) {
            messageIDPolicy = new JmsDefaultMessageIDPolicy();
        }
        this.messageIDPolicy = messageIDPolicy;
    }

    public JmsDeserializationPolicy getDeserializationPolicy() {
        return this.deserializationPolicy;
    }

    public void setDeserializationPolicy(JmsDeserializationPolicy deserializationPolicy) {
        if (deserializationPolicy == null) {
            deserializationPolicy = new JmsDefaultDeserializationPolicy();
        }
        this.deserializationPolicy = deserializationPolicy;
    }

    public synchronized String getClientIDPrefix() {
        return this.clientIDPrefix;
    }

    public synchronized void setClientIDPrefix(String clientIDPrefix) {
        this.clientIDPrefix = clientIDPrefix;
    }

    protected synchronized IdGenerator getClientIdGenerator() {
        if (this.clientIdGenerator == null) {
            this.clientIdGenerator = this.clientIDPrefix != null ? new IdGenerator(this.clientIDPrefix) : new IdGenerator();
        }
        return this.clientIdGenerator;
    }

    protected synchronized void setClientIdGenerator(IdGenerator clientIdGenerator) {
        this.clientIdGenerator = clientIdGenerator;
    }

    public String getClientID() {
        return this.clientID;
    }

    public void setClientID(String clientID) {
        this.clientID = clientID;
    }

    public synchronized void setConnectionIDPrefix(String connectionIDPrefix) {
        this.connectionIDPrefix = connectionIDPrefix;
    }

    public ExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    public boolean isForceAsyncAcks() {
        return this.forceAsyncAcks;
    }

    public void setForceAsyncAcks(boolean forceAsyncAcks) {
        this.forceAsyncAcks = forceAsyncAcks;
    }

    public boolean isLocalMessageExpiry() {
        return this.localMessageExpiry;
    }

    public void setLocalMessageExpiry(boolean localMessageExpiry) {
        this.localMessageExpiry = localMessageExpiry;
    }

    @Deprecated
    public void setMessageIDType(String type) {
        if (this.messageIDPolicy instanceof JmsDefaultMessageIDPolicy) {
            ((JmsDefaultMessageIDPolicy)this.messageIDPolicy).setMessageIDType(type);
        }
    }

    @Deprecated
    public String getMessageIDType() {
        if (this.messageIDPolicy instanceof JmsDefaultMessageIDPolicy) {
            return ((JmsDefaultMessageIDPolicy)this.messageIDPolicy).getMessageIDType();
        }
        return null;
    }

    @Deprecated
    public JmsMessageIDBuilder getMessageIDBuilder() {
        if (this.messageIDPolicy instanceof JmsDefaultMessageIDPolicy) {
            return ((JmsDefaultMessageIDPolicy)this.messageIDPolicy).getMessageIDBuilder();
        }
        return null;
    }

    @Deprecated
    public void setMessageIDBuilder(JmsMessageIDBuilder messageIDBuilder) {
        if (this.messageIDPolicy instanceof JmsDefaultMessageIDPolicy) {
            ((JmsDefaultMessageIDPolicy)this.messageIDPolicy).setMessageIDBuilder(messageIDBuilder);
        }
    }

    public boolean isReceiveLocalOnly() {
        return this.receiveLocalOnly;
    }

    public void setReceiveLocalOnly(boolean receiveLocalOnly) {
        this.receiveLocalOnly = receiveLocalOnly;
    }

    public boolean isReceiveNoWaitLocalOnly() {
        return this.receiveNoWaitLocalOnly;
    }

    public void setReceiveNoWaitLocalOnly(boolean receiveNoWaitLocalOnly) {
        this.receiveNoWaitLocalOnly = receiveNoWaitLocalOnly;
    }

    public boolean isPopulateJMSXUserID() {
        return this.populateJMSXUserID;
    }

    public void setPopulateJMSXUserID(boolean populateJMSXUserID) {
        this.populateJMSXUserID = populateJMSXUserID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDefaultRemoteAddress() {
        if (DEFAULT_REMOTE_URI != null) {
            return DEFAULT_REMOTE_URI;
        }
        Class<JmsConnectionFactory> clazz = JmsConnectionFactory.class;
        synchronized (JmsConnectionFactory.class) {
            if (DEFAULT_REMOTE_URI != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return DEFAULT_REMOTE_URI;
            }
            String host = null;
            String port = null;
            String remoteAddress = null;
            try {
                host = AccessController.doPrivileged(new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        String result = System.getProperty("org.apache.qpid.jms.REMOTE_HOST", JmsConnectionFactory.DEFAULT_REMOTE_HOST);
                        result = result == null || result.isEmpty() ? JmsConnectionFactory.DEFAULT_REMOTE_HOST : result;
                        return result;
                    }
                });
                port = AccessController.doPrivileged(new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        String result = System.getProperty("org.apache.qpid.jms.REMOTE_PORT", JmsConnectionFactory.DEFAULT_REMOTE_PORT);
                        result = result == null || result.isEmpty() ? JmsConnectionFactory.DEFAULT_REMOTE_PORT : result;
                        return result;
                    }
                });
            }
            catch (Throwable e) {
                LOG.debug("Failed to look up System properties for remote host and port", e);
            }
            host = host == null || host.isEmpty() ? DEFAULT_REMOTE_HOST : host;
            port = port == null || port.isEmpty() ? DEFAULT_REMOTE_PORT : port;
            final String defaultURL = "amqp://" + host + ":" + port;
            try {
                remoteAddress = AccessController.doPrivileged(new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        String result = System.getProperty("org.apache.qpid.jms.REMOTE_URI", defaultURL);
                        result = result == null || result.isEmpty() ? defaultURL : result;
                        return result;
                    }
                });
            }
            catch (Throwable e) {
                LOG.debug("Failed to look up System property for remote URI", e);
            }
            DEFAULT_REMOTE_URI = remoteAddress == null || remoteAddress.isEmpty() ? defaultURL : remoteAddress;
            // ** MonitorExit[var0] (shouldn't be in output)
            return DEFAULT_REMOTE_URI;
        }
    }
}

