/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.meta;

import org.apache.qpid.jms.JmsDestination;
import org.apache.qpid.jms.message.JmsMessageIDBuilder;
import org.apache.qpid.jms.meta.JmsProducerId;
import org.apache.qpid.jms.meta.JmsResource;
import org.apache.qpid.jms.meta.JmsResourceVistor;
import org.apache.qpid.jms.meta.JmsSessionId;

public final class JmsProducerInfo
implements JmsResource,
Comparable<JmsProducerInfo> {
    private final JmsProducerId producerId;
    private final JmsMessageIDBuilder messageIDBuilder;
    private JmsDestination destination;
    private boolean presettle;

    public JmsProducerInfo(JmsProducerId producerId) {
        this(producerId, JmsMessageIDBuilder.BUILTIN.DEFAULT.createBuilder());
    }

    public JmsProducerInfo(JmsProducerId producerId, JmsMessageIDBuilder messageIDBuilder) {
        if (producerId == null) {
            throw new IllegalArgumentException("Producer ID cannot be null");
        }
        if (messageIDBuilder == null) {
            throw new IllegalArgumentException("Message ID Builder cannot be null");
        }
        this.producerId = producerId;
        this.messageIDBuilder = messageIDBuilder;
    }

    public JmsProducerInfo copy() {
        JmsProducerInfo info = new JmsProducerInfo(this.producerId, this.messageIDBuilder);
        this.copy(info);
        return info;
    }

    public void copy(JmsProducerInfo info) {
        info.destination = this.destination;
    }

    @Override
    public JmsProducerId getId() {
        return this.producerId;
    }

    public JmsSessionId getParentId() {
        return this.producerId.getParentId();
    }

    public JmsDestination getDestination() {
        return this.destination;
    }

    public void setDestination(JmsDestination destination) {
        this.destination = destination;
    }

    public boolean isPresettle() {
        return this.presettle;
    }

    public void setPresettle(boolean presettle) {
        this.presettle = presettle;
    }

    public JmsMessageIDBuilder getMessageIDBuilder() {
        return this.messageIDBuilder;
    }

    public String toString() {
        return "JmsProducerInfo { " + this.getId() + ", destination = " + this.getDestination() + " }";
    }

    public int hashCode() {
        return this.producerId.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JmsProducerInfo other = (JmsProducerInfo)obj;
        return this.producerId.equals(other.producerId);
    }

    @Override
    public int compareTo(JmsProducerInfo other) {
        return this.producerId.compareTo(other.producerId);
    }

    @Override
    public void visit(JmsResourceVistor vistor) throws Exception {
        vistor.processProducerInfo(this);
    }
}

