/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.jms.IllegalStateException;
import org.apache.qpid.jms.meta.JmsConsumerId;
import org.apache.qpid.jms.meta.JmsConsumerInfo;
import org.apache.qpid.jms.meta.JmsProducerId;
import org.apache.qpid.jms.meta.JmsProducerInfo;
import org.apache.qpid.jms.meta.JmsSessionId;
import org.apache.qpid.jms.meta.JmsSessionInfo;
import org.apache.qpid.jms.meta.JmsTransactionId;
import org.apache.qpid.jms.meta.JmsTransactionInfo;
import org.apache.qpid.jms.provider.AsyncResult;
import org.apache.qpid.jms.provider.ProviderConstants;
import org.apache.qpid.jms.provider.amqp.AmqpAbstractResource;
import org.apache.qpid.jms.provider.amqp.AmqpConnection;
import org.apache.qpid.jms.provider.amqp.AmqpConsumer;
import org.apache.qpid.jms.provider.amqp.AmqpProducer;
import org.apache.qpid.jms.provider.amqp.AmqpProvider;
import org.apache.qpid.jms.provider.amqp.AmqpResource;
import org.apache.qpid.jms.provider.amqp.AmqpResourceParent;
import org.apache.qpid.jms.provider.amqp.AmqpTransactionContext;
import org.apache.qpid.jms.provider.amqp.builders.AmqpConsumerBuilder;
import org.apache.qpid.jms.provider.amqp.builders.AmqpProducerBuilder;
import org.apache.qpid.proton.engine.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpSession
extends AmqpAbstractResource<JmsSessionInfo, Session>
implements AmqpResourceParent {
    private static final Logger LOG = LoggerFactory.getLogger(AmqpSession.class);
    private final AmqpConnection connection;
    private final AmqpTransactionContext txContext;
    private final Map<JmsConsumerId, AmqpConsumer> consumers = new HashMap<JmsConsumerId, AmqpConsumer>();
    private final Map<JmsProducerId, AmqpProducer> producers = new HashMap<JmsProducerId, AmqpProducer>();

    public AmqpSession(AmqpConnection connection, JmsSessionInfo info, Session session) {
        super(info, session, connection);
        this.connection = connection;
        this.txContext = info.isTransacted() ? new AmqpTransactionContext(this, info) : null;
    }

    public void acknowledge(ProviderConstants.ACK_TYPE ackType) {
        for (AmqpConsumer consumer : this.consumers.values()) {
            consumer.acknowledge(ackType);
        }
    }

    public void recover() throws Exception {
        for (AmqpConsumer consumer : this.consumers.values()) {
            consumer.recover();
        }
    }

    public void createProducer(JmsProducerInfo producerInfo, AsyncResult request) {
        AmqpProducerBuilder builder = new AmqpProducerBuilder(this, producerInfo);
        builder.buildResource(request);
    }

    public AmqpProducer getProducer(JmsProducerInfo producerInfo) {
        return this.getProducer(producerInfo.getId());
    }

    public AmqpProducer getProducer(JmsProducerId producerId) {
        if (producerId.getProviderHint() instanceof AmqpProducer) {
            return (AmqpProducer)producerId.getProviderHint();
        }
        return null;
    }

    public void createConsumer(JmsConsumerInfo consumerInfo, AsyncResult request) {
        AmqpConsumerBuilder builder = new AmqpConsumerBuilder(this, consumerInfo);
        builder.buildResource(request);
    }

    public AmqpConsumer getConsumer(JmsConsumerInfo consumerInfo) {
        return this.getConsumer(consumerInfo.getId());
    }

    public AmqpConsumer getConsumer(JmsConsumerId consumerId) {
        if (consumerId.getProviderHint() instanceof AmqpConsumer) {
            return (AmqpConsumer)consumerId.getProviderHint();
        }
        return this.consumers.get(consumerId);
    }

    public AmqpTransactionContext getTransactionContext() {
        return this.txContext;
    }

    public void begin(JmsTransactionId txId, AsyncResult request) throws Exception {
        if (!((JmsSessionInfo)this.getResourceInfo()).isTransacted()) {
            throw new IllegalStateException("Non-transacted Session cannot start a TX.");
        }
        this.getTransactionContext().begin(txId, request);
    }

    public void commit(JmsTransactionInfo transactionInfo, AsyncResult request) throws Exception {
        if (!((JmsSessionInfo)this.getResourceInfo()).isTransacted()) {
            throw new IllegalStateException("Non-transacted Session cannot commit a TX.");
        }
        this.getTransactionContext().commit(transactionInfo, request);
    }

    public void rollback(JmsTransactionInfo transactionInfo, AsyncResult request) throws Exception {
        if (!((JmsSessionInfo)this.getResourceInfo()).isTransacted()) {
            throw new IllegalStateException("Non-transacted Session cannot rollback a TX.");
        }
        this.getTransactionContext().rollback(transactionInfo, request);
    }

    public ScheduledFuture<?> schedule(Runnable task, long delay) {
        if (task == null) {
            LOG.trace("Resource attempted to schedule a null task.");
            return null;
        }
        return this.getProvider().getScheduler().schedule(task, delay, TimeUnit.MILLISECONDS);
    }

    @Override
    public void addChildResource(AmqpResource resource) {
        if (resource instanceof AmqpConsumer) {
            AmqpConsumer consumer = (AmqpConsumer)resource;
            this.consumers.put(consumer.getConsumerId(), consumer);
        } else if (resource instanceof AmqpProducer) {
            AmqpProducer producer = (AmqpProducer)resource;
            this.producers.put(producer.getProducerId(), producer);
        } else {
            this.connection.addChildResource(resource);
        }
    }

    @Override
    public void removeChildResource(AmqpResource resource) {
        if (resource instanceof AmqpConsumer) {
            AmqpConsumer consumer = (AmqpConsumer)resource;
            this.consumers.remove(consumer.getConsumerId());
        } else if (resource instanceof AmqpProducer) {
            AmqpProducer producer = (AmqpProducer)resource;
            this.producers.remove(producer.getProducerId());
        } else {
            this.connection.removeChildResource(resource);
        }
    }

    @Override
    public void handleResourceClosure(AmqpProvider provider, Exception error) {
        for (AmqpConsumer consumer : this.consumers.values()) {
            consumer.locallyClosed(provider, error);
        }
        for (AmqpProducer producer : this.producers.values()) {
            producer.locallyClosed(provider, error);
        }
    }

    public boolean containsSubscription(String subscriptionName) {
        for (AmqpConsumer consumer : this.consumers.values()) {
            if (!subscriptionName.equals(((JmsConsumerInfo)consumer.getResourceInfo()).getSubscriptionName())) continue;
            return true;
        }
        return false;
    }

    public void reportError(Exception error) {
        this.getConnection().getProvider().fireProviderException(error);
    }

    @Override
    public AmqpProvider getProvider() {
        return this.connection.getProvider();
    }

    public AmqpConnection getConnection() {
        return this.connection;
    }

    public JmsSessionId getSessionId() {
        return ((JmsSessionInfo)this.getResourceInfo()).getId();
    }

    boolean isTransacted() {
        return ((JmsSessionInfo)this.getResourceInfo()).isTransacted();
    }

    public boolean isTransactionFailed() {
        return this.txContext == null ? false : this.txContext.isTransactionFailed();
    }

    boolean isAsyncAck() {
        return ((JmsSessionInfo)this.getResourceInfo()).isSendAcksAsync() || this.isTransacted();
    }

    public String toString() {
        return "AmqpSession { " + this.getSessionId() + " }";
    }
}

