/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider;

import java.io.IOException;
import java.net.URI;
import javax.jms.JMSException;
import org.apache.qpid.jms.message.JmsInboundMessageDispatch;
import org.apache.qpid.jms.message.JmsMessageFactory;
import org.apache.qpid.jms.message.JmsOutboundMessageDispatch;
import org.apache.qpid.jms.meta.JmsConsumerId;
import org.apache.qpid.jms.meta.JmsResource;
import org.apache.qpid.jms.meta.JmsSessionId;
import org.apache.qpid.jms.provider.AsyncResult;
import org.apache.qpid.jms.provider.ProviderConstants;
import org.apache.qpid.jms.provider.ProviderListener;

public interface Provider {
    public void connect() throws IOException;

    public void start() throws IOException, IllegalStateException;

    public void close();

    public URI getRemoteURI();

    public void create(JmsResource var1, AsyncResult var2) throws IOException, JMSException;

    public void start(JmsResource var1, AsyncResult var2) throws IOException, JMSException;

    public void stop(JmsResource var1, AsyncResult var2) throws IOException, JMSException;

    public void destroy(JmsResource var1, AsyncResult var2) throws IOException, JMSException;

    public void send(JmsOutboundMessageDispatch var1, AsyncResult var2) throws IOException, JMSException;

    public void acknowledge(JmsSessionId var1, AsyncResult var2) throws IOException, JMSException;

    public void acknowledge(JmsInboundMessageDispatch var1, ProviderConstants.ACK_TYPE var2, AsyncResult var3) throws IOException, JMSException;

    public void commit(JmsSessionId var1, AsyncResult var2) throws IOException, JMSException;

    public void rollback(JmsSessionId var1, AsyncResult var2) throws IOException, JMSException;

    public void recover(JmsSessionId var1, AsyncResult var2) throws IOException;

    public void unsubscribe(String var1, AsyncResult var2) throws IOException, JMSException;

    public void pull(JmsConsumerId var1, long var2, AsyncResult var4) throws IOException;

    public JmsMessageFactory getMessageFactory();

    public void setProviderListener(ProviderListener var1);

    public ProviderListener getProviderListener();
}

