/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp.message;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import javax.jms.JMSException;
import org.apache.qpid.jms.exceptions.JmsExceptionSupport;
import org.apache.qpid.jms.message.facade.JmsTextMessageFacade;
import org.apache.qpid.jms.provider.amqp.AmqpConnection;
import org.apache.qpid.jms.provider.amqp.AmqpConsumer;
import org.apache.qpid.jms.provider.amqp.message.AmqpJmsMessageFacade;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.message.Message;

public class AmqpJmsTextMessageFacade
extends AmqpJmsMessageFacade
implements JmsTextMessageFacade {
    private static final String UTF_8 = "UTF-8";
    public static final String CONTENT_TYPE = "text/plain";
    private final CharsetDecoder decoder = Charset.forName("UTF-8").newDecoder();

    public AmqpJmsTextMessageFacade(AmqpConnection connection) {
        super(connection);
        this.setMessageAnnotation("x-opt-jms-msg-type", (byte)5);
        this.setText(null);
    }

    public AmqpJmsTextMessageFacade(AmqpConsumer consumer, Message message) {
        super(consumer, message);
    }

    @Override
    public byte getJmsMsgType() {
        return 5;
    }

    @Override
    public AmqpJmsTextMessageFacade copy() throws JMSException {
        AmqpJmsTextMessageFacade copy = new AmqpJmsTextMessageFacade(this.connection);
        this.copyInto(copy);
        copy.setText(this.getText());
        return copy;
    }

    @Override
    public String getText() throws JMSException {
        Section body = this.getAmqpMessage().getBody();
        if (body == null) {
            return null;
        }
        if (body instanceof Data) {
            Data data = (Data)body;
            if (data.getValue() == null || data.getValue().getLength() == 0) {
                return "";
            }
            Binary b = data.getValue();
            ByteBuffer buf = ByteBuffer.wrap(b.getArray(), b.getArrayOffset(), b.getLength());
            try {
                CharBuffer chars = this.decoder.decode(buf);
                return String.valueOf(chars);
            }
            catch (CharacterCodingException e) {
                throw JmsExceptionSupport.create("Cannot decode String in UFT-8", e);
            }
        }
        if (body instanceof AmqpValue) {
            Object value = ((AmqpValue)body).getValue();
            if (value == null || value instanceof String) {
                return (String)value;
            }
            throw new IllegalStateException("Unexpected amqp-value body content type: " + value.getClass().getSimpleName());
        }
        throw new IllegalStateException("Unexpected message body type: " + body.getClass().getSimpleName());
    }

    @Override
    public void setText(String value) {
        AmqpValue body = new AmqpValue((Object)value);
        this.getAmqpMessage().setBody((Section)body);
    }

    @Override
    public void clearBody() {
        this.setText(null);
    }

    @Override
    public boolean isEmpty() {
        Section body = this.getAmqpMessage().getBody();
        if (body == null) {
            return true;
        }
        if (body instanceof AmqpValue) {
            AmqpValue value = (AmqpValue)body;
            if (value.getValue() == null) {
                return true;
            }
            String text = (String)value.getValue();
            if (text.isEmpty()) {
                return true;
            }
        } else if (body instanceof Data) {
            Data data = (Data)body;
            if (data.getValue() == null || data.getValue().getLength() == 0) {
                return true;
            }
        } else {
            return true;
        }
        return false;
    }
}

