/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.sasl;

import org.apache.qpid.jms.sasl.AbstractMechanism;
import org.apache.qpid.jms.sasl.Mechanism;

public class PlainMechanism
extends AbstractMechanism {
    @Override
    public int getPriority() {
        return Mechanism.PRIORITY.LOWER.getValue();
    }

    @Override
    public String getName() {
        return "PLAIN";
    }

    @Override
    public byte[] getInitialResponse() {
        String username = this.getUsername();
        String password = this.getPassword();
        if (username == null) {
            username = "";
        }
        if (password == null) {
            password = "";
        }
        byte[] usernameBytes = username.getBytes();
        byte[] passwordBytes = password.getBytes();
        byte[] data = new byte[usernameBytes.length + passwordBytes.length + 2];
        System.arraycopy(usernameBytes, 0, data, 1, usernameBytes.length);
        System.arraycopy(passwordBytes, 0, data, 2 + usernameBytes.length, passwordBytes.length);
        return data;
    }

    @Override
    public byte[] getChallengeResponse(byte[] challenge) {
        return EMPTY;
    }
}

