/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.transports;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.qpid.jms.transports.TransportOptions;

public class TransportSslOptions
extends TransportOptions {
    public static final String DEFAULT_STORE_TYPE = "jks";
    public static final String DEFAULT_CONTEXT_PROTOCOL = "TLS";
    public static final boolean DEFAULT_TRUST_ALL = false;
    public static final boolean DEFAULT_VERIFY_HOST = true;
    public static final List<String> DEFAULT_DISABLED_PROTOCOLS = Collections.unmodifiableList(Arrays.asList("SSLv2Hello", "SSLv3"));
    public static final TransportSslOptions INSTANCE = new TransportSslOptions();
    private String keyStoreLocation;
    private String keyStorePassword;
    private String trustStoreLocation;
    private String trustStorePassword;
    private String storeType = "jks";
    private String[] enabledCipherSuites;
    private String[] disabledCipherSuites;
    private String[] enabledProtocols;
    private String[] disabledProtocols = DEFAULT_DISABLED_PROTOCOLS.toArray(new String[0]);
    private String contextProtocol = "TLS";
    private boolean trustAll = false;
    private boolean verifyHost = true;
    private String keyAlias;

    public String getKeyStoreLocation() {
        return this.keyStoreLocation;
    }

    public void setKeyStoreLocation(String keyStoreLocation) {
        this.keyStoreLocation = keyStoreLocation;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public String getTrustStoreLocation() {
        return this.trustStoreLocation;
    }

    public void setTrustStoreLocation(String trustStoreLocation) {
        this.trustStoreLocation = trustStoreLocation;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    public String getStoreType() {
        return this.storeType;
    }

    public void setStoreType(String storeType) {
        this.storeType = storeType;
    }

    public String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    public void setEnabledCipherSuites(String[] enabledCipherSuites) {
        this.enabledCipherSuites = enabledCipherSuites;
    }

    public String[] getDisabledCipherSuites() {
        return this.disabledCipherSuites;
    }

    public void setDisabledCipherSuites(String[] disabledCipherSuites) {
        this.disabledCipherSuites = disabledCipherSuites;
    }

    public String[] getEnabledProtocols() {
        return this.enabledProtocols;
    }

    public void setEnabledProtocols(String[] enabledProtocols) {
        this.enabledProtocols = enabledProtocols;
    }

    public String[] getDisabledProtocols() {
        return this.disabledProtocols;
    }

    public void setDisabledProtocols(String[] disabledProtocols) {
        this.disabledProtocols = disabledProtocols;
    }

    public String getContextProtocol() {
        return this.contextProtocol;
    }

    public void setContextProtocol(String contextProtocol) {
        this.contextProtocol = contextProtocol;
    }

    public boolean isTrustAll() {
        return this.trustAll;
    }

    public void setTrustAll(boolean trustAll) {
        this.trustAll = trustAll;
    }

    public boolean isVerifyHost() {
        return this.verifyHost;
    }

    public void setVerifyHost(boolean verifyHost) {
        this.verifyHost = verifyHost;
    }

    public String getKeyAlias() {
        return this.keyAlias;
    }

    public void setKeyAlias(String keyAlias) {
        this.keyAlias = keyAlias;
    }

    @Override
    public TransportSslOptions clone() {
        return this.copyOptions(new TransportSslOptions());
    }

    protected TransportSslOptions copyOptions(TransportSslOptions copy) {
        super.copyOptions(copy);
        copy.setKeyStoreLocation(this.getKeyStoreLocation());
        copy.setKeyStorePassword(this.getKeyStorePassword());
        copy.setTrustStoreLocation(this.getTrustStoreLocation());
        copy.setTrustStorePassword(this.getTrustStorePassword());
        copy.setStoreType(this.getStoreType());
        copy.setEnabledCipherSuites(this.getEnabledCipherSuites());
        copy.setDisabledCipherSuites(this.getDisabledCipherSuites());
        copy.setEnabledProtocols(this.getEnabledProtocols());
        copy.setDisabledProtocols(this.getDisabledProtocols());
        copy.setTrustAll(this.isTrustAll());
        copy.setVerifyHost(this.isVerifyHost());
        copy.setKeyAlias(this.getKeyAlias());
        copy.setContextProtocol(this.getContextProtocol());
        return copy;
    }

    static {
        INSTANCE.setKeyStoreLocation(System.getProperty("javax.net.ssl.keyStore"));
        INSTANCE.setKeyStorePassword(System.getProperty("javax.net.ssl.keyStorePassword"));
        INSTANCE.setTrustStoreLocation(System.getProperty("javax.net.ssl.trustStore"));
        INSTANCE.setTrustStorePassword(System.getProperty("javax.net.ssl.keyStorePassword"));
    }
}

