/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp;

import java.security.Principal;
import java.util.HashSet;
import java.util.Set;
import javax.jms.JMSSecurityException;
import javax.security.sasl.SaslException;
import org.apache.qpid.jms.meta.JmsConnectionInfo;
import org.apache.qpid.jms.provider.AsyncResult;
import org.apache.qpid.jms.sasl.Mechanism;
import org.apache.qpid.jms.sasl.SaslMechanismFinder;
import org.apache.qpid.proton.engine.Sasl;

public class AmqpSaslAuthenticator {
    private final Sasl sasl;
    private final JmsConnectionInfo info;
    private Mechanism mechanism;
    private final Principal localPrincipal;
    private Set<String> mechanismsRestriction;
    private final AsyncResult authenticationRequest;

    public AmqpSaslAuthenticator(AsyncResult request, Sasl sasl, JmsConnectionInfo info, Principal localPrincipal, String[] mechanismsRestriction) {
        this.sasl = sasl;
        this.info = info;
        this.localPrincipal = localPrincipal;
        this.authenticationRequest = request;
        if (mechanismsRestriction != null) {
            HashSet<String> mechs = new HashSet<String>();
            for (int i = 0; i < mechanismsRestriction.length; ++i) {
                String mech = mechanismsRestriction[i];
                if (mech.trim().isEmpty()) continue;
                mechs.add(mech);
            }
            if (!mechs.isEmpty()) {
                this.mechanismsRestriction = mechs;
            }
        }
    }

    public boolean authenticate() {
        try {
            switch (this.sasl.getState()) {
                case PN_SASL_IDLE: {
                    this.handleSaslInit();
                    break;
                }
                case PN_SASL_STEP: {
                    this.handleSaslStep();
                    break;
                }
                case PN_SASL_FAIL: {
                    this.handleSaslFail();
                    break;
                }
                case PN_SASL_PASS: {
                    this.authenticationRequest.onSuccess();
                }
            }
        }
        catch (JMSSecurityException result) {
            this.authenticationRequest.onFailure(result);
        }
        return this.authenticationRequest.isComplete();
    }

    public boolean wasSuccessful() throws IllegalStateException {
        switch (this.sasl.getState()) {
            case PN_SASL_IDLE: 
            case PN_SASL_STEP: 
            case PN_SASL_CONF: {
                break;
            }
            case PN_SASL_FAIL: {
                return false;
            }
            case PN_SASL_PASS: {
                return true;
            }
        }
        throw new IllegalStateException("Authentication has not completed yet.");
    }

    private void handleSaslInit() throws JMSSecurityException {
        block4: {
            try {
                String[] remoteMechanisms = this.sasl.getRemoteMechanisms();
                if (remoteMechanisms == null || remoteMechanisms.length == 0) break block4;
                this.mechanism = SaslMechanismFinder.findMatchingMechanism(this.info.getUsername(), this.info.getPassword(), this.localPrincipal, this.mechanismsRestriction, remoteMechanisms);
                if (this.mechanism != null) {
                    this.mechanism.setUsername(this.info.getUsername());
                    this.mechanism.setPassword(this.info.getPassword());
                    this.sasl.setMechanisms(new String[]{this.mechanism.getName()});
                    byte[] response = this.mechanism.getInitialResponse();
                    if (response != null) {
                        this.sasl.send(response, 0, response.length);
                    }
                    break block4;
                }
                throw new JMSSecurityException("Could not find a suitable SASL mechanism for the remote peer using the available credentials.");
            }
            catch (SaslException se) {
                JMSSecurityException jmsse = new JMSSecurityException("Exception while processing SASL init: " + se.getMessage());
                jmsse.setLinkedException((Exception)se);
                jmsse.initCause((Throwable)se);
                throw jmsse;
            }
        }
    }

    private void handleSaslStep() throws JMSSecurityException {
        try {
            if (this.sasl.pending() != 0) {
                byte[] challenge = new byte[this.sasl.pending()];
                this.sasl.recv(challenge, 0, challenge.length);
                byte[] response = this.mechanism.getChallengeResponse(challenge);
                this.sasl.send(response, 0, response.length);
            }
        }
        catch (SaslException se) {
            JMSSecurityException jmsse = new JMSSecurityException("Exception while processing SASL step: " + se.getMessage());
            jmsse.setLinkedException((Exception)se);
            jmsse.initCause((Throwable)se);
            throw jmsse;
        }
    }

    private void handleSaslFail() throws JMSSecurityException {
        if (this.mechanism != null) {
            throw new JMSSecurityException("Client failed to authenticate using SASL: " + this.mechanism.getName());
        }
        throw new JMSSecurityException("Client failed to authenticate");
    }
}

