/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp.builders;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSRuntimeException;
import org.apache.qpid.jms.JmsDestination;
import org.apache.qpid.jms.meta.JmsConsumerInfo;
import org.apache.qpid.jms.provider.amqp.AmqpConnection;
import org.apache.qpid.jms.provider.amqp.AmqpConsumer;
import org.apache.qpid.jms.provider.amqp.AmqpProvider;
import org.apache.qpid.jms.provider.amqp.AmqpSession;
import org.apache.qpid.jms.provider.amqp.AmqpSubscriptionTracker;
import org.apache.qpid.jms.provider.amqp.AmqpSupport;
import org.apache.qpid.jms.provider.amqp.builders.AmqpResourceBuilder;
import org.apache.qpid.jms.provider.amqp.filters.AmqpJmsNoLocalType;
import org.apache.qpid.jms.provider.amqp.filters.AmqpJmsSelectorType;
import org.apache.qpid.jms.provider.amqp.message.AmqpDestinationHelper;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Accepted;
import org.apache.qpid.proton.amqp.messaging.Modified;
import org.apache.qpid.proton.amqp.messaging.Outcome;
import org.apache.qpid.proton.amqp.messaging.Rejected;
import org.apache.qpid.proton.amqp.messaging.Released;
import org.apache.qpid.proton.amqp.messaging.Source;
import org.apache.qpid.proton.amqp.messaging.Target;
import org.apache.qpid.proton.amqp.messaging.TerminusDurability;
import org.apache.qpid.proton.amqp.messaging.TerminusExpiryPolicy;
import org.apache.qpid.proton.amqp.transport.ReceiverSettleMode;
import org.apache.qpid.proton.amqp.transport.SenderSettleMode;
import org.apache.qpid.proton.engine.Receiver;
import org.apache.qpid.proton.engine.Session;

public class AmqpConsumerBuilder
extends AmqpResourceBuilder<AmqpConsumer, AmqpSession, JmsConsumerInfo, Receiver> {
    boolean validateSharedSubsLinkCapability;
    boolean sharedSubsNotSupported;

    public AmqpConsumerBuilder(AmqpSession parent, JmsConsumerInfo consumerInfo) {
        super(parent, consumerInfo);
    }

    @Override
    protected Receiver createEndpoint(JmsConsumerInfo resourceInfo) {
        JmsDestination destination = resourceInfo.getDestination();
        String address = AmqpDestinationHelper.INSTANCE.getDestinationAddress(destination, ((AmqpSession)this.getParent()).getConnection());
        Source source = new Source();
        source.setAddress(address);
        Target target = new Target();
        this.configureSource(source);
        String receiverLinkName = null;
        String subscriptionName = resourceInfo.getSubscriptionName();
        if (subscriptionName != null && !subscriptionName.isEmpty()) {
            AmqpConnection connection = ((AmqpSession)this.getParent()).getConnection();
            if (resourceInfo.isShared() && !connection.getProperties().isSharedSubsSupported()) {
                this.validateSharedSubsLinkCapability = true;
            }
            AmqpSubscriptionTracker subTracker = connection.getSubTracker();
            if (resourceInfo.isShared() && resourceInfo.isDurable()) {
                if (subTracker.isActiveExclusiveDurableSub(subscriptionName)) {
                    throw new JMSRuntimeException("A non-shared durable subscription is already active with name '" + subscriptionName + "'");
                }
            } else if (!resourceInfo.isShared() && resourceInfo.isDurable()) {
                if (subTracker.isActiveExclusiveDurableSub(subscriptionName)) {
                    throw new JMSRuntimeException("A non-shared durable subscription is already active with name '" + subscriptionName + "'");
                }
                if (subTracker.isActiveSharedDurableSub(subscriptionName)) {
                    throw new JMSRuntimeException("A shared durable subscription is already active with name '" + subscriptionName + "'");
                }
            }
            receiverLinkName = subTracker.reserveNextSubscriptionLinkName(subscriptionName, resourceInfo);
        }
        if (receiverLinkName == null) {
            receiverLinkName = "qpid-jms:receiver:" + resourceInfo.getId() + ":" + address;
        }
        Receiver receiver = ((Session)((AmqpSession)this.getParent()).getEndpoint()).receiver(receiverLinkName);
        receiver.setSource((org.apache.qpid.proton.amqp.transport.Source)source);
        receiver.setTarget((org.apache.qpid.proton.amqp.transport.Target)target);
        if (resourceInfo.isBrowser() || resourceInfo.isPresettle()) {
            receiver.setSenderSettleMode(SenderSettleMode.SETTLED);
        } else {
            receiver.setSenderSettleMode(SenderSettleMode.UNSETTLED);
        }
        receiver.setReceiverSettleMode(ReceiverSettleMode.FIRST);
        if (this.validateSharedSubsLinkCapability) {
            receiver.setDesiredCapabilities(new Symbol[]{AmqpSupport.SHARED_SUBS});
        }
        return receiver;
    }

    @Override
    protected void afterOpened() {
        if (this.validateSharedSubsLinkCapability) {
            List<Symbol> list;
            Symbol[] remoteOfferedCapabilities = ((Receiver)this.endpoint).getRemoteOfferedCapabilities();
            boolean supported = false;
            if (remoteOfferedCapabilities != null && (list = Arrays.asList(remoteOfferedCapabilities)).contains(AmqpSupport.SHARED_SUBS)) {
                supported = true;
            }
            if (!supported) {
                this.sharedSubsNotSupported = true;
                if (((JmsConsumerInfo)this.resourceInfo).isDurable()) {
                    ((Receiver)this.endpoint).detach();
                } else {
                    ((Receiver)this.endpoint).close();
                }
            }
        }
    }

    @Override
    protected void afterClosed(AmqpConsumer resource, JmsConsumerInfo info) {
        AmqpConnection connection = ((AmqpSession)this.getParent()).getConnection();
        AmqpSubscriptionTracker subTracker = connection.getSubTracker();
        subTracker.consumerRemoved(info);
    }

    @Override
    public void processRemoteDetach(AmqpProvider provider) {
        this.handleClosed(provider, null);
    }

    @Override
    protected AmqpConsumer createResource(AmqpSession parent, JmsConsumerInfo resourceInfo, Receiver endpoint) {
        return new AmqpConsumer(parent, resourceInfo, endpoint);
    }

    @Override
    protected Exception getOpenAbortException() {
        if (this.sharedSubsNotSupported) {
            return new JMSRuntimeException("Remote peer does not support shared subscriptions");
        }
        org.apache.qpid.proton.amqp.transport.Source source = ((Receiver)this.endpoint).getRemoteSource();
        if (source != null) {
            return super.getOpenAbortException();
        }
        return new InvalidDestinationException("Link creation was refused");
    }

    @Override
    protected boolean isClosePending() {
        return this.sharedSubsNotSupported || ((Receiver)this.endpoint).getRemoteSource() == null;
    }

    private void configureSource(Source source) {
        HashMap<Symbol, Object> filters = new HashMap<Symbol, Object>();
        Symbol[] outcomes = new Symbol[]{Accepted.DESCRIPTOR_SYMBOL, Rejected.DESCRIPTOR_SYMBOL, Released.DESCRIPTOR_SYMBOL, Modified.DESCRIPTOR_SYMBOL};
        if (((JmsConsumerInfo)this.resourceInfo).isDurable()) {
            source.setExpiryPolicy(TerminusExpiryPolicy.NEVER);
            source.setDurable(TerminusDurability.UNSETTLED_STATE);
            source.setDistributionMode(AmqpSupport.COPY);
        } else {
            source.setDurable(TerminusDurability.NONE);
            source.setExpiryPolicy(TerminusExpiryPolicy.LINK_DETACH);
        }
        if (((JmsConsumerInfo)this.resourceInfo).isBrowser()) {
            source.setDistributionMode(AmqpSupport.COPY);
        }
        LinkedList<Symbol> capabilities = new LinkedList<Symbol>();
        Symbol typeCapability = AmqpDestinationHelper.INSTANCE.toTypeCapability(((JmsConsumerInfo)this.resourceInfo).getDestination());
        if (typeCapability != null) {
            capabilities.add(typeCapability);
        }
        if (((JmsConsumerInfo)this.resourceInfo).isShared()) {
            capabilities.add(AmqpSupport.SHARED);
        }
        if (!((JmsConsumerInfo)this.resourceInfo).isExplicitClientID()) {
            capabilities.add(AmqpSupport.GLOBAL);
        }
        if (!capabilities.isEmpty()) {
            Symbol[] capArray = capabilities.toArray(new Symbol[capabilities.size()]);
            source.setCapabilities(capArray);
        }
        source.setOutcomes(outcomes);
        source.setDefaultOutcome((Outcome)AmqpSupport.MODIFIED_FAILED);
        if (((JmsConsumerInfo)this.resourceInfo).isNoLocal()) {
            filters.put(AmqpSupport.JMS_NO_LOCAL_SYMBOL, AmqpJmsNoLocalType.NO_LOCAL);
        }
        if (((JmsConsumerInfo)this.resourceInfo).getSelector() != null && !((JmsConsumerInfo)this.resourceInfo).getSelector().trim().equals("")) {
            filters.put(AmqpSupport.JMS_SELECTOR_SYMBOL, new AmqpJmsSelectorType(((JmsConsumerInfo)this.resourceInfo).getSelector()));
        }
        if (!filters.isEmpty()) {
            source.setFilter(filters);
        }
    }
}

