/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.jms.IllegalStateException;
import javax.jms.TransactionRolledBackException;
import org.apache.qpid.jms.meta.JmsConsumerId;
import org.apache.qpid.jms.meta.JmsProducerId;
import org.apache.qpid.jms.meta.JmsSessionInfo;
import org.apache.qpid.jms.meta.JmsTransactionId;
import org.apache.qpid.jms.meta.JmsTransactionInfo;
import org.apache.qpid.jms.provider.AsyncResult;
import org.apache.qpid.jms.provider.amqp.AmqpConsumer;
import org.apache.qpid.jms.provider.amqp.AmqpProducer;
import org.apache.qpid.jms.provider.amqp.AmqpProvider;
import org.apache.qpid.jms.provider.amqp.AmqpResource;
import org.apache.qpid.jms.provider.amqp.AmqpResourceParent;
import org.apache.qpid.jms.provider.amqp.AmqpSession;
import org.apache.qpid.jms.provider.amqp.AmqpTransactionCoordinator;
import org.apache.qpid.jms.provider.amqp.builders.AmqpTransactionCoordinatorBuilder;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.messaging.Accepted;
import org.apache.qpid.proton.amqp.messaging.Outcome;
import org.apache.qpid.proton.amqp.transaction.TransactionalState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpTransactionContext
implements AmqpResourceParent {
    private static final Logger LOG = LoggerFactory.getLogger(AmqpTransactionContext.class);
    private final AmqpSession session;
    private final Map<JmsConsumerId, AmqpConsumer> txConsumers = new HashMap<JmsConsumerId, AmqpConsumer>();
    private final Map<JmsProducerId, AmqpProducer> txProducers = new HashMap<JmsProducerId, AmqpProducer>();
    private JmsTransactionId current;
    private TransactionalState cachedAcceptedState;
    private TransactionalState cachedTransactedState;
    private AmqpTransactionCoordinator coordinator;

    public AmqpTransactionContext(AmqpSession session, JmsSessionInfo resourceInfo) {
        this.session = session;
    }

    public void begin(final JmsTransactionId txId, final AsyncResult request) throws Exception {
        if (this.current != null) {
            throw new IOException("Begin called while a TX is still Active.");
        }
        final AsyncResult declareCompletion = new AsyncResult(){

            @Override
            public void onSuccess() {
                AmqpTransactionContext.this.current = txId;
                AmqpTransactionContext.this.cachedAcceptedState = new TransactionalState();
                AmqpTransactionContext.this.cachedAcceptedState.setOutcome((Outcome)Accepted.getInstance());
                AmqpTransactionContext.this.cachedAcceptedState.setTxnId(AmqpTransactionContext.this.getAmqpTransactionId());
                AmqpTransactionContext.this.cachedTransactedState = new TransactionalState();
                AmqpTransactionContext.this.cachedTransactedState.setTxnId(AmqpTransactionContext.this.getAmqpTransactionId());
                request.onSuccess();
            }

            @Override
            public void onFailure(Throwable result) {
                AmqpTransactionContext.this.current = null;
                AmqpTransactionContext.this.cachedAcceptedState = null;
                AmqpTransactionContext.this.cachedTransactedState = null;
                request.onFailure(result);
            }

            @Override
            public boolean isComplete() {
                return AmqpTransactionContext.this.current != null;
            }
        };
        if (this.coordinator == null || this.coordinator.isClosed()) {
            AmqpTransactionCoordinatorBuilder builder = new AmqpTransactionCoordinatorBuilder(this, (JmsSessionInfo)this.session.getResourceInfo());
            builder.buildResource(new AsyncResult(){

                @Override
                public void onSuccess() {
                    try {
                        AmqpTransactionContext.this.coordinator.declare(txId, declareCompletion);
                    }
                    catch (Exception e) {
                        request.onFailure(e);
                    }
                }

                @Override
                public void onFailure(Throwable result) {
                    request.onFailure(result);
                }

                @Override
                public boolean isComplete() {
                    return request.isComplete();
                }
            });
        } else {
            this.coordinator.declare(txId, declareCompletion);
        }
    }

    public void commit(JmsTransactionInfo transactionInfo, AsyncResult request) throws Exception {
        if (!transactionInfo.getId().equals(this.current)) {
            if (!transactionInfo.isInDoubt() && this.current == null) {
                throw new IllegalStateException("Commit called with no active Transaction.");
            }
            if (!transactionInfo.isInDoubt() && this.current != null) {
                throw new IllegalStateException("Attempt to Commit a transaction other than the current one");
            }
            throw new TransactionRolledBackException("Transaction in doubt and cannot be committed.");
        }
        this.preCommit();
        DischargeCompletion dischargeResult = new DischargeCompletion(request, true);
        LOG.trace("TX Context[{}] committing current TX[[]]", (Object)this, (Object)this.current);
        this.coordinator.discharge(this.current, dischargeResult, true);
    }

    public void rollback(JmsTransactionInfo transactionInfo, AsyncResult request) throws Exception {
        if (!transactionInfo.getId().equals(this.current)) {
            if (!transactionInfo.isInDoubt() && this.current == null) {
                throw new IllegalStateException("Rollback called with no active Transaction.");
            }
            if (!transactionInfo.isInDoubt() && this.current != null) {
                throw new IllegalStateException("Attempt to rollback a transaction other than the current one");
            }
            request.onSuccess();
            return;
        }
        this.preRollback();
        DischargeCompletion dischargeResult = new DischargeCompletion(request, false);
        LOG.trace("TX Context[{}] rolling back current TX[[]]", (Object)this, (Object)this.current);
        this.coordinator.discharge(this.current, dischargeResult, false);
    }

    public void registerTxConsumer(AmqpConsumer consumer) {
        this.txConsumers.put(consumer.getConsumerId(), consumer);
    }

    public boolean isInTransaction(JmsConsumerId consumerId) {
        return this.txConsumers.containsKey(consumerId);
    }

    public void registerTxProducer(AmqpProducer producer) {
        this.txProducers.put(producer.getProducerId(), producer);
    }

    public boolean isInTransaction(JmsProducerId producerId) {
        return this.txProducers.containsKey(producerId);
    }

    public AmqpSession getSession() {
        return this.session;
    }

    public TransactionalState getTxnAcceptState() {
        return this.cachedAcceptedState;
    }

    public TransactionalState getTxnEnrolledState() {
        return this.cachedTransactedState;
    }

    public JmsTransactionId getTransactionId() {
        return this.current;
    }

    public boolean isTransactionFailed() {
        return this.coordinator == null ? false : this.coordinator.isClosed();
    }

    public Binary getAmqpTransactionId() {
        Binary result = null;
        if (this.current != null) {
            result = (Binary)this.current.getProviderHint();
        }
        return result;
    }

    public String toString() {
        return this.session.getSessionId() + ": txContext";
    }

    private void preCommit() {
        for (AmqpConsumer consumer : this.txConsumers.values()) {
            consumer.preCommit();
        }
    }

    private void preRollback() {
        for (AmqpConsumer consumer : this.txConsumers.values()) {
            consumer.preRollback();
        }
    }

    private void postCommit() {
        for (AmqpConsumer consumer : this.txConsumers.values()) {
            consumer.postCommit();
        }
        this.txConsumers.clear();
        this.txProducers.clear();
    }

    private void postRollback() {
        for (AmqpConsumer consumer : this.txConsumers.values()) {
            consumer.postRollback();
        }
        this.txConsumers.clear();
        this.txProducers.clear();
    }

    @Override
    public void addChildResource(AmqpResource resource) {
        if (resource instanceof AmqpTransactionCoordinator) {
            this.coordinator = (AmqpTransactionCoordinator)resource;
        }
    }

    @Override
    public void removeChildResource(AmqpResource resource) {
    }

    @Override
    public AmqpProvider getProvider() {
        return this.session.getProvider();
    }

    private class SendCompletion
    implements AsyncResult {
        private int pendingCompletions;
        private final JmsTransactionInfo info;
        private final DischargeCompletion request;
        private boolean commit;

        public SendCompletion(JmsTransactionInfo info, DischargeCompletion request, int pendingCompletions, boolean commit) {
            this.info = info;
            this.request = request;
            this.pendingCompletions = pendingCompletions;
            this.commit = commit;
        }

        @Override
        public void onFailure(Throwable result) {
            if (--this.pendingCompletions == 0) {
                try {
                    LOG.trace("TX Context[{}] rolling back current TX[[]]", (Object)this, (Object)AmqpTransactionContext.this.current);
                    AmqpTransactionContext.this.coordinator.discharge(AmqpTransactionContext.this.current, this.request, false);
                }
                catch (Throwable error) {
                    this.request.onFailure(error);
                }
            } else {
                this.commit = false;
            }
        }

        @Override
        public void onSuccess() {
            if (--this.pendingCompletions == 0) {
                try {
                    LOG.trace("TX Context[{}] {} current TX[[]]", new Object[]{this, this.commit ? "committing" : "rolling back", AmqpTransactionContext.this.current});
                    AmqpTransactionContext.this.coordinator.discharge(AmqpTransactionContext.this.current, this.request, this.commit);
                }
                catch (Throwable error) {
                    this.request.onFailure(error);
                }
            }
        }

        @Override
        public boolean isComplete() {
            return this.request.isComplete();
        }
    }

    private class DischargeCompletion
    implements AsyncResult {
        private final AsyncResult request;
        private final boolean commit;

        public DischargeCompletion(AsyncResult request, boolean commit) {
            this.request = request;
            this.commit = commit;
        }

        @Override
        public void onFailure(Throwable result) {
            this.cleanup();
            this.request.onFailure(result);
        }

        @Override
        public void onSuccess() {
            this.cleanup();
            this.request.onSuccess();
        }

        @Override
        public boolean isComplete() {
            return this.request.isComplete();
        }

        private void cleanup() {
            AmqpTransactionContext.this.current = null;
            if (this.commit) {
                AmqpTransactionContext.this.postCommit();
            } else {
                AmqpTransactionContext.this.postRollback();
            }
        }
    }
}

