/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp;

import java.io.IOException;
import java.nio.BufferOverflowException;
import java.util.concurrent.ScheduledFuture;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.TransactionRolledBackException;
import org.apache.qpid.jms.JmsOperationTimedOutException;
import org.apache.qpid.jms.meta.JmsSessionInfo;
import org.apache.qpid.jms.meta.JmsTransactionId;
import org.apache.qpid.jms.provider.AsyncResult;
import org.apache.qpid.jms.provider.amqp.AmqpAbstractResource;
import org.apache.qpid.jms.provider.amqp.AmqpProvider;
import org.apache.qpid.jms.provider.amqp.AmqpResourceParent;
import org.apache.qpid.jms.provider.amqp.AmqpSupport;
import org.apache.qpid.jms.provider.amqp.AmqpTransactionContext;
import org.apache.qpid.jms.provider.amqp.AmqpTransferTagGenerator;
import org.apache.qpid.jms.util.IOExceptionSupport;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.Rejected;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.amqp.transaction.Declare;
import org.apache.qpid.proton.amqp.transaction.Declared;
import org.apache.qpid.proton.amqp.transaction.Discharge;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Sender;
import org.apache.qpid.proton.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpTransactionCoordinator
extends AmqpAbstractResource<JmsSessionInfo, Sender> {
    private static final Logger LOG = LoggerFactory.getLogger(AmqpTransactionCoordinator.class);
    private static final Boolean ROLLBACK_MARKER = Boolean.FALSE;
    private static final Boolean COMMIT_MARKER = Boolean.TRUE;
    private final byte[] OUTBOUND_BUFFER = new byte[64];
    private final AmqpTransferTagGenerator tagGenerator = new AmqpTransferTagGenerator();

    public AmqpTransactionCoordinator(JmsSessionInfo resourceInfo, Sender endpoint, AmqpResourceParent parent) {
        super(resourceInfo, endpoint, parent);
    }

    @Override
    public void processDeliveryUpdates(AmqpProvider provider, Delivery delivery) throws IOException {
        try {
            if (delivery != null && delivery.remotelySettled()) {
                DeliveryState state = delivery.getRemoteState();
                if (delivery.getContext() == null || !(delivery.getContext() instanceof OperationContext)) {
                    return;
                }
                OperationContext context = (OperationContext)delivery.getContext();
                AsyncResult pendingRequest = context.getRequest();
                JmsTransactionId txId = context.getTransactionId();
                if (state instanceof Declared) {
                    LOG.debug("New TX started: {}", (Object)txId);
                    Declared declared = (Declared)state;
                    txId.setProviderHint(declared.getTxnId());
                    pendingRequest.onSuccess();
                } else if (state instanceof Rejected) {
                    LOG.debug("Last TX request failed: {}", (Object)txId);
                    Rejected rejected = (Rejected)state;
                    Exception cause = AmqpSupport.convertToException(this.getParent().getProvider(), this.getEndpoint(), rejected.getError());
                    Object failureCause = null;
                    failureCause = txId.getProviderContext().equals(COMMIT_MARKER) ? new TransactionRolledBackException(cause.getMessage()) : new JMSException(cause.getMessage());
                    txId.setProviderHint(null);
                    pendingRequest.onFailure((Throwable)failureCause);
                } else {
                    LOG.debug("Last TX request succeeded: {}", (Object)txId);
                    pendingRequest.onSuccess();
                }
                delivery.settle();
                pendingRequest = null;
                if (context.getTimeout() != null) {
                    context.getTimeout().cancel(false);
                }
            }
            super.processDeliveryUpdates(provider, delivery);
        }
        catch (Exception e) {
            throw IOExceptionSupport.create(e);
        }
    }

    public void declare(JmsTransactionId txId, AsyncResult request) throws Exception {
        if (this.isClosed()) {
            request.onFailure(new JMSException("Cannot start new transaction: Coordinator remotely closed"));
            return;
        }
        if (txId.getProviderHint() != null) {
            throw new IllegalStateException("Declar called while a TX is still Active.");
        }
        Message message = Message.Factory.create();
        Declare declare = new Declare();
        message.setBody((Section)new AmqpValue((Object)declare));
        ScheduledFuture<?> timeout = this.scheduleTimeoutIfNeeded("Timed out waiting for discharge of TX.", request);
        OperationContext context = new OperationContext(txId, request, timeout);
        Delivery delivery = ((Sender)this.getEndpoint()).delivery(this.tagGenerator.getNextTag());
        delivery.setContext((Object)context);
        this.sendTxCommand(message);
    }

    public void discharge(JmsTransactionId txId, AmqpTransactionContext.DischargeCompletion request) throws Exception {
        if (this.isClosed()) {
            Object failureCause = null;
            failureCause = request.isCommit() ? new TransactionRolledBackException("Transaction inbout: Coordinator remotely closed") : new JMSException("Rollback cannot complete: Coordinator remotely closed");
            request.onFailure((Throwable)failureCause);
            return;
        }
        if (txId.getProviderHint() == null) {
            throw new IllegalStateException("Discharge called with no active Transaction.");
        }
        txId.setProviderContext(request.isCommit() ? COMMIT_MARKER : ROLLBACK_MARKER);
        Message message = Message.Factory.create();
        Discharge discharge = new Discharge();
        discharge.setFail(Boolean.valueOf(!request.isCommit()));
        discharge.setTxnId((Binary)txId.getProviderHint());
        message.setBody((Section)new AmqpValue((Object)discharge));
        ScheduledFuture<?> timeout = this.scheduleTimeoutIfNeeded("Timed out waiting for discharge of TX.", request);
        OperationContext context = new OperationContext(txId, request, timeout);
        Delivery delivery = ((Sender)this.getEndpoint()).delivery(this.tagGenerator.getNextTag());
        delivery.setContext((Object)context);
        this.sendTxCommand(message);
    }

    @Override
    public void closeResource(AmqpProvider provider, Throwable cause, boolean localClose) {
        Delivery pending = ((Sender)this.getEndpoint()).head();
        while (pending != null) {
            Delivery nextPending = pending.next();
            if (pending.getContext() != null && pending.getContext() instanceof OperationContext) {
                OperationContext context = (OperationContext)pending.getContext();
                context.request.onFailure(cause);
            }
            pending = nextPending;
        }
        if (this.getParent() != null) {
            this.getParent().removeChildResource(this);
        }
        if (this.getEndpoint() != null) {
            ((Sender)this.getEndpoint()).close();
            ((Sender)this.getEndpoint()).free();
        }
        LOG.debug("Transaction Coordinator link {} was remotely closed", this.getResourceInfo());
    }

    private ScheduledFuture<?> scheduleTimeoutIfNeeded(String cause, AsyncResult pendingRequest) {
        AmqpProvider provider = this.getParent().getProvider();
        if (provider.getRequestTimeout() != -1L) {
            return provider.scheduleRequestTimeout(pendingRequest, provider.getRequestTimeout(), (Exception)((Object)new JmsOperationTimedOutException(cause)));
        }
        return null;
    }

    private void sendTxCommand(Message message) throws IOException {
        int encodedSize = 0;
        byte[] buffer = this.OUTBOUND_BUFFER;
        while (true) {
            try {
                encodedSize = message.encode(buffer, 0, buffer.length);
            }
            catch (BufferOverflowException e) {
                buffer = new byte[buffer.length * 2];
                continue;
            }
            break;
        }
        Sender sender = (Sender)this.getEndpoint();
        sender.send(buffer, 0, encodedSize);
        sender.advance();
    }

    private class OperationContext {
        private final AsyncResult request;
        private final ScheduledFuture<?> timeout;
        private final JmsTransactionId transactionId;

        public OperationContext(JmsTransactionId transactionId, AsyncResult request, ScheduledFuture<?> timeout) {
            this.transactionId = transactionId;
            this.request = request;
            this.timeout = timeout;
        }

        public JmsTransactionId getTransactionId() {
            return this.transactionId;
        }

        public AsyncResult getRequest() {
            return this.request;
        }

        public ScheduledFuture<?> getTimeout() {
            return this.timeout;
        }
    }
}

