/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.transports.netty;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.URI;
import java.security.Principal;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLContext;
import org.apache.qpid.jms.transports.Transport;
import org.apache.qpid.jms.transports.TransportListener;
import org.apache.qpid.jms.transports.TransportOptions;
import org.apache.qpid.jms.transports.TransportSslOptions;
import org.apache.qpid.jms.transports.TransportSupport;
import org.apache.qpid.jms.util.IOExceptionSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyTcpTransport
implements Transport {
    private static final Logger LOG = LoggerFactory.getLogger(NettyTcpTransport.class);
    private static final int SHUTDOWN_TIMEOUT = 50;
    protected Bootstrap bootstrap;
    protected EventLoopGroup group;
    protected Channel channel;
    protected TransportListener listener;
    private final TransportOptions options;
    private final URI remote;
    private final AtomicBoolean connected = new AtomicBoolean();
    private final AtomicBoolean closed = new AtomicBoolean();
    private final CountDownLatch connectLatch = new CountDownLatch(1);
    private volatile IOException failureCause;

    public NettyTcpTransport(URI remoteLocation, TransportOptions options) {
        this(null, remoteLocation, options);
    }

    public NettyTcpTransport(TransportListener listener, URI remoteLocation, TransportOptions options) {
        if (options == null) {
            throw new IllegalArgumentException("Transport Options cannot be null");
        }
        if (remoteLocation == null) {
            throw new IllegalArgumentException("Transport remote location cannot be null");
        }
        this.options = options;
        this.listener = listener;
        this.remote = remoteLocation;
    }

    @Override
    public void connect(SSLContext sslContextOverride) throws IOException {
        boolean useEpoll;
        SslHandler sslHandler;
        if (this.listener == null) {
            throw new IllegalStateException("A transport listener must be set before connection attempts.");
        }
        if (this.isSecure()) {
            try {
                TransportSslOptions sslOptions = this.getSslOptions();
                sslOptions.setSslContextOverride(sslContextOverride);
                sslHandler = TransportSupport.createSslHandler(this.getRemoteLocation(), sslOptions);
            }
            catch (Exception ex) {
                throw IOExceptionSupport.create(ex);
            }
        } else {
            sslHandler = null;
        }
        boolean bl = useEpoll = this.getTransportOptions().isUseEpoll() && Epoll.isAvailable();
        if (useEpoll) {
            LOG.trace("Netty Transport using Epoll mode");
            this.group = new EpollEventLoopGroup(1);
        } else {
            LOG.trace("Netty Transport using NIO mode");
            this.group = new NioEventLoopGroup(1);
        }
        this.bootstrap = new Bootstrap();
        this.bootstrap.group(this.group);
        if (useEpoll) {
            this.bootstrap.channel(EpollSocketChannel.class);
        } else {
            this.bootstrap.channel(NioSocketChannel.class);
        }
        this.bootstrap.handler((ChannelHandler)new ChannelInitializer<Channel>(){

            public void initChannel(Channel connectedChannel) throws Exception {
                NettyTcpTransport.this.configureChannel(connectedChannel, sslHandler);
            }
        });
        this.configureNetty(this.bootstrap, this.getTransportOptions());
        ChannelFuture future = this.bootstrap.connect(this.getRemoteHost(), this.getRemotePort());
        future.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    NettyTcpTransport.this.handleException(future.channel(), IOExceptionSupport.create(future.cause()));
                }
            }
        });
        try {
            this.connectLatch.await();
        }
        catch (InterruptedException ex) {
            LOG.debug("Transport connection was interrupted.");
            Thread.interrupted();
            this.failureCause = IOExceptionSupport.create(ex);
        }
        if (this.failureCause != null) {
            if (this.channel != null) {
                this.channel.close().syncUninterruptibly();
                this.channel = null;
            }
            if (this.group != null) {
                Future fut = this.group.shutdownGracefully(0L, 50L, TimeUnit.MILLISECONDS);
                if (!fut.awaitUninterruptibly(100L)) {
                    LOG.trace("Channel group shutdown failed to complete in allotted time");
                }
                this.group = null;
            }
            throw this.failureCause;
        }
        this.channel.eventLoop().execute(new Runnable(){

            @Override
            public void run() {
                if (NettyTcpTransport.this.failureCause != null) {
                    NettyTcpTransport.this.channel.pipeline().fireExceptionCaught((Throwable)NettyTcpTransport.this.failureCause);
                }
            }
        });
    }

    @Override
    public boolean isConnected() {
        return this.connected.get();
    }

    @Override
    public boolean isSecure() {
        return this.options.isSSL();
    }

    @Override
    public void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            this.connected.set(false);
            try {
                if (this.channel != null) {
                    this.channel.close().syncUninterruptibly();
                }
            }
            finally {
                Future fut;
                if (this.group != null && !(fut = this.group.shutdownGracefully(0L, 50L, TimeUnit.MILLISECONDS)).awaitUninterruptibly(100L)) {
                    LOG.trace("Channel group shutdown failed to complete in allotted time");
                }
            }
        }
    }

    @Override
    public ByteBuf allocateSendBuffer(int size) throws IOException {
        this.checkConnected();
        return this.channel.alloc().ioBuffer(size, size);
    }

    @Override
    public void send(ByteBuf output) throws IOException {
        this.checkConnected();
        int length = output.readableBytes();
        if (length == 0) {
            return;
        }
        LOG.trace("Attempted write of: {} bytes", (Object)length);
        this.channel.writeAndFlush((Object)output);
    }

    @Override
    public TransportListener getTransportListener() {
        return this.listener;
    }

    @Override
    public void setTransportListener(TransportListener listener) {
        this.listener = listener;
    }

    @Override
    public TransportOptions getTransportOptions() {
        return this.options;
    }

    @Override
    public URI getRemoteLocation() {
        return this.remote;
    }

    @Override
    public Principal getLocalPrincipal() {
        Principal result = null;
        if (this.isSecure()) {
            SslHandler sslHandler = (SslHandler)this.channel.pipeline().get(SslHandler.class);
            result = sslHandler.engine().getSession().getLocalPrincipal();
        }
        return result;
    }

    protected String getRemoteHost() {
        return this.remote.getHost();
    }

    protected int getRemotePort() {
        if (this.remote.getPort() != -1) {
            return this.remote.getPort();
        }
        return this.isSecure() ? this.getSslOptions().getDefaultSslPort() : this.getTransportOptions().getDefaultTcpPort();
    }

    protected void addAdditionalHandlers(ChannelPipeline pipeline) {
    }

    protected ChannelInboundHandlerAdapter createChannelHandler() {
        return new NettyTcpTransportHandler();
    }

    protected void handleConnected(Channel channel) throws Exception {
        LOG.trace("Channel has become active! Channel is {}", (Object)channel);
        this.connectionEstablished(channel);
    }

    protected void handleChannelInactive(Channel channel) throws Exception {
        LOG.trace("Channel has gone inactive! Channel is {}", (Object)channel);
        if (this.connected.compareAndSet(true, false) && !this.closed.get()) {
            LOG.trace("Firing onTransportClosed listener");
            this.listener.onTransportClosed();
        }
    }

    protected void handleException(Channel channel, Throwable cause) throws Exception {
        LOG.trace("Exception on channel! Channel is {}", (Object)channel);
        if (this.connected.compareAndSet(true, false) && !this.closed.get()) {
            LOG.trace("Firing onTransportError listener");
            if (this.failureCause != null) {
                this.listener.onTransportError(this.failureCause);
            } else {
                this.listener.onTransportError(cause);
            }
        } else {
            if (this.failureCause == null) {
                LOG.trace("Holding error until connect succeeds: {}", (Object)cause.getMessage());
                this.failureCause = IOExceptionSupport.create(cause);
            }
            this.connectionFailed(channel, this.failureCause);
        }
    }

    protected final void checkConnected() throws IOException {
        if (!this.connected.get()) {
            throw new IOException("Cannot send to a non-connected transport.");
        }
    }

    private void connectionEstablished(Channel connectedChannel) {
        this.channel = connectedChannel;
        this.connected.set(true);
        this.connectLatch.countDown();
    }

    private void connectionFailed(Channel failedChannel, IOException cause) {
        this.failureCause = cause;
        this.channel = failedChannel;
        this.connected.set(false);
        this.connectLatch.countDown();
    }

    private TransportSslOptions getSslOptions() {
        return (TransportSslOptions)this.getTransportOptions();
    }

    private void configureNetty(Bootstrap bootstrap, TransportOptions options) {
        bootstrap.option(ChannelOption.TCP_NODELAY, (Object)options.isTcpNoDelay());
        bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)options.getConnectTimeout());
        bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)options.isTcpKeepAlive());
        bootstrap.option(ChannelOption.SO_LINGER, (Object)options.getSoLinger());
        if (options.getSendBufferSize() != -1) {
            bootstrap.option(ChannelOption.SO_SNDBUF, (Object)options.getSendBufferSize());
        }
        if (options.getReceiveBufferSize() != -1) {
            bootstrap.option(ChannelOption.SO_RCVBUF, (Object)options.getReceiveBufferSize());
            bootstrap.option(ChannelOption.RCVBUF_ALLOCATOR, (Object)new FixedRecvByteBufAllocator(options.getReceiveBufferSize()));
        }
        if (options.getTrafficClass() != -1) {
            bootstrap.option(ChannelOption.IP_TOS, (Object)options.getTrafficClass());
        }
    }

    private void configureChannel(Channel channel, SslHandler sslHandler) throws Exception {
        if (this.isSecure()) {
            channel.pipeline().addLast(new ChannelHandler[]{sslHandler});
        }
        if (this.getTransportOptions().isTraceBytes()) {
            channel.pipeline().addLast("logger", (ChannelHandler)new LoggingHandler(this.getClass()));
        }
        this.addAdditionalHandlers(channel.pipeline());
        channel.pipeline().addLast(new ChannelHandler[]{this.createChannelHandler()});
    }

    protected class NettyTcpTransportHandler
    extends NettyDefaultHandler<ByteBuf> {
        protected NettyTcpTransportHandler() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, ByteBuf buffer) throws Exception {
            LOG.trace("New data read: {} bytes incoming: {}", (Object)buffer.readableBytes(), (Object)buffer);
            NettyTcpTransport.this.listener.onData(buffer);
        }
    }

    protected abstract class NettyDefaultHandler<E>
    extends SimpleChannelInboundHandler<E> {
        protected NettyDefaultHandler() {
        }

        public void channelRegistered(ChannelHandlerContext context) throws Exception {
            NettyTcpTransport.this.channel = context.channel();
        }

        public void channelActive(ChannelHandlerContext context) throws Exception {
            if (!NettyTcpTransport.this.isSecure()) {
                NettyTcpTransport.this.handleConnected(context.channel());
            } else {
                SslHandler sslHandler = (SslHandler)context.pipeline().get(SslHandler.class);
                sslHandler.handshakeFuture().addListener((GenericFutureListener)new GenericFutureListener<Future<Channel>>(){

                    public void operationComplete(Future<Channel> future) throws Exception {
                        if (future.isSuccess()) {
                            LOG.trace("SSL Handshake has completed: {}", (Object)NettyTcpTransport.this.channel);
                            NettyTcpTransport.this.handleConnected(NettyTcpTransport.this.channel);
                        } else {
                            LOG.trace("SSL Handshake has failed: {}", (Object)NettyTcpTransport.this.channel);
                            NettyTcpTransport.this.handleException(NettyTcpTransport.this.channel, future.cause());
                        }
                    }
                });
            }
        }

        public void channelInactive(ChannelHandlerContext context) throws Exception {
            NettyTcpTransport.this.handleChannelInactive(context.channel());
        }

        public void exceptionCaught(ChannelHandlerContext context, Throwable cause) throws Exception {
            NettyTcpTransport.this.handleException(context.channel(), cause);
        }
    }
}

