/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.transports.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import org.apache.qpid.jms.transports.TransportListener;
import org.apache.qpid.jms.transports.TransportOptions;
import org.apache.qpid.jms.transports.netty.NettyTcpTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyWsTransport
extends NettyTcpTransport {
    private static final Logger LOG = LoggerFactory.getLogger(NettyWsTransport.class);
    private static final String AMQP_SUB_PROTOCOL = "amqp";

    public NettyWsTransport(URI remoteLocation, TransportOptions options) {
        super(null, remoteLocation, options);
    }

    public NettyWsTransport(TransportListener listener, URI remoteLocation, TransportOptions options) {
        super(listener, remoteLocation, options);
    }

    @Override
    public void send(ByteBuf output) throws IOException {
        this.checkConnected();
        int length = output.readableBytes();
        if (length == 0) {
            return;
        }
        LOG.trace("Attempted write of: {} bytes", (Object)length);
        this.channel.writeAndFlush((Object)new BinaryWebSocketFrame(output));
    }

    @Override
    protected ChannelInboundHandlerAdapter createChannelHandler() {
        return new NettyWebSocketTransportHandler();
    }

    @Override
    protected void addAdditionalHandlers(ChannelPipeline pipeline) {
        pipeline.addLast(new ChannelHandler[]{new HttpClientCodec()});
        pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(8192)});
    }

    @Override
    protected void handleConnected(Channel channel) throws Exception {
        LOG.trace("Channel has become active, awaiting WebSocket handshake! Channel is {}", (Object)channel);
    }

    private class NettyWebSocketTransportHandler
    extends NettyTcpTransport.NettyDefaultHandler<Object> {
        private final WebSocketClientHandshaker handshaker;

        public NettyWebSocketTransportHandler() {
            this.handshaker = WebSocketClientHandshakerFactory.newHandshaker((URI)NettyWsTransport.this.getRemoteLocation(), (WebSocketVersion)WebSocketVersion.V13, (String)NettyWsTransport.AMQP_SUB_PROTOCOL, (boolean)true, (HttpHeaders)new DefaultHttpHeaders(), (int)NettyWsTransport.this.getMaxFrameSize());
        }

        @Override
        public void channelActive(ChannelHandlerContext context) throws Exception {
            this.handshaker.handshake(context.channel());
            super.channelActive(context);
        }

        protected void channelRead0(ChannelHandlerContext ctx, Object message) throws Exception {
            LOG.trace("New data read: incoming: {}", message);
            Channel ch = ctx.channel();
            if (!this.handshaker.isHandshakeComplete()) {
                this.handshaker.finishHandshake(ch, (FullHttpResponse)message);
                LOG.trace("WebSocket Client connected! {}", (Object)ctx.channel());
                NettyWsTransport.super.handleConnected(ch);
                return;
            }
            if (message instanceof FullHttpResponse) {
                FullHttpResponse response = (FullHttpResponse)message;
                throw new IllegalStateException("Unexpected FullHttpResponse (getStatus=" + response.status() + ", content=" + response.content().toString(StandardCharsets.UTF_8) + ')');
            }
            WebSocketFrame frame = (WebSocketFrame)message;
            if (frame instanceof TextWebSocketFrame) {
                TextWebSocketFrame textFrame = (TextWebSocketFrame)frame;
                LOG.warn("WebSocket Client received message: " + textFrame.text());
                ctx.fireExceptionCaught((Throwable)new IOException("Received invalid frame over WebSocket."));
            } else if (frame instanceof BinaryWebSocketFrame) {
                BinaryWebSocketFrame binaryFrame = (BinaryWebSocketFrame)frame;
                LOG.trace("WebSocket Client received data: {} bytes", (Object)binaryFrame.content().readableBytes());
                NettyWsTransport.this.listener.onData(binaryFrame.content());
            } else if (frame instanceof PingWebSocketFrame) {
                LOG.trace("WebSocket Client received ping, response with pong");
                ch.write((Object)new PongWebSocketFrame(frame.content()));
            } else if (frame instanceof CloseWebSocketFrame) {
                LOG.trace("WebSocket Client received closing");
                ch.close();
            }
        }
    }
}

