/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import javax.jms.BytesMessage;
import javax.jms.CompletionListener;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageFormatException;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import org.apache.qpid.jms.JmsConnection;
import org.apache.qpid.jms.JmsDestination;
import org.apache.qpid.jms.JmsDurableTopicSubscriber;
import org.apache.qpid.jms.JmsLocalTransactionContext;
import org.apache.qpid.jms.JmsMessageConsumer;
import org.apache.qpid.jms.JmsMessageDispatcher;
import org.apache.qpid.jms.JmsMessageProducer;
import org.apache.qpid.jms.JmsNoTxTransactionContext;
import org.apache.qpid.jms.JmsQueue;
import org.apache.qpid.jms.JmsQueueBrowser;
import org.apache.qpid.jms.JmsQueueReceiver;
import org.apache.qpid.jms.JmsQueueSender;
import org.apache.qpid.jms.JmsSharedDurableMessageConsumer;
import org.apache.qpid.jms.JmsSharedMessageConsumer;
import org.apache.qpid.jms.JmsTemporaryDestination;
import org.apache.qpid.jms.JmsTopic;
import org.apache.qpid.jms.JmsTopicPublisher;
import org.apache.qpid.jms.JmsTopicSubscriber;
import org.apache.qpid.jms.JmsTransactionContext;
import org.apache.qpid.jms.exceptions.JmsConnectionFailedException;
import org.apache.qpid.jms.exceptions.JmsExceptionSupport;
import org.apache.qpid.jms.message.JmsInboundMessageDispatch;
import org.apache.qpid.jms.message.JmsMessage;
import org.apache.qpid.jms.message.JmsMessageTransformation;
import org.apache.qpid.jms.message.JmsOutboundMessageDispatch;
import org.apache.qpid.jms.meta.JmsConsumerId;
import org.apache.qpid.jms.meta.JmsConsumerInfo;
import org.apache.qpid.jms.meta.JmsProducerId;
import org.apache.qpid.jms.meta.JmsProducerInfo;
import org.apache.qpid.jms.meta.JmsResource;
import org.apache.qpid.jms.meta.JmsSessionId;
import org.apache.qpid.jms.meta.JmsSessionInfo;
import org.apache.qpid.jms.policy.JmsDeserializationPolicy;
import org.apache.qpid.jms.policy.JmsMessageIDPolicy;
import org.apache.qpid.jms.policy.JmsPrefetchPolicy;
import org.apache.qpid.jms.policy.JmsPresettlePolicy;
import org.apache.qpid.jms.policy.JmsRedeliveryPolicy;
import org.apache.qpid.jms.provider.Provider;
import org.apache.qpid.jms.provider.ProviderConstants;
import org.apache.qpid.jms.provider.ProviderFuture;
import org.apache.qpid.jms.selector.SelectorParser;
import org.apache.qpid.jms.selector.filter.FilterException;
import org.apache.qpid.jms.util.NoOpExecutor;
import org.apache.qpid.jms.util.QpidJMSThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsSession
implements AutoCloseable,
Session,
QueueSession,
TopicSession,
JmsMessageDispatcher {
    private static final Logger LOG = LoggerFactory.getLogger(JmsSession.class);
    private final JmsConnection connection;
    private final int acknowledgementMode;
    private final Map<JmsProducerId, JmsMessageProducer> producers = new ConcurrentHashMap<JmsProducerId, JmsMessageProducer>();
    private final Map<JmsConsumerId, JmsMessageConsumer> consumers = new ConcurrentHashMap<JmsConsumerId, JmsMessageConsumer>();
    private MessageListener messageListener;
    private final AtomicBoolean closed = new AtomicBoolean();
    private final AtomicBoolean started = new AtomicBoolean();
    private final JmsSessionInfo sessionInfo;
    private final ReentrantLock sendLock = new ReentrantLock();
    private volatile ThreadPoolExecutor deliveryExecutor;
    private volatile ThreadPoolExecutor completionExcecutor;
    private AtomicReference<Thread> deliveryThread = new AtomicReference();
    private AtomicReference<Thread> completionThread = new AtomicReference();
    private final AtomicLong consumerIdGenerator = new AtomicLong();
    private final AtomicLong producerIdGenerator = new AtomicLong();
    private JmsTransactionContext transactionContext;
    private boolean sessionRecovered;
    private final AtomicReference<Throwable> failureCause = new AtomicReference();
    private final Deque<SendCompletion> asyncSendQueue = new ConcurrentLinkedDeque<SendCompletion>();

    protected JmsSession(JmsConnection connection, JmsSessionId sessionId, int acknowledgementMode) throws JMSException {
        this.connection = connection;
        this.acknowledgementMode = acknowledgementMode;
        if (acknowledgementMode == 0) {
            this.setTransactionContext(new JmsLocalTransactionContext(this));
        } else {
            this.setTransactionContext(new JmsNoTxTransactionContext());
        }
        this.sessionInfo = new JmsSessionInfo(sessionId);
        this.sessionInfo.setAcknowledgementMode(acknowledgementMode);
        this.sessionInfo.setSendAcksAsync(connection.isForceAsyncAcks());
        this.sessionInfo.setMessageIDPolicy(connection.getMessageIDPolicy().copy());
        this.sessionInfo.setPrefetchPolicy(connection.getPrefetchPolicy().copy());
        this.sessionInfo.setPresettlePolicy(connection.getPresettlePolicy().copy());
        this.sessionInfo.setRedeliveryPolicy(connection.getRedeliveryPolicy().copy());
        this.sessionInfo.setDeserializationPolicy(connection.getDeserializationPolicy());
        connection.createResource(this.sessionInfo);
        try {
            this.getTransactionContext().begin();
        }
        catch (Exception e) {
            try {
                connection.destroyResource(this.sessionInfo);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    int acknowledgementMode() {
        return this.acknowledgementMode;
    }

    public int getAcknowledgeMode() throws JMSException {
        this.checkClosed();
        return this.acknowledgementMode;
    }

    public boolean getTransacted() throws JMSException {
        this.checkClosed();
        return this.isTransacted();
    }

    public MessageListener getMessageListener() throws JMSException {
        this.checkClosed();
        return this.messageListener;
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        this.checkClosed();
        this.messageListener = listener;
    }

    public void recover() throws JMSException {
        this.checkClosed();
        if (this.getTransacted()) {
            throw new IllegalStateException("Cannot call recover() on a transacted session");
        }
        boolean wasStarted = this.isStarted();
        this.stop();
        this.connection.recover(this.getSessionId());
        this.sessionRecovered = true;
        if (wasStarted) {
            this.start();
        }
    }

    public void commit() throws JMSException {
        this.checkClosed();
        this.checkIsCompletionThread();
        if (!this.getTransacted()) {
            throw new IllegalStateException("Not a transacted session");
        }
        this.transactionContext.commit();
    }

    public void rollback() throws JMSException {
        this.checkClosed();
        this.checkIsCompletionThread();
        if (!this.getTransacted()) {
            throw new IllegalStateException("Not a transacted session");
        }
        try {
            for (JmsMessageConsumer c : this.consumers.values()) {
                c.suspendForRollback();
            }
        }
        finally {
            this.transactionContext.rollback();
        }
        for (JmsMessageConsumer c : this.consumers.values()) {
            c.resumeAfterRollback();
        }
    }

    public void run() {
        try {
            this.checkClosed();
        }
        catch (IllegalStateException e) {
            throw new RuntimeException(e);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws JMSException {
        this.checkIsDeliveryThread();
        this.checkIsCompletionThread();
        if (!this.closed.get()) {
            this.doClose();
        }
    }

    protected void doClose() throws JMSException {
        boolean interrupted = Thread.interrupted();
        this.shutdown();
        try {
            this.connection.destroyResource(this.sessionInfo);
        }
        catch (JmsConnectionFailedException jmsConnectionFailedException) {
            // empty catch block
        }
        this.connection.removeSession(this.sessionInfo);
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    protected void shutdown() throws JMSException {
        this.shutdown(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdown(Throwable cause) throws JMSException {
        if (this.closed.compareAndSet(false, true)) {
            this.sessionInfo.setState(JmsResource.ResourceState.CLOSED);
            this.setFailureCause(cause);
            this.stop();
            for (JmsMessageConsumer consumer : new ArrayList<JmsMessageConsumer>(this.consumers.values())) {
                consumer.shutdown(cause);
            }
            for (JmsMessageProducer producer : new ArrayList<JmsMessageProducer>(this.producers.values())) {
                producer.shutdown(cause);
            }
            this.transactionContext.shutdown();
            JmsSessionInfo jmsSessionInfo = this.sessionInfo;
            synchronized (jmsSessionInfo) {
                if (cause == null) {
                    cause = new JMSException("Session closed remotely before message transfer result was notified");
                }
                this.getCompletionExecutor().execute(new FailOrCompleteAsyncCompletionsTask(JmsExceptionSupport.create(cause)));
                this.getCompletionExecutor().shutdown();
            }
            try {
                this.getCompletionExecutor().awaitTermination(this.connection.getCloseTimeout(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                LOG.trace("Session close awaiting send completions was interrupted");
            }
        }
    }

    void sessionClosed(Throwable cause) {
        try {
            this.shutdown(cause);
        }
        catch (Throwable error) {
            LOG.trace("Ignoring exception thrown during cleanup of closed session", error);
        }
    }

    JmsMessageConsumer consumerClosed(JmsConsumerInfo resource, Throwable cause) {
        LOG.info("A JMS MessageConsumer has been closed: {}", (Object)resource);
        JmsMessageConsumer consumer = this.consumers.get(resource.getId());
        try {
            if (consumer != null) {
                consumer.shutdown(cause);
            }
        }
        catch (Throwable error) {
            LOG.trace("Ignoring exception thrown during cleanup of closed consumer", error);
        }
        return consumer;
    }

    JmsMessageProducer producerClosed(JmsProducerInfo resource, Throwable cause) {
        LOG.info("A JMS MessageProducer has been closed: {}", (Object)resource);
        JmsMessageProducer producer = this.producers.get(resource.getId());
        try {
            if (producer != null) {
                this.getCompletionExecutor().execute(new FailOrCompleteAsyncCompletionsTask(producer.getProducerId(), JmsExceptionSupport.create(cause)));
                producer.shutdown(cause);
            }
        }
        catch (Throwable error) {
            LOG.trace("Ignoring exception thrown during cleanup of closed producer", error);
        }
        return producer;
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        return this.createConsumer(destination, null);
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector) throws JMSException {
        return this.createConsumer(destination, messageSelector, false);
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) throws JMSException {
        this.checkClosed();
        JmsSession.checkDestination(destination);
        messageSelector = JmsSession.checkSelector(messageSelector);
        JmsDestination dest = JmsMessageTransformation.transformDestination(this.connection, destination);
        JmsMessageConsumer result = new JmsMessageConsumer(this.getNextConsumerId(), this, dest, messageSelector, noLocal);
        result.init();
        return result;
    }

    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        this.checkClosed();
        JmsSession.checkDestination((Destination)queue);
        JmsDestination dest = JmsMessageTransformation.transformDestination(this.connection, (Destination)queue);
        JmsQueueReceiver result = new JmsQueueReceiver(this.getNextConsumerId(), this, dest, null);
        result.init();
        return result;
    }

    public QueueReceiver createReceiver(Queue queue, String messageSelector) throws JMSException {
        this.checkClosed();
        JmsSession.checkDestination((Destination)queue);
        messageSelector = JmsSession.checkSelector(messageSelector);
        JmsDestination dest = JmsMessageTransformation.transformDestination(this.connection, (Destination)queue);
        JmsQueueReceiver result = new JmsQueueReceiver(this.getNextConsumerId(), this, dest, messageSelector);
        result.init();
        return result;
    }

    public QueueBrowser createBrowser(Queue destination) throws JMSException {
        return this.createBrowser(destination, null);
    }

    public QueueBrowser createBrowser(Queue destination, String messageSelector) throws JMSException {
        this.checkClosed();
        JmsSession.checkDestination((Destination)destination);
        messageSelector = JmsSession.checkSelector(messageSelector);
        JmsDestination dest = JmsMessageTransformation.transformDestination(this.connection, (Destination)destination);
        JmsQueueBrowser result = new JmsQueueBrowser(this, dest, messageSelector);
        return result;
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        return this.createSubscriber(topic, null, false);
    }

    public TopicSubscriber createSubscriber(Topic topic, String messageSelector, boolean noLocal) throws JMSException {
        this.checkClosed();
        JmsSession.checkDestination((Destination)topic);
        messageSelector = JmsSession.checkSelector(messageSelector);
        JmsDestination dest = JmsMessageTransformation.transformDestination(this.connection, (Destination)topic);
        JmsTopicSubscriber result = new JmsTopicSubscriber(this.getNextConsumerId(), this, dest, noLocal, messageSelector);
        result.init();
        return result;
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        return this.createDurableSubscriber(topic, name, null, false);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        this.checkClosed();
        JmsSession.checkDestination((Destination)topic);
        this.checkClientIDWasSetExplicitly();
        messageSelector = JmsSession.checkSelector(messageSelector);
        JmsDestination dest = JmsMessageTransformation.transformDestination(this.connection, (Destination)topic);
        JmsDurableTopicSubscriber result = new JmsDurableTopicSubscriber(this.getNextConsumerId(), this, dest, name, noLocal, messageSelector);
        result.init();
        return result;
    }

    public MessageConsumer createDurableConsumer(Topic topic, String name) throws JMSException {
        return this.createDurableSubscriber(topic, name, null, false);
    }

    public MessageConsumer createDurableConsumer(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        return this.createDurableSubscriber(topic, name, messageSelector, noLocal);
    }

    protected void checkClientIDWasSetExplicitly() throws IllegalStateException {
        if (!this.connection.isExplicitClientID()) {
            throw new IllegalStateException("You must specify a unique clientID for the Connection to use a DurableSubscriber");
        }
    }

    public void unsubscribe(String name) throws JMSException {
        this.checkClosed();
        this.connection.unsubscribe(name);
    }

    public MessageConsumer createSharedConsumer(Topic topic, String name) throws JMSException {
        this.checkClosed();
        return this.createSharedConsumer(topic, name, null);
    }

    public MessageConsumer createSharedConsumer(Topic topic, String name, String selector) throws JMSException {
        this.checkClosed();
        JmsSession.checkDestination((Destination)topic);
        selector = JmsSession.checkSelector(selector);
        JmsDestination dest = JmsMessageTransformation.transformDestination(this.connection, (Destination)topic);
        JmsSharedMessageConsumer result = new JmsSharedMessageConsumer(this.getNextConsumerId(), this, dest, name, selector);
        result.init();
        return result;
    }

    public MessageConsumer createSharedDurableConsumer(Topic topic, String name) throws JMSException {
        this.checkClosed();
        return this.createSharedDurableConsumer(topic, name, null);
    }

    public MessageConsumer createSharedDurableConsumer(Topic topic, String name, String selector) throws JMSException {
        this.checkClosed();
        JmsSession.checkDestination((Destination)topic);
        selector = JmsSession.checkSelector(selector);
        JmsDestination dest = JmsMessageTransformation.transformDestination(this.connection, (Destination)topic);
        JmsSharedDurableMessageConsumer result = new JmsSharedDurableMessageConsumer(this.getNextConsumerId(), this, dest, name, selector);
        result.init();
        return result;
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        this.checkClosed();
        JmsDestination dest = JmsMessageTransformation.transformDestination(this.connection, destination);
        JmsMessageProducer result = new JmsMessageProducer(this.getNextProducerId(), this, dest);
        return result;
    }

    public QueueSender createSender(Queue queue) throws JMSException {
        this.checkClosed();
        JmsDestination dest = JmsMessageTransformation.transformDestination(this.connection, (Destination)queue);
        JmsQueueSender result = new JmsQueueSender(this.getNextProducerId(), this, dest);
        return result;
    }

    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        this.checkClosed();
        JmsDestination dest = JmsMessageTransformation.transformDestination(this.connection, (Destination)topic);
        JmsTopicPublisher result = new JmsTopicPublisher(this.getNextProducerId(), this, dest);
        return result;
    }

    public BytesMessage createBytesMessage() throws JMSException {
        this.checkClosed();
        return this.init(this.connection.getMessageFactory().createBytesMessage());
    }

    public MapMessage createMapMessage() throws JMSException {
        this.checkClosed();
        return this.init(this.connection.getMessageFactory().createMapMessage());
    }

    public Message createMessage() throws JMSException {
        this.checkClosed();
        return this.init(this.connection.getMessageFactory().createMessage());
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        this.checkClosed();
        return this.init(this.connection.getMessageFactory().createObjectMessage(null));
    }

    public ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        this.checkClosed();
        return this.init(this.connection.getMessageFactory().createObjectMessage(object));
    }

    public StreamMessage createStreamMessage() throws JMSException {
        this.checkClosed();
        return this.init(this.connection.getMessageFactory().createStreamMessage());
    }

    public TextMessage createTextMessage() throws JMSException {
        this.checkClosed();
        return this.init(this.connection.getMessageFactory().createTextMessage(null));
    }

    public TextMessage createTextMessage(String text) throws JMSException {
        this.checkClosed();
        return this.init(this.connection.getMessageFactory().createTextMessage(text));
    }

    public Queue createQueue(String queueName) throws JMSException {
        this.checkClosed();
        return new JmsQueue(queueName);
    }

    public Topic createTopic(String topicName) throws JMSException {
        this.checkClosed();
        return new JmsTopic(topicName);
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        this.checkClosed();
        return this.connection.createTemporaryQueue();
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        this.checkClosed();
        return this.connection.createTemporaryTopic();
    }

    protected void add(JmsMessageConsumer consumer) throws JMSException {
        this.consumers.put(consumer.getConsumerId(), consumer);
        if (this.started.get()) {
            consumer.start();
        }
    }

    protected void remove(JmsMessageConsumer consumer) throws JMSException {
        this.consumers.remove(consumer.getConsumerId());
    }

    protected JmsMessageConsumer lookup(JmsConsumerId consumerId) {
        return this.consumers.get(consumerId);
    }

    protected void add(JmsMessageProducer producer) {
        this.producers.put(producer.getProducerId(), producer);
    }

    protected void remove(JmsMessageProducer producer) {
        this.producers.remove(producer.getProducerId());
    }

    protected JmsMessageProducer lookup(JmsProducerId producerId) {
        return this.producers.get(producerId);
    }

    protected void onException(Exception ex) {
        this.connection.onException(ex);
    }

    protected void onException(JMSException ex) {
        this.connection.onException(ex);
    }

    protected void send(JmsMessageProducer producer, Destination dest, Message msg, int deliveryMode, int priority, long timeToLive, boolean disableMsgId, boolean disableTimestamp, long deliveryDelay, CompletionListener listener) throws JMSException {
        if (dest == null) {
            throw new InvalidDestinationException("Destination must not be null");
        }
        if (msg == null) {
            throw new MessageFormatException("Message must not be null");
        }
        JmsDestination destination = JmsMessageTransformation.transformDestination(this.connection, dest);
        if (destination.isTemporary() && ((JmsTemporaryDestination)destination).isDeleted()) {
            throw new IllegalStateException("Temporary destination has been deleted");
        }
        this.send(producer, destination, msg, deliveryMode, priority, timeToLive, disableMsgId, disableTimestamp, deliveryDelay, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(JmsMessageProducer producer, JmsDestination destination, Message original, int deliveryMode, int priority, long timeToLive, boolean disableMsgId, boolean disableTimestamp, long deliveryDelay, CompletionListener listener) throws JMSException {
        this.sendLock.lock();
        try {
            original.setJMSDeliveryMode(deliveryMode);
            original.setJMSPriority(priority);
            original.setJMSRedelivered(false);
            original.setJMSDestination((Destination)destination);
            long timeStamp = System.currentTimeMillis();
            boolean hasTTL = timeToLive > 0L;
            boolean hasDelay = deliveryDelay > 0L;
            boolean isJmsMessage = original instanceof JmsMessage;
            if (!disableTimestamp) {
                original.setJMSTimestamp(timeStamp);
            } else {
                original.setJMSTimestamp(0L);
            }
            if (hasTTL) {
                original.setJMSExpiration(timeStamp + timeToLive);
            } else {
                original.setJMSExpiration(0L);
            }
            long messageSequence = producer.getNextMessageSequence();
            Object messageId = null;
            if (!disableMsgId) {
                messageId = producer.getMessageIDBuilder().createMessageID(producer.getProducerId().toString(), messageSequence);
            }
            JmsMessage outbound = null;
            if (isJmsMessage) {
                outbound = (JmsMessage)original;
            } else {
                outbound = JmsMessageTransformation.transformMessage(this.connection, original);
                outbound.setJMSDestination(destination);
            }
            long deliveryTime = timeStamp;
            if (hasDelay) {
                deliveryTime = timeStamp + deliveryDelay;
            }
            outbound.getFacade().setDeliveryTime(deliveryTime, hasDelay);
            if (!isJmsMessage) {
                this.setForeignMessageDeliveryTime(original, deliveryTime);
            }
            outbound.getFacade().setProviderMessageIdObject(messageId);
            if (!isJmsMessage) {
                original.setJMSMessageID(outbound.getJMSMessageID());
            }
            if (this.connection.isPopulateJMSXUserID()) {
                outbound.getFacade().setUserIdBytes(this.connection.getEncodedUsername());
            } else {
                outbound.getFacade().setUserId(null);
            }
            boolean sync = this.connection.isForceSyncSend() || !this.connection.isForceAsyncSend() && deliveryMode == 2 && !this.getTransacted();
            outbound.onSend(timeToLive);
            JmsOutboundMessageDispatch envelope = new JmsOutboundMessageDispatch();
            envelope.setMessage(outbound);
            envelope.setPayload(outbound.getFacade().encodeMessage());
            envelope.setProducerId(producer.getProducerId());
            envelope.setDestination(destination);
            envelope.setSendAsync(listener == null ? !sync : true);
            envelope.setDispatchId(messageSequence);
            envelope.setCompletionRequired(listener != null);
            if (producer.isAnonymous()) {
                envelope.setPresettle(this.getPresettlePolicy().isProducerPresttled(this, destination));
            } else {
                envelope.setPresettle(producer.isPresettled());
            }
            if (envelope.isSendAsync() && !envelope.isCompletionRequired() && !envelope.isPresettle()) {
                envelope.setMessage(outbound.copy());
                outbound.onSendComplete();
            }
            SendCompletion completion = null;
            if (envelope.isCompletionRequired()) {
                completion = new SendCompletion(envelope, listener);
                this.asyncSendQueue.addLast(completion);
            }
            try {
                this.transactionContext.send(this.connection, envelope);
            }
            catch (JMSException jmsEx) {
                if (completion != null) {
                    this.asyncSendQueue.remove(completion);
                    if (completion.hasCompleted()) {
                        this.sendLock.unlock();
                        return;
                    }
                }
                throw jmsEx;
            }
        }
        finally {
            this.sendLock.unlock();
        }
    }

    private void setForeignMessageDeliveryTime(Message foreignMessage, long deliveryTime) throws JMSException {
        Method deliveryTimeMethod = null;
        try {
            Class<?> clazz = foreignMessage.getClass();
            Method method = clazz.getMethod("setJMSDeliveryTime", Long.TYPE);
            if (!Modifier.isAbstract(method.getModifiers())) {
                deliveryTimeMethod = method;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (deliveryTimeMethod != null) {
            foreignMessage.setJMSDeliveryTime(deliveryTime);
        }
    }

    void acknowledge(JmsInboundMessageDispatch envelope, ProviderConstants.ACK_TYPE ackType) throws JMSException {
        this.transactionContext.acknowledge(this.connection, envelope, ackType);
    }

    void acknowledge(ProviderConstants.ACK_TYPE ackType) throws JMSException {
        if (this.isTransacted()) {
            throw new IllegalStateException("Session acknowledge called inside a transacted Session");
        }
        this.connection.acknowledge(this.sessionInfo.getId(), ackType);
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public boolean isTransacted() {
        return this.acknowledgementMode == 0;
    }

    public boolean isClientAcknowledge() {
        return this.acknowledgementMode == 2;
    }

    public boolean isAutoAcknowledge() {
        return this.acknowledgementMode == 1;
    }

    public boolean isDupsOkAcknowledge() {
        return this.acknowledgementMode == 3;
    }

    protected void checkClosed() throws IllegalStateException {
        if (this.closed.get()) {
            IllegalStateException jmsEx = null;
            if (this.failureCause.get() == null) {
                jmsEx = new IllegalStateException("The Session is closed");
            } else {
                jmsEx = new IllegalStateException("The Session was closed due to an unrecoverable error.");
                jmsEx.initCause(this.failureCause.get());
            }
            throw jmsEx;
        }
    }

    static String checkSelector(String selector) throws InvalidSelectorException {
        if (selector != null) {
            if (selector.trim().length() == 0) {
                return null;
            }
            try {
                SelectorParser.parse(selector);
            }
            catch (FilterException e) {
                throw new InvalidSelectorException(e.getMessage());
            }
        }
        return selector;
    }

    public static void checkDestination(Destination dest) throws InvalidDestinationException {
        if (dest == null) {
            throw new InvalidDestinationException("Destination cannot be null");
        }
    }

    protected void start() throws JMSException {
        if (this.started.compareAndSet(false, true)) {
            for (JmsMessageConsumer consumer : this.consumers.values()) {
                consumer.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stop() throws JMSException {
        this.started.set(false);
        for (JmsMessageConsumer consumer : this.consumers.values()) {
            consumer.stop();
        }
        JmsSessionInfo jmsSessionInfo = this.sessionInfo;
        synchronized (jmsSessionInfo) {
            if (this.deliveryExecutor != null) {
                this.deliveryExecutor.shutdown();
                this.deliveryExecutor = null;
            }
        }
    }

    protected boolean isStarted() {
        return this.started.get();
    }

    public JmsConnection getConnection() {
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Executor getDispatcherExecutor() {
        ThreadPoolExecutor exec = this.deliveryExecutor;
        if (exec != null) return exec;
        JmsSessionInfo jmsSessionInfo = this.sessionInfo;
        synchronized (jmsSessionInfo) {
            if (this.deliveryExecutor != null) return this.deliveryExecutor;
            if (this.closed.get()) return NoOpExecutor.INSTANCE;
            this.deliveryExecutor = exec = this.createExecutor("delivery dispatcher", this.deliveryThread);
            return exec;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecutorService getCompletionExecutor() {
        ThreadPoolExecutor exec = this.completionExcecutor;
        if (exec == null) {
            JmsSessionInfo jmsSessionInfo = this.sessionInfo;
            synchronized (jmsSessionInfo) {
                exec = this.completionExcecutor;
                if (exec == null) {
                    exec = this.createExecutor("completion dispatcher", this.completionThread);
                    Future<?> starter = exec.submit(() -> {});
                    try {
                        starter.get();
                    }
                    catch (InterruptedException | ExecutionException e) {
                        LOG.trace("Completion Executor starter task failed: {}", (Object)e.getMessage());
                    }
                    this.completionExcecutor = exec;
                }
            }
        }
        return exec;
    }

    private ThreadPoolExecutor createExecutor(String threadNameSuffix, AtomicReference<Thread> threadTracker) {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 1, 5L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new QpidJMSThreadFactory("JmsSession [" + this.sessionInfo.getId() + "] " + threadNameSuffix, true, threadTracker));
        executor.setRejectedExecutionHandler(new ThreadPoolExecutor.DiscardOldestPolicy(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
                if (!JmsSession.this.closed.get()) {
                    LOG.trace("Task {} rejected from executor: {}", (Object)r, (Object)e);
                    super.rejectedExecution(r, e);
                }
            }
        });
        return executor;
    }

    protected JmsSessionInfo getSessionInfo() {
        return this.sessionInfo;
    }

    protected JmsSessionId getSessionId() {
        return this.sessionInfo.getId();
    }

    protected int getSessionMode() {
        return this.acknowledgementMode;
    }

    protected JmsConsumerId getNextConsumerId() {
        return new JmsConsumerId(this.sessionInfo.getId(), this.consumerIdGenerator.incrementAndGet());
    }

    protected JmsProducerId getNextProducerId() {
        return new JmsProducerId(this.sessionInfo.getId(), this.producerIdGenerator.incrementAndGet());
    }

    void setFailureCause(Throwable failureCause) {
        this.failureCause.set(failureCause);
    }

    Throwable getFailureCause() {
        return this.failureCause.get();
    }

    private <T extends JmsMessage> T init(T message) {
        message.setConnection(this.connection);
        message.setValidatePropertyNames(this.connection.isValidatePropertyNames());
        return message;
    }

    boolean isDestinationInUse(JmsDestination destination) {
        for (JmsMessageConsumer consumer : this.consumers.values()) {
            if (!consumer.isUsingDestination(destination)) continue;
            return true;
        }
        return false;
    }

    void checkMessageListener() throws JMSException {
        if (this.messageListener != null) {
            throw new IllegalStateException("Cannot synchronously receive a message when a MessageListener is set");
        }
        for (JmsMessageConsumer consumer : this.consumers.values()) {
            if (!consumer.hasMessageListener()) continue;
            throw new IllegalStateException("Cannot synchronously receive a message when a MessageListener is set");
        }
    }

    void checkIsDeliveryThread() throws JMSException {
        if (Thread.currentThread().equals(this.deliveryThread.get())) {
            throw new IllegalStateException("Illegal invocation from MessageListener callback");
        }
    }

    void checkIsCompletionThread() throws JMSException {
        if (Thread.currentThread().equals(this.completionThread.get())) {
            throw new IllegalStateException("Illegal invocation from CompletionListener callback");
        }
    }

    public JmsMessageIDPolicy getMessageIDPolicy() {
        return this.sessionInfo.getMessageIDPolicy();
    }

    public JmsPrefetchPolicy getPrefetchPolicy() {
        return this.sessionInfo.getPrefetchPolicy();
    }

    public JmsPresettlePolicy getPresettlePolicy() {
        return this.sessionInfo.getPresettlePolicy();
    }

    public JmsRedeliveryPolicy getRedeliveryPolicy() {
        return this.sessionInfo.getRedeliveryPolicy();
    }

    public JmsDeserializationPolicy getDeserializationPolicy() {
        return this.sessionInfo.getDeserializationPolicy();
    }

    public void setTransactionContext(JmsTransactionContext transactionContext) {
        this.transactionContext = transactionContext;
    }

    public JmsTransactionContext getTransactionContext() {
        return this.transactionContext;
    }

    boolean isSessionRecovered() {
        return this.sessionRecovered;
    }

    void clearSessionRecovered() {
        this.sessionRecovered = false;
    }

    @Override
    public void onInboundMessage(JmsInboundMessageDispatch envelope) {
        this.deliver(envelope);
    }

    protected void onCompletedMessageSend(JmsOutboundMessageDispatch envelope) {
        this.getCompletionExecutor().execute(new AsyncCompletionTask(envelope));
    }

    protected void onFailedMessageSend(JmsOutboundMessageDispatch envelope, Throwable cause) {
        this.getCompletionExecutor().execute(new AsyncCompletionTask(envelope, cause));
    }

    protected void onConnectionInterrupted() {
        this.transactionContext.onConnectionInterrupted();
        JMSException failureCause = new JMSException("Send failed due to connection loss");
        this.getCompletionExecutor().execute(new FailOrCompleteAsyncCompletionsTask(failureCause));
        for (JmsMessageProducer producer : this.producers.values()) {
            producer.onConnectionInterrupted();
        }
        for (JmsMessageConsumer consumer : this.consumers.values()) {
            consumer.onConnectionInterrupted();
        }
    }

    protected void onConnectionRecovery(Provider provider) throws Exception {
        if (this.sessionInfo.isOpen()) {
            ProviderFuture request = new ProviderFuture();
            provider.create(this.sessionInfo, request);
            request.sync();
            this.transactionContext.onConnectionRecovery(provider);
            for (JmsMessageProducer producer : this.producers.values()) {
                producer.onConnectionRecovery(provider);
            }
            for (JmsMessageConsumer consumer : this.consumers.values()) {
                consumer.onConnectionRecovery(provider);
            }
        }
    }

    protected void onConnectionRecovered(Provider provider) throws Exception {
        for (JmsMessageProducer producer : this.producers.values()) {
            producer.onConnectionRecovered(provider);
        }
        for (JmsMessageConsumer consumer : this.consumers.values()) {
            consumer.onConnectionRecovered(provider);
        }
    }

    protected void onConnectionRestored() {
        for (JmsMessageProducer producer : this.producers.values()) {
            producer.onConnectionRestored();
        }
        for (JmsMessageConsumer consumer : this.consumers.values()) {
            consumer.onConnectionRestored();
        }
    }

    private void deliver(JmsInboundMessageDispatch envelope) {
        JmsConsumerId id = envelope.getConsumerId();
        if (id == null) {
            this.connection.onException(new JMSException("No ConsumerId set for " + envelope.getMessage()));
        }
        if (this.messageListener != null) {
            this.messageListener.onMessage((Message)envelope.getMessage());
        } else {
            JmsMessageConsumer consumer = this.consumers.get(id);
            if (consumer != null) {
                consumer.onInboundMessage(envelope);
            }
        }
    }

    private final class SendCompletion {
        private final JmsOutboundMessageDispatch envelope;
        private final CompletionListener listener;
        private Exception failureCause;
        private boolean completed;

        public SendCompletion(JmsOutboundMessageDispatch envelope, CompletionListener listener) {
            this.envelope = envelope;
            this.listener = listener;
        }

        public void markAsComplete() {
            this.completed = true;
        }

        public void markAsFailed(Exception cause) {
            this.completed = true;
            this.failureCause = cause;
        }

        public boolean hasCompleted() {
            return this.completed;
        }

        public void signalCompletion() {
            if (this.failureCause == null) {
                this.listener.onCompletion((Message)this.envelope.getMessage());
            } else {
                this.listener.onException((Message)this.envelope.getMessage(), this.failureCause);
            }
        }

        public JmsOutboundMessageDispatch getEnvelope() {
            return this.envelope;
        }
    }

    private final class AsyncCompletionTask
    implements Runnable {
        private final JmsOutboundMessageDispatch envelope;
        private final Throwable cause;

        public AsyncCompletionTask(JmsOutboundMessageDispatch envelope) {
            this(envelope, null);
        }

        public AsyncCompletionTask(JmsOutboundMessageDispatch envelope, Throwable cause) {
            this.envelope = envelope;
            this.cause = cause;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block15: {
                try {
                    SendCompletion completion2 = (SendCompletion)JmsSession.this.asyncSendQueue.peek();
                    if (completion2.getEnvelope().getDispatchId() == this.envelope.getDispatchId()) {
                        try {
                            completion2 = (SendCompletion)JmsSession.this.asyncSendQueue.remove();
                            if (this.cause == null) {
                                completion2.markAsComplete();
                            } else {
                                completion2.markAsFailed((Exception)((Object)JmsExceptionSupport.create(this.cause)));
                            }
                            completion2.signalCompletion();
                        }
                        catch (Throwable error) {
                            LOG.trace("Failed while performing send completion: {}", (Object)this.envelope);
                        }
                        Iterator pending = JmsSession.this.asyncSendQueue.iterator();
                        while (pending.hasNext() && (completion2 = (SendCompletion)pending.next()).hasCompleted()) {
                            try {
                                completion2.signalCompletion();
                            }
                            catch (Throwable error) {
                                LOG.trace("Failed while performing send completion: {}", (Object)this.envelope);
                            }
                            finally {
                                pending.remove();
                            }
                        }
                        break block15;
                    }
                    for (SendCompletion completion2 : JmsSession.this.asyncSendQueue) {
                        if (completion2.getEnvelope().getDispatchId() != this.envelope.getDispatchId()) continue;
                        if (this.cause == null) {
                            completion2.markAsComplete();
                            continue;
                        }
                        completion2.markAsFailed((Exception)((Object)JmsExceptionSupport.create(this.cause)));
                    }
                }
                catch (Exception ex) {
                    LOG.debug("Send completion task encounted unexpected error: {}", (Object)ex.getMessage());
                }
            }
        }
    }

    private final class FailOrCompleteAsyncCompletionsTask
    implements Runnable {
        private final JMSException failureCause;
        private final JmsProducerId producerId;

        public FailOrCompleteAsyncCompletionsTask(JMSException failureCause) {
            this(null, failureCause);
        }

        public FailOrCompleteAsyncCompletionsTask(JmsProducerId producerId, JMSException failureCause) {
            this.failureCause = failureCause;
            this.producerId = producerId;
        }

        @Override
        public void run() {
            for (SendCompletion completion : JmsSession.this.asyncSendQueue) {
                if (!completion.hasCompleted() && (this.producerId == null || this.producerId.equals(completion.envelope.getProducerId()))) {
                    completion.markAsFailed((Exception)((Object)this.failureCause));
                }
                try {
                    completion.signalCompletion();
                }
                catch (Throwable error) {
                    LOG.trace("Signaled completion of send: {}", (Object)completion.envelope);
                }
            }
            JmsSession.this.asyncSendQueue.clear();
        }
    }
}

