/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp;

import java.util.function.Function;
import javax.jms.JMSSecurityException;
import org.apache.qpid.jms.sasl.Mechanism;
import org.apache.qpid.proton.engine.Sasl;

public class AmqpSaslAuthenticator {
    private final Sasl sasl;
    private final Function<String[], Mechanism> mechanismFinder;
    private Mechanism mechanism;
    private boolean complete;
    private JMSSecurityException failureCause;

    public AmqpSaslAuthenticator(Sasl sasl, Function<String[], Mechanism> mechanismFinder) {
        this.sasl = sasl;
        this.mechanismFinder = mechanismFinder;
    }

    public void tryAuthenticate() {
        try {
            switch (this.sasl.getState()) {
                case PN_SASL_IDLE: {
                    this.handleSaslInit();
                    break;
                }
                case PN_SASL_STEP: {
                    this.handleSaslStep();
                    break;
                }
                case PN_SASL_FAIL: {
                    this.handleSaslFail();
                    break;
                }
                case PN_SASL_PASS: {
                    this.handleSaslCompletion();
                    break;
                }
            }
        }
        catch (Throwable error) {
            this.recordFailure(error.getMessage(), error);
        }
    }

    public boolean isComplete() {
        return this.complete;
    }

    public JMSSecurityException getFailureCause() {
        return this.failureCause;
    }

    public boolean wasSuccessful() throws IllegalStateException {
        if (this.complete) {
            return this.failureCause == null;
        }
        throw new IllegalStateException("Authentication has not completed yet.");
    }

    private void handleSaslInit() {
        try {
            String[] remoteMechanisms = this.sasl.getRemoteMechanisms();
            if (remoteMechanisms != null && remoteMechanisms.length != 0) {
                this.mechanism = this.mechanismFinder.apply(remoteMechanisms);
                if (this.mechanism != null) {
                    byte[] response = this.mechanism.getInitialResponse();
                    if (response != null) {
                        this.sasl.send(response, 0, response.length);
                    }
                    this.sasl.setMechanisms(new String[]{this.mechanism.getName()});
                } else {
                    this.recordFailure("Could not find a suitable SASL mechanism for the remote peer using the available credentials.", null);
                }
            }
        }
        catch (Throwable error) {
            this.recordFailure("Exception while processing SASL init: " + error.getMessage(), error);
        }
    }

    private void handleSaslStep() {
        try {
            if (this.sasl.pending() != 0) {
                byte[] challenge = new byte[this.sasl.pending()];
                this.sasl.recv(challenge, 0, challenge.length);
                byte[] response = this.mechanism.getChallengeResponse(challenge);
                if (response != null) {
                    this.sasl.send(response, 0, response.length);
                }
            }
        }
        catch (Throwable error) {
            this.recordFailure("Exception while processing SASL step: " + error.getMessage(), error);
        }
    }

    private void handleSaslFail() {
        if (this.mechanism != null) {
            this.recordFailure("Client failed to authenticate using SASL: " + this.mechanism.getName(), null);
        } else {
            this.recordFailure("Client failed to authenticate", null);
        }
    }

    private void handleSaslCompletion() {
        try {
            if (this.sasl.pending() != 0) {
                byte[] additionalData = new byte[this.sasl.pending()];
                this.sasl.recv(additionalData, 0, additionalData.length);
                this.mechanism.getChallengeResponse(additionalData);
            }
            this.mechanism.verifyCompletion();
            this.complete = true;
        }
        catch (Throwable error) {
            this.recordFailure("Exception while processing SASL exchange completion: " + error.getMessage(), error);
        }
    }

    private void recordFailure(String message, Throwable cause) {
        this.failureCause = new JMSSecurityException(message);
        if (cause instanceof Exception) {
            this.failureCause.setLinkedException((Exception)cause);
        }
        this.failureCause.initCause(cause);
        this.complete = true;
    }
}

