/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms;

import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import org.apache.qpid.jms.JmsSession;
import org.apache.qpid.jms.message.JmsMessageSupport;

public final class JmsAcknowledgeCallback {
    private final JmsSession session;
    private int ackType;

    public JmsAcknowledgeCallback(JmsSession session) {
        this.session = session;
    }

    public void acknowledge() throws JMSException {
        if (this.session.isClosed()) {
            throw new IllegalStateException("Session closed.");
        }
        this.session.acknowledge(JmsMessageSupport.lookupAckTypeForDisposition(this.getAckType()));
    }

    public boolean isAckTypeSet() {
        return this.ackType > 0;
    }

    public void clearAckType() {
        this.ackType = 0;
    }

    public int getAckType() {
        return this.ackType <= 0 ? 1 : this.ackType;
    }

    public void setAckType(int ackType) {
        this.ackType = ackType;
    }
}

