/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms;

import javax.jms.JMSException;
import org.apache.qpid.jms.JmsConnection;
import org.apache.qpid.jms.JmsDestination;
import org.apache.qpid.jms.meta.JmsAbstractResourceId;
import org.apache.qpid.jms.meta.JmsResource;
import org.apache.qpid.jms.meta.JmsResourceId;
import org.apache.qpid.jms.meta.JmsResourceVistor;

public abstract class JmsTemporaryDestination
extends JmsDestination
implements JmsResource {
    private boolean deleted;
    private JmsTemporaryDestinationId resourceId;
    private JmsResource.ResourceState state = JmsResource.ResourceState.INITIALIZED;

    public JmsTemporaryDestination() {
        this(null, false);
    }

    public JmsTemporaryDestination(String name, boolean topic) {
        super(name, topic, true);
    }

    @Override
    public JmsResourceId getId() {
        if (this.resourceId == null) {
            this.resourceId = new JmsTemporaryDestinationId();
        }
        return this.resourceId;
    }

    @Override
    public JmsResource.ResourceState getState() {
        return this.state;
    }

    @Override
    public void setState(JmsResource.ResourceState state) {
        this.state = state;
    }

    void setConnection(JmsConnection connection) {
        this.connection = connection;
    }

    JmsConnection getConnection() {
        return this.connection;
    }

    protected void tryDelete() throws JMSException {
        if (this.connection != null) {
            this.connection.deleteTemporaryDestination(this);
        }
        this.deleted = true;
    }

    protected boolean isDeleted() throws JMSException {
        boolean result = this.deleted;
        if (!result && this.connection != null) {
            result = this.connection.isTemporaryDestinationDeleted(this);
        }
        return result;
    }

    @Override
    public void visit(JmsResourceVistor visitor) throws Exception {
        visitor.processDestination(this);
    }

    private class JmsTemporaryDestinationId
    extends JmsAbstractResourceId
    implements Comparable<JmsTemporaryDestinationId> {
        private JmsTemporaryDestinationId() {
        }

        public String getDestinationName() {
            return JmsTemporaryDestination.this.getName();
        }

        @Override
        public int compareTo(JmsTemporaryDestinationId otherId) {
            return this.getDestinationName().compareTo(otherId.getDestinationName());
        }
    }
}

