/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jms.ConnectionMetaData;

public final class JmsConnectionMetaData
implements ConnectionMetaData {
    public static final String PROVIDER_VERSION;
    public static final int PROVIDER_MAJOR_VERSION;
    public static final int PROVIDER_MINOR_VERSION;
    public static final JmsConnectionMetaData INSTANCE;

    private JmsConnectionMetaData() {
    }

    public String getJMSVersion() {
        return "1.1";
    }

    public int getJMSMajorVersion() {
        return 1;
    }

    public int getJMSMinorVersion() {
        return 1;
    }

    public String getJMSProviderName() {
        return "QpidJMS";
    }

    public String getProviderVersion() {
        return PROVIDER_VERSION;
    }

    public int getProviderMajorVersion() {
        return PROVIDER_MAJOR_VERSION;
    }

    public int getProviderMinorVersion() {
        return PROVIDER_MINOR_VERSION;
    }

    public Enumeration<String> getJMSXPropertyNames() {
        Vector<String> jmxProperties = new Vector<String>();
        jmxProperties.add("JMSXUserID");
        jmxProperties.add("JMSXGroupID");
        jmxProperties.add("JMSXGroupSeq");
        jmxProperties.add("JMSXDeliveryCount");
        return jmxProperties.elements();
    }

    static {
        int minor;
        int major;
        String version;
        block7: {
            INSTANCE = new JmsConnectionMetaData();
            version = null;
            major = 0;
            minor = 0;
            try {
                Package p = Package.getPackage(JmsConnectionMetaData.class.getPackage().getName());
                if (p != null) {
                    version = p.getImplementationVersion();
                    Pattern pattern = Pattern.compile("(\\d+)\\.(\\d+).*");
                    Matcher m = pattern.matcher(version);
                    if (m.matches()) {
                        major = Integer.parseInt(m.group(1));
                        minor = Integer.parseInt(m.group(2));
                    }
                }
            }
            catch (Throwable e) {
                InputStream in = null;
                String path = JmsConnectionMetaData.class.getPackage().getName().replace(".", "/");
                in = JmsConnectionMetaData.class.getResourceAsStream("/" + path + "/version.txt");
                if (in == null) break block7;
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(in, Charset.forName("US-ASCII")));
                    version = reader.readLine();
                    Pattern pattern = Pattern.compile("(\\d+)\\.(\\d+).*");
                    Matcher m = pattern.matcher(version);
                    if (m.matches()) {
                        major = Integer.parseInt(m.group(1));
                        minor = Integer.parseInt(m.group(2));
                    }
                    reader.close();
                }
                catch (Throwable err) {
                    // empty catch block
                }
            }
        }
        PROVIDER_VERSION = version;
        PROVIDER_MAJOR_VERSION = major;
        PROVIDER_MINOR_VERSION = minor;
    }
}

