/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import org.apache.qpid.jms.JmsConnection;
import org.apache.qpid.jms.JmsDestination;
import org.apache.qpid.jms.JmsSession;
import org.apache.qpid.jms.meta.JmsProducerId;
import org.apache.qpid.jms.meta.JmsProducerInfo;
import org.apache.qpid.jms.provider.Provider;
import org.apache.qpid.jms.provider.ProviderFuture;

public class JmsMessageProducer
implements MessageProducer {
    protected final JmsSession session;
    protected final JmsConnection connection;
    protected JmsProducerInfo producerInfo;
    protected final boolean flexibleDestination;
    protected int deliveryMode = 2;
    protected int priority = 4;
    protected long timeToLive = 0L;
    protected final AtomicBoolean closed = new AtomicBoolean();
    protected boolean disableMessageId;
    protected boolean disableTimestamp;
    protected final AtomicLong messageSequence = new AtomicLong();
    protected Exception failureCause;

    protected JmsMessageProducer(JmsProducerId producerId, JmsSession session, JmsDestination destination) throws JMSException {
        this.session = session;
        this.connection = session.getConnection();
        this.flexibleDestination = destination == null;
        this.producerInfo = new JmsProducerInfo(producerId);
        this.producerInfo.setDestination(destination);
        session.getConnection().createResource(this.producerInfo);
    }

    public void close() throws JMSException {
        if (!this.closed.get()) {
            this.doClose();
        }
    }

    protected void doClose() throws JMSException {
        this.shutdown();
        this.connection.destroyResource(this.producerInfo);
    }

    protected void shutdown() throws JMSException {
        this.shutdown(null);
    }

    protected void shutdown(Exception cause) throws JMSException {
        if (this.closed.compareAndSet(false, true)) {
            this.failureCause = cause;
            this.session.remove(this);
        }
    }

    public int getDeliveryMode() throws JMSException {
        this.checkClosed();
        return this.deliveryMode;
    }

    public Destination getDestination() throws JMSException {
        this.checkClosed();
        return this.producerInfo.getDestination();
    }

    public boolean getDisableMessageID() throws JMSException {
        this.checkClosed();
        return this.disableMessageId;
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        this.checkClosed();
        return this.disableTimestamp;
    }

    public int getPriority() throws JMSException {
        this.checkClosed();
        return this.priority;
    }

    public long getTimeToLive() throws JMSException {
        this.checkClosed();
        return this.timeToLive;
    }

    public void send(Message message) throws JMSException {
        this.send(message, this.deliveryMode, this.priority, this.timeToLive);
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.checkClosed();
        if (this.flexibleDestination) {
            throw new UnsupportedOperationException("Using this method is not supported on producers created without an explicit Destination");
        }
        this.sendMessage(this.producerInfo.getDestination(), message, deliveryMode, priority, timeToLive);
    }

    public void send(Destination destination, Message message) throws JMSException {
        this.send(destination, message, this.deliveryMode, this.priority, this.timeToLive);
    }

    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.checkClosed();
        if (!this.flexibleDestination) {
            throw new UnsupportedOperationException("Using this method is not supported on producers created with an explicit Destination.");
        }
        this.sendMessage(destination, message, deliveryMode, priority, timeToLive);
    }

    private void sendMessage(Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (destination == null) {
            throw new InvalidDestinationException("Don't understand null destinations");
        }
        this.session.send(this, destination, message, deliveryMode, priority, timeToLive, this.disableMessageId, this.disableTimestamp);
    }

    public void setDeliveryMode(int deliveryMode) throws JMSException {
        this.checkClosed();
        this.deliveryMode = deliveryMode;
    }

    public void setDisableMessageID(boolean value) throws JMSException {
        this.checkClosed();
        this.disableMessageId = value;
    }

    public void setDisableMessageTimestamp(boolean value) throws JMSException {
        this.checkClosed();
        this.disableTimestamp = value;
    }

    public void setPriority(int defaultPriority) throws JMSException {
        this.checkClosed();
        this.priority = defaultPriority;
    }

    public void setTimeToLive(long timeToLive) throws JMSException {
        this.checkClosed();
        this.timeToLive = timeToLive;
    }

    protected JmsProducerId getProducerId() {
        return this.producerInfo.getProducerId();
    }

    protected long getNextMessageSequence() {
        return this.messageSequence.incrementAndGet();
    }

    protected void checkClosed() throws IllegalStateException {
        if (this.closed.get()) {
            IllegalStateException jmsEx = null;
            if (this.failureCause == null) {
                jmsEx = new IllegalStateException("The MessageProducer is closed");
            } else {
                jmsEx = new IllegalStateException("The MessageProducer was closed due to an unrecoverable error.");
                jmsEx.initCause((Throwable)this.failureCause);
            }
            throw jmsEx;
        }
    }

    protected void onConnectionInterrupted() {
    }

    protected void onConnectionRecovery(Provider provider) throws Exception {
        ProviderFuture request = new ProviderFuture();
        provider.create(this.producerInfo, request);
        request.sync();
    }

    protected void onConnectionRecovered(Provider provider) throws Exception {
    }

    protected void onConnectionRestored() {
    }
}

