/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.message;

import java.util.Enumeration;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.MessageFormatException;
import org.apache.qpid.jms.message.JmsMessage;
import org.apache.qpid.jms.message.facade.JmsMapMessageFacade;

public class JmsMapMessage
extends JmsMessage
implements MapMessage {
    JmsMapMessageFacade facade;

    public JmsMapMessage(JmsMapMessageFacade facade) {
        super(facade);
        this.facade = facade;
    }

    @Override
    public JmsMapMessage copy() throws JMSException {
        JmsMapMessage other = new JmsMapMessage(this.facade.copy());
        other.copy(this);
        return other;
    }

    @Override
    public void clearBody() throws JMSException {
        super.clearBody();
        this.facade.clearBody();
    }

    public boolean getBoolean(String name) throws JMSException {
        Object value = this.getObject(name);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String || value == null) {
            return Boolean.valueOf((String)value);
        }
        throw new MessageFormatException("Cannot read a boolean from " + value.getClass().getSimpleName());
    }

    public byte getByte(String name) throws JMSException {
        Object value = this.getObject(name);
        if (value instanceof Byte) {
            return (Byte)value;
        }
        if (value instanceof String || value == null) {
            return Byte.valueOf((String)value);
        }
        throw new MessageFormatException("Cannot read a byte from " + value.getClass().getSimpleName());
    }

    public short getShort(String name) throws JMSException {
        Object value = this.getObject(name);
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof Byte) {
            return ((Byte)value).shortValue();
        }
        if (value instanceof String || value == null) {
            return Short.valueOf((String)value);
        }
        throw new MessageFormatException("Cannot read a short from " + value.getClass().getSimpleName());
    }

    public char getChar(String name) throws JMSException {
        Object value = this.getObject(name);
        if (value == null) {
            throw new NullPointerException();
        }
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        throw new MessageFormatException("Cannot read a char from " + value.getClass().getSimpleName());
    }

    public int getInt(String name) throws JMSException {
        Object value = this.getObject(name);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Short) {
            return ((Short)value).intValue();
        }
        if (value instanceof Byte) {
            return ((Byte)value).intValue();
        }
        if (value instanceof String || value == null) {
            return Integer.valueOf((String)value);
        }
        throw new MessageFormatException("Cannot read an int from " + value.getClass().getSimpleName());
    }

    public long getLong(String name) throws JMSException {
        Object value = this.getObject(name);
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Integer) {
            return ((Integer)value).longValue();
        }
        if (value instanceof Short) {
            return ((Short)value).longValue();
        }
        if (value instanceof Byte) {
            return ((Byte)value).longValue();
        }
        if (value instanceof String || value == null) {
            return Long.valueOf((String)value);
        }
        throw new MessageFormatException("Cannot read a long from " + value.getClass().getSimpleName());
    }

    public float getFloat(String name) throws JMSException {
        Object value = this.getObject(name);
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        if (value instanceof String || value == null) {
            return Float.valueOf((String)value).floatValue();
        }
        throw new MessageFormatException("Cannot read a float from " + value.getClass().getSimpleName());
    }

    public double getDouble(String name) throws JMSException {
        Object value = this.getObject(name);
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        if (value instanceof String || value == null) {
            return Double.valueOf((String)value);
        }
        throw new MessageFormatException("Cannot read a double from " + value.getClass().getSimpleName());
    }

    public String getString(String name) throws JMSException {
        Object value = this.getObject(name);
        if (value == null) {
            return null;
        }
        if (value instanceof byte[]) {
            throw new MessageFormatException("Use getBytes to read a byte array");
        }
        return value.toString();
    }

    public byte[] getBytes(String name) throws JMSException {
        Object value = this.getObject(name);
        if (value == null) {
            return null;
        }
        if (value instanceof byte[]) {
            byte[] original = (byte[])value;
            byte[] clone = new byte[original.length];
            System.arraycopy(original, 0, clone, 0, original.length);
            return clone;
        }
        throw new MessageFormatException("Cannot read a byte[] from " + value.getClass().getSimpleName());
    }

    public Object getObject(String name) throws JMSException {
        this.checkKeyNameIsValid(name);
        return this.facade.get(name);
    }

    public Enumeration<String> getMapNames() throws JMSException {
        return this.facade.getMapNames();
    }

    public void setBoolean(String name, boolean value) throws JMSException {
        this.put(name, value ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setByte(String name, byte value) throws JMSException {
        this.put(name, value);
    }

    public void setShort(String name, short value) throws JMSException {
        this.put(name, value);
    }

    public void setChar(String name, char value) throws JMSException {
        this.put(name, Character.valueOf(value));
    }

    public void setInt(String name, int value) throws JMSException {
        this.put(name, value);
    }

    public void setLong(String name, long value) throws JMSException {
        this.put(name, value);
    }

    public void setFloat(String name, float value) throws JMSException {
        this.checkReadOnlyBody();
        this.put(name, new Float(value));
    }

    public void setDouble(String name, double value) throws JMSException {
        this.put(name, new Double(value));
    }

    public void setString(String name, String value) throws JMSException {
        this.put(name, value);
    }

    public void setBytes(String name, byte[] value) throws JMSException {
        this.setBytes(name, value, 0, value != null ? value.length : 0);
    }

    public void setBytes(String name, byte[] value, int offset, int length) throws JMSException {
        this.checkReadOnlyBody();
        this.checkKeyNameIsValid(name);
        byte[] clone = null;
        if (value != null) {
            clone = new byte[length];
            System.arraycopy(value, offset, clone, 0, length);
        }
        this.put(name, clone);
    }

    public void setObject(String name, Object value) throws JMSException {
        if (!(value instanceof byte[])) {
            this.checkValidObject(value);
        }
        this.put(name, value);
    }

    public boolean itemExists(String name) throws JMSException {
        return this.facade.itemExists(name);
    }

    @Override
    public String toString() {
        return "JmsMapMessage { " + this.facade + " }";
    }

    private void put(String name, Object value) throws JMSException {
        this.checkReadOnlyBody();
        this.checkKeyNameIsValid(name);
        this.facade.put(name, value);
    }

    private void checkKeyNameIsValid(String name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("Map key name must not be null");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("Map key name must not be the empty string");
        }
    }
}

