/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.meta;

import org.apache.qpid.jms.meta.JmsConnectionId;
import org.apache.qpid.jms.meta.JmsResource;
import org.apache.qpid.jms.meta.JmsResourceVistor;
import org.apache.qpid.jms.util.ToStringSupport;

public final class JmsConnectionInfo
implements JmsResource,
Comparable<JmsConnectionInfo> {
    public static final long INFINITE = -1L;
    public static final long DEFAULT_CONNECT_TIMEOUT = 15000L;
    public static final long DEFAULT_CLOSE_TIMEOUT = 15000L;
    public static final long DEFAULT_SEND_TIMEOUT = -1L;
    public static final long DEFAULT_REQUEST_TIMEOUT = -1L;
    private final JmsConnectionId connectionId;
    private String clientId;
    private String username;
    private String password;
    private boolean forceAsyncSend;
    private boolean alwaysSyncSend;
    public long sendTimeout = -1L;
    public long requestTimeout = -1L;
    public long connectTimeout = 15000L;
    public long closeTimeout = 15000L;
    private String queuePrefix = null;
    private String topicPrefix = null;
    private boolean validatePropertyNames = true;

    public JmsConnectionInfo(JmsConnectionId connectionId) {
        if (connectionId == null) {
            throw new IllegalArgumentException("ConnectionId cannot be null");
        }
        this.connectionId = connectionId;
    }

    public JmsConnectionInfo copy() {
        JmsConnectionInfo copy = new JmsConnectionInfo(this.connectionId);
        this.copy(copy);
        return copy;
    }

    private void copy(JmsConnectionInfo copy) {
        copy.clientId = this.clientId;
        copy.username = this.username;
        copy.password = this.password;
        copy.forceAsyncSend = this.forceAsyncSend;
        copy.alwaysSyncSend = this.alwaysSyncSend;
        copy.sendTimeout = this.sendTimeout;
        copy.requestTimeout = this.requestTimeout;
        copy.closeTimeout = this.closeTimeout;
        copy.queuePrefix = this.queuePrefix;
        copy.topicPrefix = this.topicPrefix;
        copy.connectTimeout = this.connectTimeout;
        copy.validatePropertyNames = this.validatePropertyNames;
    }

    public boolean isForceAsyncSend() {
        return this.forceAsyncSend;
    }

    public void setForceAsyncSends(boolean forceAsyncSend) {
        this.forceAsyncSend = forceAsyncSend;
    }

    public boolean isAlwaysSyncSend() {
        return this.alwaysSyncSend;
    }

    public void setAlwaysSyncSend(boolean alwaysSyncSend) {
        this.alwaysSyncSend = alwaysSyncSend;
    }

    public JmsConnectionId getConnectionId() {
        return this.connectionId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getQueuePrefix() {
        return this.queuePrefix;
    }

    public void setQueuePrefix(String queuePrefix) {
        this.queuePrefix = queuePrefix;
    }

    public String getTopicPrefix() {
        return this.topicPrefix;
    }

    public void setTopicPrefix(String topicPrefix) {
        this.topicPrefix = topicPrefix;
    }

    public boolean isValidatePropertyNames() {
        return this.validatePropertyNames;
    }

    public void setValidatePropertyNames(boolean validatePropertyNames) {
        this.validatePropertyNames = validatePropertyNames;
    }

    public long getCloseTimeout() {
        return this.closeTimeout;
    }

    public void setCloseTimeout(long closeTimeout) {
        this.closeTimeout = closeTimeout;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public long getSendTimeout() {
        return this.sendTimeout;
    }

    public void setSendTimeout(long sendTimeout) {
        this.sendTimeout = sendTimeout;
    }

    public long getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeout(long requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public String toString() {
        return ToStringSupport.toString(this);
    }

    public int hashCode() {
        return this.connectionId.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JmsConnectionInfo other = (JmsConnectionInfo)obj;
        return this.connectionId.equals(other.connectionId);
    }

    @Override
    public int compareTo(JmsConnectionInfo other) {
        return this.connectionId.compareTo(other.connectionId);
    }

    @Override
    public void visit(JmsResourceVistor vistor) throws Exception {
        vistor.processConnectionInfo(this);
    }
}

