/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.sasl;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.qpid.jms.sasl.Mechanism;
import org.apache.qpid.jms.sasl.MechanismFactory;
import org.apache.qpid.jms.util.FactoryFinder;
import org.apache.qpid.jms.util.ResourceNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaslMechanismFinder {
    private static final Logger LOG = LoggerFactory.getLogger(SaslMechanismFinder.class);
    private static final FactoryFinder<MechanismFactory> MECHANISM_FACTORY_FINDER = new FactoryFinder<MechanismFactory>(MechanismFactory.class, "META-INF/services/" + SaslMechanismFinder.class.getPackage().getName().replace(".", "/") + "/");

    public static Mechanism findMatchingMechanism(String username, String password, Principal localPrincipal, String ... remoteMechanisms) {
        Mechanism match = null;
        ArrayList<Mechanism> found = new ArrayList<Mechanism>();
        for (String remoteMechanism : remoteMechanisms) {
            MechanismFactory factory = SaslMechanismFinder.findMechanismFactory(remoteMechanism);
            if (factory == null) continue;
            Mechanism mech = factory.createMechanism();
            if (mech.isApplicable(username, password, localPrincipal)) {
                found.add(mech);
                continue;
            }
            LOG.debug("Skipping {} mechanism because the available credentials are not sufficient", (Object)mech);
        }
        if (!found.isEmpty()) {
            Collections.sort(found);
            match = (Mechanism)found.get(found.size() - 1);
        }
        LOG.info("Best match for SASL auth was: {}", match);
        return match;
    }

    protected static MechanismFactory findMechanismFactory(String name) {
        if (name == null || name.isEmpty()) {
            LOG.warn("No SASL mechanism name was specified");
            return null;
        }
        MechanismFactory factory = null;
        try {
            factory = MECHANISM_FACTORY_FINDER.newInstance(name);
        }
        catch (ResourceNotFoundException rnfe) {
            LOG.debug("Unknown SASL mechanism: [" + name + "]");
        }
        catch (Exception e) {
            LOG.warn("Caught exception while finding factory for SASL mechanism {}: {}", (Object)name, (Object)e.getMessage());
        }
        return factory;
    }
}

