/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.util;

import org.apache.qpid.jms.message.JmsInboundMessageDispatch;
import org.apache.qpid.jms.util.MessageQueue;

public abstract class AbstractMessageQueue
implements MessageQueue {
    protected boolean closed;
    protected boolean running;
    protected Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JmsInboundMessageDispatch peek() {
        Object object = this.lock;
        synchronized (object) {
            return this.peekFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JmsInboundMessageDispatch dequeue(long timeout) throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            while (!(timeout == 0L || this.closed || !this.isEmpty() && this.running)) {
                if (timeout == -1L) {
                    this.lock.wait();
                    continue;
                }
                this.lock.wait(timeout);
                break;
            }
            if (this.closed || !this.running || this.isEmpty()) {
                return null;
            }
            return this.removeFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JmsInboundMessageDispatch dequeueNoWait() {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed || !this.running || this.isEmpty()) {
                return null;
            }
            return this.removeFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            this.running = true;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            this.running = false;
            this.lock.notifyAll();
        }
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.closed) {
                this.running = false;
                this.closed = true;
            }
            this.lock.notifyAll();
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public Object getLock() {
        return this.lock;
    }

    protected abstract JmsInboundMessageDispatch removeFirst();

    protected abstract JmsInboundMessageDispatch peekFirst();
}

