/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.meta;

import java.net.URI;
import java.nio.charset.Charset;
import java.util.EnumMap;
import java.util.function.BiFunction;
import javax.jms.Connection;
import org.apache.qpid.jms.JmsConnection;
import org.apache.qpid.jms.JmsConnectionExtensions;
import org.apache.qpid.jms.meta.JmsAbstractResource;
import org.apache.qpid.jms.meta.JmsConnectionId;
import org.apache.qpid.jms.meta.JmsResourceVistor;
import org.apache.qpid.jms.policy.JmsDefaultDeserializationPolicy;
import org.apache.qpid.jms.policy.JmsDefaultMessageIDPolicy;
import org.apache.qpid.jms.policy.JmsDefaultPrefetchPolicy;
import org.apache.qpid.jms.policy.JmsDefaultPresettlePolicy;
import org.apache.qpid.jms.policy.JmsDefaultRedeliveryPolicy;
import org.apache.qpid.jms.policy.JmsDeserializationPolicy;
import org.apache.qpid.jms.policy.JmsMessageIDPolicy;
import org.apache.qpid.jms.policy.JmsPrefetchPolicy;
import org.apache.qpid.jms.policy.JmsPresettlePolicy;
import org.apache.qpid.jms.policy.JmsRedeliveryPolicy;

public final class JmsConnectionInfo
extends JmsAbstractResource
implements Comparable<JmsConnectionInfo> {
    public static final long INFINITE = -1L;
    public static final long DEFAULT_CONNECT_TIMEOUT = 15000L;
    public static final long DEFAULT_CLOSE_TIMEOUT = 60000L;
    public static final long DEFAULT_SEND_TIMEOUT = -1L;
    public static final long DEFAULT_REQUEST_TIMEOUT = -1L;
    private final JmsConnectionId connectionId;
    private final EnumMap<JmsConnectionExtensions, BiFunction<Connection, URI, Object>> extensionMap = new EnumMap(JmsConnectionExtensions.class);
    private JmsConnection connection;
    private URI configuredURI;
    private URI connectedURI;
    private String clientId;
    private boolean explicitClientID;
    private String username;
    private String password;
    private boolean forceAsyncSend;
    private boolean forceSyncSend;
    private boolean forceAsyncAcks;
    private boolean validatePropertyNames = true;
    private boolean receiveLocalOnly;
    private boolean receiveNoWaitLocalOnly;
    private boolean localMessagePriority;
    private boolean localMessageExpiry;
    private boolean populateJMSXUserID;
    private boolean useDaemonThread;
    private boolean awaitClientID = true;
    private long sendTimeout = -1L;
    private long requestTimeout = -1L;
    private long connectTimeout = 15000L;
    private long closeTimeout = 60000L;
    private String queuePrefix = null;
    private String topicPrefix = null;
    private JmsPrefetchPolicy prefetchPolicy;
    private JmsRedeliveryPolicy redeliveryPolicy;
    private JmsPresettlePolicy presettlePolicy;
    private JmsMessageIDPolicy messageIDPolicy;
    private JmsDeserializationPolicy deserializationPolicy;
    private volatile byte[] encodedUserId;

    public JmsConnectionInfo(JmsConnectionId connectionId) {
        if (connectionId == null) {
            throw new IllegalArgumentException("ConnectionId cannot be null");
        }
        this.connectionId = connectionId;
    }

    public JmsConnectionInfo copy() {
        JmsConnectionInfo copy = new JmsConnectionInfo(this.connectionId);
        this.copy(copy);
        return copy;
    }

    private void copy(JmsConnectionInfo copy) {
        copy.clientId = this.clientId;
        copy.explicitClientID = this.explicitClientID;
        copy.awaitClientID = this.awaitClientID;
        copy.username = this.username;
        copy.password = this.password;
        copy.forceAsyncSend = this.forceAsyncSend;
        copy.forceSyncSend = this.forceSyncSend;
        copy.sendTimeout = this.sendTimeout;
        copy.requestTimeout = this.requestTimeout;
        copy.closeTimeout = this.closeTimeout;
        copy.queuePrefix = this.queuePrefix;
        copy.topicPrefix = this.topicPrefix;
        copy.connectTimeout = this.connectTimeout;
        copy.validatePropertyNames = this.validatePropertyNames;
        copy.useDaemonThread = this.useDaemonThread;
        copy.messageIDPolicy = this.getMessageIDPolicy().copy();
        copy.prefetchPolicy = this.getPrefetchPolicy().copy();
        copy.redeliveryPolicy = this.getRedeliveryPolicy().copy();
        copy.presettlePolicy = this.getPresettlePolicy().copy();
        copy.deserializationPolicy = this.getDeserializationPolicy().copy();
    }

    public boolean isForceAsyncSend() {
        return this.forceAsyncSend;
    }

    public void setForceAsyncSend(boolean forceAsyncSend) {
        this.forceAsyncSend = forceAsyncSend;
    }

    public boolean isForceSyncSend() {
        return this.forceSyncSend;
    }

    public void setForceSyncSend(boolean forceSyncSend) {
        this.forceSyncSend = forceSyncSend;
    }

    @Override
    public JmsConnectionId getId() {
        return this.connectionId;
    }

    public URI getConfiguredURI() {
        return this.configuredURI;
    }

    public void setConfiguredURI(URI uri) {
        this.configuredURI = uri;
    }

    public URI getConnectedURI() {
        return this.connectedURI;
    }

    public void setConnectedURI(URI connectedURI) {
        this.connectedURI = connectedURI;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId, boolean explicitClientID) {
        this.clientId = clientId;
        this.explicitClientID = explicitClientID;
    }

    public boolean isExplicitClientID() {
        return this.explicitClientID;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getQueuePrefix() {
        return this.queuePrefix;
    }

    public void setQueuePrefix(String queuePrefix) {
        this.queuePrefix = queuePrefix;
    }

    public String getTopicPrefix() {
        return this.topicPrefix;
    }

    public void setTopicPrefix(String topicPrefix) {
        this.topicPrefix = topicPrefix;
    }

    public boolean isValidatePropertyNames() {
        return this.validatePropertyNames;
    }

    public void setValidatePropertyNames(boolean validatePropertyNames) {
        this.validatePropertyNames = validatePropertyNames;
    }

    public long getCloseTimeout() {
        return this.closeTimeout;
    }

    public void setCloseTimeout(long closeTimeout) {
        this.closeTimeout = closeTimeout;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public long getSendTimeout() {
        return this.sendTimeout;
    }

    public void setSendTimeout(long sendTimeout) {
        this.sendTimeout = sendTimeout;
    }

    public long getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeout(long requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public boolean isLocalMessagePriority() {
        return this.localMessagePriority;
    }

    public void setLocalMessagePriority(boolean localMessagePriority) {
        this.localMessagePriority = localMessagePriority;
    }

    public boolean isForceAsyncAcks() {
        return this.forceAsyncAcks;
    }

    public void setForceAsyncAcks(boolean forceAsyncAcks) {
        this.forceAsyncAcks = forceAsyncAcks;
    }

    public boolean isReceiveLocalOnly() {
        return this.receiveLocalOnly;
    }

    public void setReceiveLocalOnly(boolean receiveLocalOnly) {
        this.receiveLocalOnly = receiveLocalOnly;
    }

    public boolean isReceiveNoWaitLocalOnly() {
        return this.receiveNoWaitLocalOnly;
    }

    public void setReceiveNoWaitLocalOnly(boolean receiveNoWaitLocalOnly) {
        this.receiveNoWaitLocalOnly = receiveNoWaitLocalOnly;
    }

    public boolean isLocalMessageExpiry() {
        return this.localMessageExpiry;
    }

    public void setLocalMessageExpiry(boolean localMessageExpiry) {
        this.localMessageExpiry = localMessageExpiry;
    }

    public JmsPrefetchPolicy getPrefetchPolicy() {
        if (this.prefetchPolicy == null) {
            this.prefetchPolicy = new JmsDefaultPrefetchPolicy();
        }
        return this.prefetchPolicy;
    }

    public void setPrefetchPolicy(JmsPrefetchPolicy prefetchPolicy) {
        this.prefetchPolicy = prefetchPolicy.copy();
    }

    public JmsRedeliveryPolicy getRedeliveryPolicy() {
        if (this.redeliveryPolicy == null) {
            this.redeliveryPolicy = new JmsDefaultRedeliveryPolicy();
        }
        return this.redeliveryPolicy;
    }

    public void setRedeliveryPolicy(JmsRedeliveryPolicy redeliveryPolicy) {
        this.redeliveryPolicy = redeliveryPolicy.copy();
    }

    public JmsPresettlePolicy getPresettlePolicy() {
        if (this.presettlePolicy == null) {
            this.presettlePolicy = new JmsDefaultPresettlePolicy();
        }
        return this.presettlePolicy;
    }

    public void setPresettlePolicy(JmsPresettlePolicy presettlePolicy) {
        this.presettlePolicy = presettlePolicy;
    }

    public JmsMessageIDPolicy getMessageIDPolicy() {
        if (this.messageIDPolicy == null) {
            this.messageIDPolicy = new JmsDefaultMessageIDPolicy();
        }
        return this.messageIDPolicy;
    }

    public void setMessageIDPolicy(JmsMessageIDPolicy messageIDPolicy) {
        this.messageIDPolicy = messageIDPolicy;
    }

    public boolean isPopulateJMSXUserID() {
        return this.populateJMSXUserID;
    }

    public void setPopulateJMSXUserID(boolean populateMessageUserID) {
        this.populateJMSXUserID = populateMessageUserID;
    }

    public byte[] getEncodedUsername() {
        if (this.encodedUserId == null && this.username != null) {
            this.encodedUserId = this.username.getBytes(Charset.forName("UTF-8"));
        }
        return this.encodedUserId;
    }

    public JmsDeserializationPolicy getDeserializationPolicy() {
        if (this.deserializationPolicy == null) {
            this.deserializationPolicy = new JmsDefaultDeserializationPolicy();
        }
        return this.deserializationPolicy;
    }

    public void setDeserializationPolicy(JmsDeserializationPolicy deserializationPolicy) {
        this.deserializationPolicy = deserializationPolicy;
    }

    public boolean isUseDaemonThread() {
        return this.useDaemonThread;
    }

    public void setUseDaemonThread(boolean useDaemonThread) {
        this.useDaemonThread = useDaemonThread;
    }

    public boolean isAwaitClientID() {
        return this.awaitClientID;
    }

    public void setAwaitClientID(boolean awaitClientID) {
        this.awaitClientID = awaitClientID;
    }

    public EnumMap<JmsConnectionExtensions, BiFunction<Connection, URI, Object>> getExtensionMap() {
        return this.extensionMap;
    }

    public JmsConnection getConnection() {
        return this.connection;
    }

    public void setConnection(JmsConnection connection) {
        this.connection = connection;
    }

    public String toString() {
        return "JmsConnectionInfo { " + this.getId() + ", configuredURI = " + this.getConfiguredURI() + ", connectedURI = " + this.getConnectedURI() + " }";
    }

    public int hashCode() {
        return this.connectionId.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JmsConnectionInfo other = (JmsConnectionInfo)obj;
        return this.connectionId.equals(other.connectionId);
    }

    @Override
    public int compareTo(JmsConnectionInfo other) {
        return this.connectionId.compareTo(other.connectionId);
    }

    @Override
    public void visit(JmsResourceVistor vistor) throws Exception {
        vistor.processConnectionInfo(this);
    }
}

