/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.transports;

import io.netty.handler.ssl.SslHandler;
import java.io.File;
import java.io.FileInputStream;
import java.net.URI;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509TrustManager;
import org.apache.qpid.jms.transports.TransportOptions;
import org.apache.qpid.jms.transports.X509AliasKeyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportSupport {
    private static final Logger LOG = LoggerFactory.getLogger(TransportSupport.class);

    public static SslHandler createSslHandler(URI remote, TransportOptions options) throws Exception {
        SSLContext sslContext = options.getSslContextOverride();
        if (sslContext == null) {
            sslContext = TransportSupport.createSslContext(options);
        }
        SSLEngine sslEngine = TransportSupport.createSslEngine(remote, sslContext, options);
        return new SslHandler(sslEngine);
    }

    public static SSLContext createSslContext(TransportOptions options) throws Exception {
        try {
            String contextProtocol = options.getContextProtocol();
            LOG.trace("Getting SSLContext instance using protocol: {}", (Object)contextProtocol);
            SSLContext context = SSLContext.getInstance(contextProtocol);
            KeyManager[] keyMgrs = TransportSupport.loadKeyManagers(options);
            TrustManager[] trustManagers = TransportSupport.loadTrustManagers(options);
            context.init(keyMgrs, trustManagers, new SecureRandom());
            return context;
        }
        catch (Exception e) {
            LOG.error("Failed to create SSLContext: {}", (Object)e, (Object)e);
            throw e;
        }
    }

    public static SSLEngine createSslEngine(SSLContext context, TransportOptions options) throws Exception {
        return TransportSupport.createSslEngine(null, context, options);
    }

    public static SSLEngine createSslEngine(URI remote, SSLContext context, TransportOptions options) throws Exception {
        SSLEngine engine = null;
        engine = remote == null ? context.createSSLEngine() : context.createSSLEngine(remote.getHost(), remote.getPort());
        engine.setEnabledProtocols(TransportSupport.buildEnabledProtocols(engine, options));
        engine.setEnabledCipherSuites(TransportSupport.buildEnabledCipherSuites(engine, options));
        engine.setUseClientMode(true);
        if (options.isVerifyHost()) {
            SSLParameters sslParameters = engine.getSSLParameters();
            sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
            engine.setSSLParameters(sslParameters);
        }
        return engine;
    }

    private static String[] buildEnabledProtocols(SSLEngine engine, TransportOptions options) {
        ArrayList<String> enabledProtocols = new ArrayList<String>();
        if (options.getEnabledProtocols() != null) {
            List<String> configuredProtocols = Arrays.asList(options.getEnabledProtocols());
            LOG.trace("Configured protocols from transport options: {}", configuredProtocols);
            enabledProtocols.addAll(configuredProtocols);
        } else {
            List<String> engineProtocols = Arrays.asList(engine.getEnabledProtocols());
            LOG.trace("Default protocols from the SSLEngine: {}", engineProtocols);
            enabledProtocols.addAll(engineProtocols);
        }
        String[] disabledProtocols = options.getDisabledProtocols();
        if (disabledProtocols != null) {
            List<String> disabled = Arrays.asList(disabledProtocols);
            LOG.trace("Disabled protocols: {}", disabled);
            enabledProtocols.removeAll(disabled);
        }
        LOG.trace("Enabled protocols: {}", enabledProtocols);
        return enabledProtocols.toArray(new String[0]);
    }

    private static String[] buildEnabledCipherSuites(SSLEngine engine, TransportOptions options) {
        ArrayList<String> enabledCipherSuites = new ArrayList<String>();
        if (options.getEnabledCipherSuites() != null) {
            List<String> configuredCipherSuites = Arrays.asList(options.getEnabledCipherSuites());
            LOG.trace("Configured cipher suites from transport options: {}", configuredCipherSuites);
            enabledCipherSuites.addAll(configuredCipherSuites);
        } else {
            List<String> engineCipherSuites = Arrays.asList(engine.getEnabledCipherSuites());
            LOG.trace("Default cipher suites from the SSLEngine: {}", engineCipherSuites);
            enabledCipherSuites.addAll(engineCipherSuites);
        }
        String[] disabledCipherSuites = options.getDisabledCipherSuites();
        if (disabledCipherSuites != null) {
            List<String> disabled = Arrays.asList(disabledCipherSuites);
            LOG.trace("Disabled cipher suites: {}", disabled);
            enabledCipherSuites.removeAll(disabled);
        }
        LOG.trace("Enabled cipher suites: {}", enabledCipherSuites);
        return enabledCipherSuites.toArray(new String[0]);
    }

    private static TrustManager[] loadTrustManagers(TransportOptions options) throws Exception {
        if (options.isTrustAll()) {
            return new TrustManager[]{TransportSupport.createTrustAllTrustManager()};
        }
        if (options.getTrustStoreLocation() == null) {
            return null;
        }
        TrustManagerFactory fact = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        String storeLocation = options.getTrustStoreLocation();
        String storePassword = options.getTrustStorePassword();
        String storeType = options.getTrustStoreType();
        LOG.trace("Attempt to load TrustStore from location {} of type {}", (Object)storeLocation, (Object)storeType);
        KeyStore trustStore = TransportSupport.loadStore(storeLocation, storePassword, storeType);
        fact.init(trustStore);
        return fact.getTrustManagers();
    }

    private static KeyManager[] loadKeyManagers(TransportOptions options) throws Exception {
        if (options.getKeyStoreLocation() == null) {
            return null;
        }
        KeyManagerFactory fact = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        String storeLocation = options.getKeyStoreLocation();
        String storePassword = options.getKeyStorePassword();
        String storeType = options.getKeyStoreType();
        String alias = options.getKeyAlias();
        LOG.trace("Attempt to load KeyStore from location {} of type {}", (Object)storeLocation, (Object)storeType);
        KeyStore keyStore = TransportSupport.loadStore(storeLocation, storePassword, storeType);
        fact.init(keyStore, storePassword != null ? storePassword.toCharArray() : null);
        if (alias == null) {
            return fact.getKeyManagers();
        }
        TransportSupport.validateAlias(keyStore, alias);
        return TransportSupport.wrapKeyManagers(alias, fact.getKeyManagers());
    }

    private static KeyManager[] wrapKeyManagers(String alias, KeyManager[] origKeyManagers) {
        KeyManager[] keyManagers = new KeyManager[origKeyManagers.length];
        for (int i = 0; i < origKeyManagers.length; ++i) {
            KeyManager km = origKeyManagers[i];
            if (km instanceof X509ExtendedKeyManager) {
                km = new X509AliasKeyManager(alias, (X509ExtendedKeyManager)km);
            }
            keyManagers[i] = km;
        }
        return keyManagers;
    }

    private static void validateAlias(KeyStore store, String alias) throws IllegalArgumentException, KeyStoreException {
        if (!store.containsAlias(alias)) {
            throw new IllegalArgumentException("The alias '" + alias + "' doesn't exist in the key store");
        }
        if (!store.isKeyEntry(alias)) {
            throw new IllegalArgumentException("The alias '" + alias + "' in the keystore doesn't represent a key entry");
        }
    }

    private static KeyStore loadStore(String storePath, String password, String storeType) throws Exception {
        KeyStore store = KeyStore.getInstance(storeType);
        try (FileInputStream in = new FileInputStream(new File(storePath));){
            store.load(in, password != null ? password.toCharArray() : null);
        }
        return store;
    }

    private static TrustManager createTrustAllTrustManager() {
        return new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
    }
}

