/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import org.apache.qpid.jms.provider.ProviderFuture;
import org.apache.qpid.jms.provider.ProviderSynchronization;
import org.apache.qpid.jms.util.IOExceptionSupport;

public class ProgressiveProviderFuture
extends ProviderFuture {
    private static final int SPIN_COUNT = 10;
    private static final int YIELD_COUNT = 100;
    private static final int TINY_PARK_COUNT = 1000;
    private static final int TINY_PARK_NANOS = 1;
    private static final int SMALL_PARK_COUNT = 101000;
    private static final int SMALL_PARK_NANOS = 10000;

    public ProgressiveProviderFuture() {
        this(null);
    }

    public ProgressiveProviderFuture(ProviderSynchronization synchronization) {
        super(synchronization);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean sync(long amount, TimeUnit unit) throws IOException {
        try {
            if (this.isComplete() || amount == 0L) {
                this.failOnError();
                return true;
            }
            long timeout = unit.toNanos(amount);
            long maxParkNanos = timeout / 8L;
            maxParkNanos = maxParkNanos > 0L ? maxParkNanos : timeout;
            long tinyParkNanos = Math.min(maxParkNanos, 1L);
            long smallParkNanos = Math.min(maxParkNanos, 10000L);
            long startTime = System.nanoTime();
            int idleCount = 0;
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            while (true) {
                long elapsed;
                long diff;
                if ((diff = (elapsed = System.nanoTime() - startTime) - timeout) >= 0L) {
                    this.failOnError();
                    return this.isComplete();
                }
                if (this.isComplete()) {
                    this.failOnError();
                    return true;
                }
                if (idleCount < 10) {
                    ++idleCount;
                    continue;
                }
                if (idleCount < 100) {
                    Thread.yield();
                    ++idleCount;
                    continue;
                }
                if (idleCount < 1000) {
                    LockSupport.parkNanos(tinyParkNanos);
                    ++idleCount;
                    continue;
                }
                if (idleCount < 101000) {
                    LockSupport.parkNanos(smallParkNanos);
                    ++idleCount;
                    continue;
                }
                ProgressiveProviderFuture progressiveProviderFuture = this;
                synchronized (progressiveProviderFuture) {
                    if (this.isComplete()) {
                        this.failOnError();
                        return true;
                    }
                    ++this.waiting;
                    try {
                        this.wait(-diff / 1000000L, (int)(-diff % 1000000L));
                    }
                    finally {
                        --this.waiting;
                    }
                }
            }
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw IOExceptionSupport.create(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void sync() throws IOException {
        try {
            if (this.isComplete()) {
                this.failOnError();
                return;
            }
            int idleCount = 0;
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            while (true) {
                if (this.isComplete()) {
                    this.failOnError();
                    return;
                }
                if (idleCount < 10) {
                    ++idleCount;
                    continue;
                }
                if (idleCount < 100) {
                    Thread.yield();
                    ++idleCount;
                    continue;
                }
                if (idleCount < 1000) {
                    LockSupport.parkNanos(1L);
                    ++idleCount;
                    continue;
                }
                if (idleCount < 101000) {
                    LockSupport.parkNanos(10000L);
                    ++idleCount;
                    continue;
                }
                ProgressiveProviderFuture progressiveProviderFuture = this;
                synchronized (progressiveProviderFuture) {
                    if (this.isComplete()) {
                        this.failOnError();
                        return;
                    }
                    ++this.waiting;
                    try {
                        this.wait();
                    }
                    finally {
                        --this.waiting;
                    }
                }
            }
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw IOExceptionSupport.create(e);
        }
    }
}

