/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp;

import java.io.IOException;
import org.apache.qpid.jms.message.JmsInboundMessageDispatch;
import org.apache.qpid.jms.meta.JmsConsumerInfo;
import org.apache.qpid.jms.provider.amqp.AmqpConsumer;
import org.apache.qpid.jms.provider.amqp.AmqpProvider;
import org.apache.qpid.jms.provider.amqp.AmqpSession;
import org.apache.qpid.jms.util.IOExceptionSupport;
import org.apache.qpid.proton.amqp.messaging.Source;
import org.apache.qpid.proton.engine.Receiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpQueueBrowser
extends AmqpConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(AmqpQueueBrowser.class);

    public AmqpQueueBrowser(AmqpSession session, JmsConsumerInfo info) {
        super(session, info);
    }

    @Override
    public void pull(long timeout) {
        if (!((Receiver)this.getEndpoint()).getDrain() && ((Receiver)this.getEndpoint()).current() == null && ((Receiver)this.getEndpoint()).getUnsettled() == 0) {
            LOG.trace("QueueBrowser {} will try to drain remote.", (Object)this.getConsumerId());
            ((Receiver)this.getEndpoint()).drain(((JmsConsumerInfo)this.resource).getPrefetchSize());
        } else {
            ((Receiver)this.getEndpoint()).setDrain(false);
        }
    }

    @Override
    public void processFlowUpdates(AmqpProvider provider) throws IOException {
        if (((Receiver)this.getEndpoint()).getDrain() && ((Receiver)this.getEndpoint()).getCredit() == ((Receiver)this.getEndpoint()).getRemoteCredit()) {
            JmsInboundMessageDispatch browseDone = new JmsInboundMessageDispatch(this.getNextIncomingSequenceNumber());
            browseDone.setConsumerId(this.getConsumerId());
            try {
                this.deliver(browseDone);
            }
            catch (Exception e) {
                throw IOExceptionSupport.create(e);
            }
        } else {
            ((Receiver)this.getEndpoint()).setDrain(false);
        }
        super.processFlowUpdates(provider);
    }

    @Override
    public void processDeliveryUpdates(AmqpProvider provider) throws IOException {
        if (((Receiver)this.getEndpoint()).getDrain() && ((Receiver)this.getEndpoint()).current() != null) {
            LOG.trace("{} incoming delivery, cancel drain.", (Object)this.getConsumerId());
            ((Receiver)this.getEndpoint()).setDrain(false);
        }
        super.processDeliveryUpdates(provider);
        if (((Receiver)this.getEndpoint()).getDrain() && ((Receiver)this.getEndpoint()).getCredit() == ((Receiver)this.getEndpoint()).getRemoteCredit()) {
            JmsInboundMessageDispatch browseDone = new JmsInboundMessageDispatch(this.getNextIncomingSequenceNumber());
            browseDone.setConsumerId(this.getConsumerId());
            try {
                this.deliver(browseDone);
            }
            catch (Exception e) {
                throw IOExceptionSupport.create(e);
            }
        } else {
            ((Receiver)this.getEndpoint()).setDrain(false);
        }
    }

    @Override
    protected void configureSource(Source source) {
        if (((JmsConsumerInfo)this.resource).isBrowser()) {
            source.setDistributionMode(COPY);
        }
        super.configureSource(source);
    }

    @Override
    public boolean isBrowser() {
        return true;
    }
}

