/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp.message;

import java.util.Map;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.message.Message;

public final class AmqpMessageSupport {
    public static final String JMS_APP_CORRELATION_ID = "x-opt-app-correlation-id";
    public static final String JMS_MSG_TYPE = "x-opt-jms-msg-type";
    public static final byte JMS_MESSAGE = 0;
    public static final byte JMS_OBJECT_MESSAGE = 1;
    public static final byte JMS_MAP_MESSAGE = 2;
    public static final byte JMS_BYTES_MESSAGE = 3;
    public static final byte JMS_STREAM_MESSAGE = 4;
    public static final byte JMS_TEXT_MESSAGE = 5;
    public static final String JMS_AMQP_TTL = "JMS_AMQP_TTL";
    public static final String JMS_AMQP_REPLY_TO_GROUP_ID = "JMS_AMQP_REPLY_TO_GROUP_ID";
    public static final String JMS_AMQP_TYPED_ENCODING = "JMS_AMQP_TYPED_ENCODING";
    public static final String SERIALIZED_JAVA_OBJECT_CONTENT_TYPE = "application/x-java-serialized-object";
    public static final String OCTET_STREAM_CONTENT_TYPE = "application/octet-stream";
    public static final String LEGACY_TO_TYPE_MSG_ANNOTATION_SYMBOL_NAME = "x-opt-to-type";
    public static final String LEGACY_REPLY_TO_TYPE_MSG_ANNOTATION_SYMBOL_NAME = "x-opt-reply-type";
    public static final String LEGACY_QUEUE_ATTRIBUTE = "queue";
    public static final String LEGACY_TOPIC_ATTRIBUTE = "topic";
    public static final String LEGACY_TEMPORARY_ATTRIBUTE = "temporary";

    public static Symbol getSymbol(String key) {
        return Symbol.valueOf((String)key);
    }

    public static Object getMessageAnnotation(String key, Message message) {
        if (message != null && message.getMessageAnnotations() != null) {
            Map annotations = message.getMessageAnnotations().getValue();
            return annotations.get(AmqpMessageSupport.getSymbol(key));
        }
        return null;
    }

    public static boolean isContentType(String contentType, Message message) {
        if (contentType == null) {
            return message.getContentType() == null;
        }
        return contentType.equals(message.getContentType());
    }
}

