/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ToStringSupport {
    private static final Logger LOG = LoggerFactory.getLogger(ToStringSupport.class);

    private ToStringSupport() {
    }

    public static String toString(Object target) {
        return ToStringSupport.toString(target, Object.class, null);
    }

    public static String toString(Object target, Class stopClass) {
        return ToStringSupport.toString(target, stopClass, null);
    }

    public static String toString(Object target, Class stopClass, Map<String, Object> overrideFields) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        ToStringSupport.addFields(target, target.getClass(), stopClass, map);
        if (overrideFields != null) {
            for (Map.Entry<String, Object> entry : overrideFields.entrySet()) {
                map.put(entry.getKey(), entry.getValue());
            }
        }
        StringBuffer buffer = new StringBuffer(ToStringSupport.simpleName(target.getClass()));
        buffer.append(" {");
        Set<Map.Entry<String, Object>> entrySet = map.entrySet();
        boolean first = true;
        for (Map.Entry<String, Object> entry : entrySet) {
            Object value = entry.getValue();
            String key = entry.getKey();
            if (first) {
                first = false;
            } else {
                buffer.append(", ");
            }
            buffer.append((Object)key);
            buffer.append(" = ");
            ToStringSupport.appendToString(buffer, key, value);
        }
        buffer.append("}");
        return buffer.toString();
    }

    protected static void appendToString(StringBuffer buffer, Object key, Object value) {
        if (key.toString().toLowerCase(Locale.ENGLISH).contains("password")) {
            buffer.append("*****");
        } else {
            buffer.append(value);
        }
    }

    public static String simpleName(Class<?> clazz) {
        String name = clazz.getName();
        int p = name.lastIndexOf(".");
        if (p >= 0) {
            name = name.substring(p + 1);
        }
        return name;
    }

    private static void addFields(Object target, Class startClass, Class<Object> stopClass, LinkedHashMap<String, Object> map) {
        Field[] fields;
        if (startClass != stopClass) {
            ToStringSupport.addFields(target, startClass.getSuperclass(), stopClass, map);
        }
        for (Field field : fields = startClass.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers()) || Modifier.isPrivate(field.getModifiers())) continue;
            try {
                field.setAccessible(true);
                List<Object> o = field.get(target);
                if (o != null && o.getClass().isArray()) {
                    try {
                        o = Arrays.asList((Object[])o);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                map.put(field.getName(), o);
            }
            catch (Exception e) {
                LOG.debug("Error getting field " + field + " on class " + startClass + ". This exception is ignored.", (Throwable)e);
            }
        }
    }
}

