/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp;

import org.apache.qpid.jms.message.JmsOutboundMessageDispatch;
import org.apache.qpid.jms.meta.JmsProducerId;
import org.apache.qpid.jms.meta.JmsProducerInfo;
import org.apache.qpid.jms.provider.AsyncResult;
import org.apache.qpid.jms.provider.ProviderException;
import org.apache.qpid.jms.provider.WrappedAsyncResult;
import org.apache.qpid.jms.provider.amqp.AmqpProducer;
import org.apache.qpid.jms.provider.amqp.AmqpSession;
import org.apache.qpid.jms.provider.amqp.builders.AmqpProducerBuilder;
import org.apache.qpid.jms.util.IdGenerator;
import org.apache.qpid.proton.engine.EndpointState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpAnonymousFallbackProducer
extends AmqpProducer {
    private static final Logger LOG = LoggerFactory.getLogger(AmqpAnonymousFallbackProducer.class);
    private static final IdGenerator producerIdGenerator = new IdGenerator();
    private final String producerIdKey = producerIdGenerator.generateId();
    private long producerIdCount;

    public AmqpAnonymousFallbackProducer(AmqpSession session, JmsProducerInfo info) {
        super(session, info);
    }

    @Override
    public void send(JmsOutboundMessageDispatch envelope, AsyncResult request) throws ProviderException {
        LOG.trace("Started send chain for anonymous producer: {}", (Object)this.getProducerId());
        JmsProducerInfo info = new JmsProducerInfo(this.getNextProducerId());
        info.setDestination(envelope.getDestination());
        info.setPresettle(((JmsProducerInfo)this.getResourceInfo()).isPresettle());
        AmqpProducerBuilder builder = new AmqpProducerBuilder(this.session, info);
        builder.buildResource(new AnonymousSendRequest(request, builder, envelope, envelope.isCompletionRequired()));
        envelope.setSendAsync(false);
        envelope.setCompletionRequired(false);
        this.getParent().getProvider().pumpToProtonTransport(request);
    }

    @Override
    public void close(AsyncResult request) {
        request.onSuccess();
    }

    @Override
    public boolean isAnonymous() {
        return true;
    }

    @Override
    public EndpointState getLocalState() {
        return EndpointState.ACTIVE;
    }

    @Override
    public EndpointState getRemoteState() {
        return EndpointState.ACTIVE;
    }

    private JmsProducerId getNextProducerId() {
        return new JmsProducerId(this.producerIdKey, -1L, this.producerIdCount++);
    }

    private final class AnonymousCloseRequest
    extends AnonymousRequest {
        private final AmqpProducer producer;

        public AnonymousCloseRequest(AnonymousSendCompleteRequest sendComplete) {
            super(sendComplete.getWrappedRequest(), sendComplete.envelope, sendComplete.isCompletionRequired());
            this.producer = sendComplete.getProducer();
        }

        @Override
        public void onSuccess() {
            LOG.trace("Close phase of anonymous send complete: {} ", (Object)AmqpAnonymousFallbackProducer.this.getProducerId());
            super.onSuccess();
            if (this.isCompletionRequired()) {
                AmqpAnonymousFallbackProducer.this.getParent().getProvider().getProviderListener().onCompletedMessageSend(this.envelope);
            }
        }

        @Override
        public AmqpProducer getProducer() {
            return this.producer;
        }
    }

    private final class AnonymousSendCompleteRequest
    extends AnonymousRequest {
        private final AmqpProducer producer;

        public AnonymousSendCompleteRequest(AnonymousSendRequest open) {
            super(open.getWrappedRequest(), open.envelope, open.isCompletionRequired());
            this.producer = open.getProducer();
        }

        @Override
        public void onFailure(ProviderException result) {
            LOG.trace("Send phase of anonymous send failed: {} ", (Object)AmqpAnonymousFallbackProducer.this.getProducerId());
            AnonymousCloseRequest close = new AnonymousCloseRequest(this);
            this.producer.close(close);
            super.onFailure(result);
        }

        @Override
        public void onSuccess() {
            LOG.trace("Send phase of anonymous send complete: {} ", (Object)AmqpAnonymousFallbackProducer.this.getProducerId());
            AnonymousCloseRequest close = new AnonymousCloseRequest(this);
            this.producer.close(close);
        }

        @Override
        public AmqpProducer getProducer() {
            return this.producer;
        }
    }

    private final class AnonymousSendRequest
    extends AnonymousRequest {
        private final AmqpProducerBuilder producerBuilder;

        public AnonymousSendRequest(AsyncResult sendResult, AmqpProducerBuilder producerBuilder, JmsOutboundMessageDispatch envelope, boolean completionRequired) {
            super(sendResult, envelope, completionRequired);
            this.producerBuilder = producerBuilder;
        }

        @Override
        public void onSuccess() {
            LOG.trace("Open phase of anonymous send complete: {} ", (Object)AmqpAnonymousFallbackProducer.this.getProducerId());
            AnonymousSendCompleteRequest send = new AnonymousSendCompleteRequest(this);
            try {
                this.getProducer().send(this.envelope, send);
            }
            catch (ProviderException e) {
                super.onFailure(e);
            }
        }

        @Override
        public AmqpProducer getProducer() {
            return (AmqpProducer)this.producerBuilder.getResource();
        }
    }

    private abstract class AnonymousRequest
    extends WrappedAsyncResult {
        protected final JmsOutboundMessageDispatch envelope;
        private final boolean completionRequired;

        public AnonymousRequest(AsyncResult sendResult, JmsOutboundMessageDispatch envelope, boolean completionRequired) {
            super(sendResult);
            this.envelope = envelope;
            this.completionRequired = completionRequired;
        }

        @Override
        public void onFailure(ProviderException result) {
            LOG.debug("Send failed during {} step in chain: {}", (Object)this.getClass().getName(), (Object)AmqpAnonymousFallbackProducer.this.getProducerId());
            super.onFailure(result);
        }

        public boolean isCompletionRequired() {
            return this.completionRequired;
        }

        public abstract AmqpProducer getProducer();
    }
}

