/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.transports.netty;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.proxy.ProxyHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.resolver.AddressResolverGroup;
import io.netty.resolver.NoopAddressResolverGroup;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.URI;
import java.security.Principal;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import org.apache.qpid.jms.transports.Transport;
import org.apache.qpid.jms.transports.TransportListener;
import org.apache.qpid.jms.transports.TransportOptions;
import org.apache.qpid.jms.transports.TransportSupport;
import org.apache.qpid.jms.transports.netty.EpollSupport;
import org.apache.qpid.jms.transports.netty.KQueueSupport;
import org.apache.qpid.jms.util.IOExceptionSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyTcpTransport
implements Transport {
    private static final Logger LOG = LoggerFactory.getLogger(NettyTcpTransport.class);
    public static final int SHUTDOWN_TIMEOUT = 50;
    public static final int DEFAULT_MAX_FRAME_SIZE = 65535;
    protected Bootstrap bootstrap;
    protected EventLoopGroup group;
    protected Channel channel;
    protected TransportListener listener;
    protected ThreadFactory ioThreadfactory;
    protected int maxFrameSize = 65535;
    private final boolean secure;
    private final TransportOptions options;
    private final URI remote;
    private final AtomicBoolean connected = new AtomicBoolean();
    private final AtomicBoolean closed = new AtomicBoolean();
    private final CountDownLatch connectLatch = new CountDownLatch(1);
    private volatile IOException failureCause;

    public NettyTcpTransport(URI remoteLocation, TransportOptions options, boolean secure) {
        this(null, remoteLocation, options, secure);
    }

    public NettyTcpTransport(TransportListener listener, URI remoteLocation, TransportOptions options, boolean secure) {
        if (options == null) {
            throw new IllegalArgumentException("Transport Options cannot be null");
        }
        if (remoteLocation == null) {
            throw new IllegalArgumentException("Transport remote location cannot be null");
        }
        this.secure = secure;
        this.options = options;
        this.listener = listener;
        this.remote = remoteLocation;
    }

    @Override
    public ScheduledExecutorService connect(final Runnable initRoutine, SSLContext sslContextOverride) throws IOException {
        if (this.closed.get()) {
            throw new IllegalStateException("Transport has already been closed");
        }
        if (this.listener == null) {
            throw new IllegalStateException("A transport listener must be set before connection attempts.");
        }
        TransportOptions transportOptions = this.getTransportOptions();
        boolean useKQueue = KQueueSupport.isAvailable(transportOptions);
        boolean useEpoll = EpollSupport.isAvailable(transportOptions);
        if (useKQueue) {
            LOG.trace("Netty Transport using KQueue mode");
            this.group = KQueueSupport.createGroup(1, this.ioThreadfactory);
        } else if (useEpoll) {
            LOG.trace("Netty Transport using Epoll mode");
            this.group = EpollSupport.createGroup(1, this.ioThreadfactory);
        } else {
            LOG.trace("Netty Transport using NIO mode");
            this.group = new NioEventLoopGroup(1, this.ioThreadfactory);
        }
        this.bootstrap = new Bootstrap();
        this.bootstrap.group(this.group);
        if (useKQueue) {
            KQueueSupport.createChannel(this.bootstrap);
        } else if (useEpoll) {
            EpollSupport.createChannel(this.bootstrap);
        } else {
            this.bootstrap.channel(NioSocketChannel.class);
        }
        this.bootstrap.handler((ChannelHandler)new ChannelInitializer<Channel>(){

            public void initChannel(Channel connectedChannel) throws Exception {
                if (initRoutine != null) {
                    try {
                        initRoutine.run();
                    }
                    catch (Throwable initError) {
                        LOG.warn("Error during initialization of channel from provided initialization routine");
                        NettyTcpTransport.this.connectionFailed(connectedChannel, IOExceptionSupport.create(initError));
                        throw initError;
                    }
                }
                NettyTcpTransport.this.configureChannel(connectedChannel);
            }
        });
        this.configureNetty(this.bootstrap, transportOptions);
        transportOptions.setSslContextOverride(sslContextOverride);
        ChannelFuture future = this.bootstrap.connect(this.getRemoteHost(), this.getRemotePort());
        future.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    NettyTcpTransport.this.handleException(future.channel(), IOExceptionSupport.create(future.cause()));
                }
            }
        });
        try {
            this.connectLatch.await();
        }
        catch (InterruptedException ex) {
            LOG.debug("Transport connection was interrupted.");
            Thread.interrupted();
            this.failureCause = IOExceptionSupport.create(ex);
        }
        if (this.failureCause != null) {
            if (this.channel != null) {
                this.channel.close().syncUninterruptibly();
                this.channel = null;
            }
            throw this.failureCause;
        }
        this.channel.eventLoop().execute(() -> {
            if (this.failureCause != null) {
                this.channel.pipeline().fireExceptionCaught((Throwable)this.failureCause);
            }
        });
        return this.group;
    }

    @Override
    public boolean isConnected() {
        return this.connected.get();
    }

    @Override
    public boolean isSecure() {
        return this.secure;
    }

    @Override
    public void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            this.connected.set(false);
            try {
                if (this.channel != null) {
                    this.channel.close().syncUninterruptibly();
                }
            }
            finally {
                Future fut;
                if (this.group != null && !(fut = this.group.shutdownGracefully(0L, 50L, TimeUnit.MILLISECONDS)).awaitUninterruptibly(100L)) {
                    LOG.trace("Channel group shutdown failed to complete in allotted time");
                }
            }
        }
    }

    @Override
    public ByteBuf allocateSendBuffer(int size) throws IOException {
        this.checkConnected();
        return this.channel.alloc().ioBuffer(size, size);
    }

    @Override
    public void write(ByteBuf output) throws IOException {
        this.checkConnected(output);
        LOG.trace("Attempted write of: {} bytes", (Object)output.readableBytes());
        this.channel.write((Object)output, this.channel.voidPromise());
    }

    @Override
    public void writeAndFlush(ByteBuf output) throws IOException {
        this.checkConnected(output);
        LOG.trace("Attempted write and flush of: {} bytes", (Object)output.readableBytes());
        this.channel.writeAndFlush((Object)output, this.channel.voidPromise());
    }

    @Override
    public void flush() throws IOException {
        this.checkConnected();
        LOG.trace("Attempted flush of pending writes");
        this.channel.flush();
    }

    @Override
    public TransportListener getTransportListener() {
        return this.listener;
    }

    @Override
    public void setTransportListener(TransportListener listener) {
        this.listener = listener;
    }

    @Override
    public TransportOptions getTransportOptions() {
        return this.options;
    }

    @Override
    public URI getRemoteLocation() {
        return this.remote;
    }

    @Override
    public Principal getLocalPrincipal() {
        Principal result = null;
        if (this.isSecure()) {
            SslHandler sslHandler = (SslHandler)this.channel.pipeline().get(SslHandler.class);
            result = sslHandler.engine().getSession().getLocalPrincipal();
        }
        return result;
    }

    @Override
    public void setMaxFrameSize(int maxFrameSize) {
        if (this.connected.get()) {
            throw new IllegalStateException("Cannot change Max Frame Size while connected.");
        }
        this.maxFrameSize = maxFrameSize;
    }

    @Override
    public int getMaxFrameSize() {
        return this.maxFrameSize;
    }

    @Override
    public ThreadFactory getThreadFactory() {
        return this.ioThreadfactory;
    }

    @Override
    public void setThreadFactory(ThreadFactory factory) {
        if (this.isConnected() || this.channel != null) {
            throw new IllegalStateException("Cannot set IO ThreadFactory after Transport connect");
        }
        this.ioThreadfactory = factory;
    }

    protected String getRemoteHost() {
        return this.remote.getHost();
    }

    protected int getRemotePort() {
        if (this.remote.getPort() != -1) {
            return this.remote.getPort();
        }
        return this.isSecure() ? this.getTransportOptions().getDefaultSslPort() : this.getTransportOptions().getDefaultTcpPort();
    }

    protected void addAdditionalHandlers(ChannelPipeline pipeline) {
    }

    protected ChannelInboundHandlerAdapter createChannelHandler() {
        return new NettyTcpTransportHandler();
    }

    protected void handleConnected(Channel channel) throws Exception {
        LOG.trace("Channel has become active! Channel is {}", (Object)channel);
        this.connectionEstablished(channel);
    }

    protected void handleChannelInactive(Channel channel) throws Exception {
        LOG.trace("Channel has gone inactive! Channel is {}", (Object)channel);
        if (this.connected.compareAndSet(true, false) && !this.closed.get()) {
            LOG.trace("Firing onTransportClosed listener");
            if (channel.eventLoop().inEventLoop()) {
                this.listener.onTransportClosed();
            } else {
                channel.eventLoop().execute(() -> this.listener.onTransportClosed());
            }
        } else if (!this.closed.get()) {
            if (this.failureCause == null) {
                this.failureCause = new IOException("Connection failed");
            }
            this.connectionFailed(channel, this.failureCause);
        }
    }

    protected void handleException(Channel channel, Throwable cause) {
        LOG.trace("Exception on channel! Channel is {}", (Object)channel);
        if (this.connected.compareAndSet(true, false) && !this.closed.get()) {
            LOG.trace("Firing onTransportError listener");
            if (channel.eventLoop().inEventLoop()) {
                if (this.failureCause != null) {
                    this.listener.onTransportError(this.failureCause);
                } else {
                    this.listener.onTransportError(cause);
                }
            } else {
                channel.eventLoop().execute(() -> {
                    if (this.failureCause != null) {
                        this.listener.onTransportError(this.failureCause);
                    } else {
                        this.listener.onTransportError(cause);
                    }
                });
            }
        } else {
            if (this.failureCause == null) {
                LOG.trace("Holding error until connect succeeds: {}", (Object)cause.getMessage());
                this.failureCause = IOExceptionSupport.create(cause);
            }
            this.connectionFailed(channel, this.failureCause);
        }
    }

    protected final void checkConnected() throws IOException {
        if (!this.connected.get() || !this.channel.isActive()) {
            throw new IOException("Cannot send to a non-connected transport.");
        }
    }

    private void checkConnected(ByteBuf output) throws IOException {
        if (!this.connected.get() || !this.channel.isActive()) {
            ReferenceCountUtil.release((Object)output);
            throw new IOException("Cannot send to a non-connected transport.");
        }
    }

    private void connectionEstablished(Channel connectedChannel) {
        this.channel = connectedChannel;
        this.connected.set(true);
        this.connectLatch.countDown();
    }

    private void connectionFailed(Channel failedChannel, IOException cause) {
        this.failureCause = cause;
        this.channel = failedChannel;
        this.connected.set(false);
        this.connectLatch.countDown();
    }

    private void configureNetty(Bootstrap bootstrap, TransportOptions options) {
        bootstrap.option(ChannelOption.TCP_NODELAY, (Object)options.isTcpNoDelay());
        bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)options.getConnectTimeout());
        bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)options.isTcpKeepAlive());
        bootstrap.option(ChannelOption.SO_LINGER, (Object)options.getSoLinger());
        if (options.getSendBufferSize() != -1) {
            bootstrap.option(ChannelOption.SO_SNDBUF, (Object)options.getSendBufferSize());
        }
        if (options.getReceiveBufferSize() != -1) {
            bootstrap.option(ChannelOption.SO_RCVBUF, (Object)options.getReceiveBufferSize());
            bootstrap.option(ChannelOption.RCVBUF_ALLOCATOR, (Object)new FixedRecvByteBufAllocator(options.getReceiveBufferSize()));
        }
        if (options.getTrafficClass() != -1) {
            bootstrap.option(ChannelOption.IP_TOS, (Object)options.getTrafficClass());
        }
        if (options.getLocalAddress() != null || options.getLocalPort() != 0) {
            if (options.getLocalAddress() != null) {
                bootstrap.localAddress(options.getLocalAddress(), options.getLocalPort());
            } else {
                bootstrap.localAddress(options.getLocalPort());
            }
        }
        if (options.getProxyHandlerSupplier() != null) {
            bootstrap.resolver((AddressResolverGroup)NoopAddressResolverGroup.INSTANCE);
        }
    }

    private void configureChannel(Channel channel) throws Exception {
        if (this.options.getProxyHandlerSupplier() != null) {
            Supplier proxyHandlerSupplier = this.options.getProxyHandlerSupplier();
            ProxyHandler proxyHandler = (ProxyHandler)proxyHandlerSupplier.get();
            Objects.requireNonNull(proxyHandler, "No proxy handler was returned by the supplier");
            channel.pipeline().addFirst(new ChannelHandler[]{proxyHandler});
        }
        if (this.isSecure()) {
            SslHandler sslHandler;
            try {
                sslHandler = TransportSupport.createSslHandler(channel.alloc(), this.getRemoteLocation(), this.getTransportOptions());
            }
            catch (Exception ex) {
                throw IOExceptionSupport.create(ex);
            }
            channel.pipeline().addLast("ssl", (ChannelHandler)sslHandler);
        }
        if (this.getTransportOptions().isTraceBytes()) {
            channel.pipeline().addLast("logger", (ChannelHandler)new LoggingHandler(this.getClass()));
        }
        this.addAdditionalHandlers(channel.pipeline());
        channel.pipeline().addLast(new ChannelHandler[]{this.createChannelHandler()});
    }

    protected class NettyTcpTransportHandler
    extends NettyDefaultHandler<ByteBuf> {
        protected NettyTcpTransportHandler() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, ByteBuf buffer) throws Exception {
            LOG.trace("New data read: {} bytes incomsing: {}", (Object)buffer.readableBytes(), (Object)buffer);
            if (NettyTcpTransport.this.channel.eventLoop().inEventLoop()) {
                NettyTcpTransport.this.listener.onData(buffer);
            } else {
                NettyTcpTransport.this.channel.eventLoop().execute(() -> NettyTcpTransport.this.listener.onData(buffer));
            }
        }
    }

    protected abstract class NettyDefaultHandler<E>
    extends SimpleChannelInboundHandler<E> {
        protected NettyDefaultHandler() {
        }

        public void channelRegistered(ChannelHandlerContext context) throws Exception {
            NettyTcpTransport.this.channel = context.channel();
        }

        public void channelActive(ChannelHandlerContext context) throws Exception {
            if (!NettyTcpTransport.this.isSecure()) {
                NettyTcpTransport.this.handleConnected(context.channel());
            } else {
                SslHandler sslHandler = (SslHandler)context.pipeline().get(SslHandler.class);
                sslHandler.handshakeFuture().addListener((GenericFutureListener)new GenericFutureListener<Future<Channel>>(){

                    public void operationComplete(Future<Channel> future) throws Exception {
                        if (future.isSuccess()) {
                            LOG.trace("SSL Handshake has completed: {}", (Object)NettyTcpTransport.this.channel);
                            NettyTcpTransport.this.handleConnected(NettyTcpTransport.this.channel);
                        } else {
                            LOG.trace("SSL Handshake has failed: {}", (Object)NettyTcpTransport.this.channel);
                            NettyTcpTransport.this.handleException(NettyTcpTransport.this.channel, future.cause());
                        }
                    }
                });
            }
        }

        public void channelInactive(ChannelHandlerContext context) throws Exception {
            NettyTcpTransport.this.handleChannelInactive(context.channel());
        }

        public void exceptionCaught(ChannelHandlerContext context, Throwable cause) throws Exception {
            NettyTcpTransport.this.handleException(context.channel(), cause);
        }
    }
}

