/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms;

import javax.jms.JMSException;
import org.apache.qpid.jms.JmsConnection;
import org.apache.qpid.jms.JmsDestination;
import org.apache.qpid.jms.meta.JmsResource;
import org.apache.qpid.jms.meta.JmsResourceVistor;

public abstract class JmsTemporaryDestination
extends JmsDestination
implements JmsResource {
    private boolean deleted;

    public JmsTemporaryDestination() {
        this(null, false);
    }

    public JmsTemporaryDestination(String name, boolean topic) {
        super(name, topic, true);
    }

    void setConnection(JmsConnection connection) {
        this.connection = connection;
    }

    JmsConnection getConnection() {
        return this.connection;
    }

    protected void tryDelete() throws JMSException {
        if (this.connection != null) {
            this.connection.deleteTemporaryDestination(this);
        }
        this.deleted = true;
    }

    protected boolean isDeleted() throws JMSException {
        boolean result = this.deleted;
        if (!result && this.connection != null) {
            result = this.connection.isTemporaryDestinationDeleted(this);
        }
        return result;
    }

    @Override
    public void visit(JmsResourceVistor visitor) throws Exception {
        visitor.processDestination(this);
    }
}

