/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp;

import java.io.IOException;
import java.util.Map;
import javax.jms.InvalidClientIDException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import org.apache.qpid.jms.meta.JmsConnectionInfo;
import org.apache.qpid.jms.meta.JmsResource;
import org.apache.qpid.jms.provider.AsyncResult;
import org.apache.qpid.jms.provider.ProviderRedirectedException;
import org.apache.qpid.jms.provider.amqp.AmqpProvider;
import org.apache.qpid.jms.provider.amqp.AmqpResource;
import org.apache.qpid.jms.provider.amqp.AmqpSupport;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.transport.AmqpError;
import org.apache.qpid.proton.amqp.transport.ConnectionError;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.Endpoint;
import org.apache.qpid.proton.engine.EndpointState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AmqpAbstractResource<R extends JmsResource, E extends Endpoint>
implements AmqpResource {
    private static final Logger LOG = LoggerFactory.getLogger(AmqpAbstractResource.class);
    protected AsyncResult openRequest;
    protected AsyncResult closeRequest;
    private E endpoint;
    protected R resource;

    public AmqpAbstractResource(R resource) {
        this(resource, null);
    }

    public AmqpAbstractResource(R resource, E endpoint) {
        this.resource = resource;
        this.setEndpoint(endpoint);
    }

    @Override
    public void open(AsyncResult request) {
        this.openRequest = request;
        this.doOpen();
        this.getEndpoint().setContext((Object)this);
    }

    @Override
    public boolean isOpen() {
        return this.getEndpoint().getRemoteState() == EndpointState.ACTIVE;
    }

    @Override
    public boolean isAwaitingOpen() {
        return this.openRequest != null;
    }

    @Override
    public void opened() {
        if (this.openRequest != null) {
            this.openRequest.onSuccess();
            this.openRequest = null;
        }
    }

    @Override
    public void close(AsyncResult request) {
        if (this.getEndpoint().getLocalState() == EndpointState.CLOSED || this.getEndpoint().getRemoteState() == EndpointState.CLOSED) {
            if (this.getEndpoint().getLocalState() != EndpointState.CLOSED) {
                this.doClose();
                this.getEndpoint().free();
            }
            request.onSuccess();
            return;
        }
        this.closeRequest = request;
        this.doClose();
    }

    @Override
    public boolean isClosed() {
        return this.getEndpoint().getLocalState() == EndpointState.CLOSED;
    }

    @Override
    public boolean isAwaitingClose() {
        return this.closeRequest != null;
    }

    @Override
    public void closed() {
        this.endpoint.close();
        this.endpoint.free();
        if (this.closeRequest != null) {
            this.closeRequest.onSuccess();
            this.closeRequest = null;
        }
    }

    @Override
    public void failed(Exception cause) {
        if (this.openRequest != null) {
            if (this.endpoint != null) {
                this.endpoint.close();
            }
            this.openRequest.onFailure(cause);
            this.openRequest = null;
        }
        if (this.closeRequest != null) {
            this.closeRequest.onFailure(cause);
            this.closeRequest = null;
        }
    }

    @Override
    public void remotelyClosed(AmqpProvider provider) {
        Exception error = this.getRemoteError();
        if (error == null) {
            error = new IOException("Remote has closed without error information");
        }
        if (this.endpoint != null) {
            this.endpoint.close();
        }
        LOG.info("Resource {} was remotely closed", this.getJmsResource());
        if (this.getJmsResource() instanceof JmsConnectionInfo) {
            provider.fireProviderException(error);
        } else {
            provider.fireResourceRemotelyClosed((JmsResource)this.getJmsResource(), error);
        }
    }

    public E getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(E endpoint) {
        this.endpoint = endpoint;
    }

    public R getJmsResource() {
        return this.resource;
    }

    public EndpointState getLocalState() {
        if (this.getEndpoint() == null) {
            return EndpointState.UNINITIALIZED;
        }
        return this.getEndpoint().getLocalState();
    }

    public EndpointState getRemoteState() {
        if (this.getEndpoint() == null) {
            return EndpointState.UNINITIALIZED;
        }
        return this.getEndpoint().getRemoteState();
    }

    @Override
    public boolean hasRemoteError() {
        return this.getEndpoint().getRemoteCondition().getCondition() != null;
    }

    @Override
    public Exception getRemoteError() {
        return this.getRemoteError(this.getEndpoint().getRemoteCondition());
    }

    @Override
    public Exception getRemoteError(ErrorCondition errorCondition) {
        Object remoteError = null;
        Symbol error = errorCondition.getCondition();
        if (error != null) {
            Map info;
            String message = this.getRemoteErrorMessage(errorCondition);
            remoteError = error.equals(AmqpError.UNAUTHORIZED_ACCESS) ? new JMSSecurityException(message) : (error.equals(AmqpError.NOT_FOUND) ? new InvalidDestinationException(message) : (error.equals(ConnectionError.REDIRECT) ? this.createRedirectException(error, message, errorCondition) : (error.equals(AmqpError.INVALID_FIELD) ? ((info = errorCondition.getInfo()) != null && AmqpSupport.CONTAINER_ID.equals(info.get(AmqpSupport.INVALID_FIELD)) ? new InvalidClientIDException(message) : new JMSException(message)) : new JMSException(message))));
        }
        return remoteError;
    }

    @Override
    public String getRemoteErrorMessage(ErrorCondition errorCondition) {
        String message = "Received error from remote peer without description";
        if (errorCondition != null) {
            Symbol condition;
            if (errorCondition.getDescription() != null && !errorCondition.getDescription().isEmpty()) {
                message = errorCondition.getDescription();
            }
            if ((condition = errorCondition.getCondition()) != null) {
                message = message + " [condition = " + condition + "]";
            }
        }
        return message;
    }

    @Override
    public void processRemoteOpen(AmqpProvider provider) throws IOException {
        this.doOpenCompletion();
    }

    @Override
    public void processRemoteDetach(AmqpProvider provider) throws IOException {
        if (this.isAwaitingClose()) {
            LOG.debug("{} is now closed: ", (Object)this);
            this.closed();
        } else {
            this.remotelyClosed(provider);
        }
    }

    @Override
    public void processRemoteClose(AmqpProvider provider) throws IOException {
        if (this.isAwaitingClose()) {
            LOG.debug("{} is now closed: ", (Object)this);
            this.closed();
        } else if (this.isAwaitingOpen()) {
            LOG.warn("Open of {} failed: ", (Object)this);
            Exception openError = this.hasRemoteError() ? this.getRemoteError() : this.getOpenAbortException();
            this.failed(openError);
        } else {
            this.remotelyClosed(provider);
        }
    }

    @Override
    public void processDeliveryUpdates(AmqpProvider provider) throws IOException {
    }

    @Override
    public void processFlowUpdates(AmqpProvider provider) throws IOException {
    }

    protected void doOpen() {
        this.getEndpoint().open();
    }

    protected void doOpenCompletion() {
        LOG.debug("{} is now open: ", (Object)this);
        this.opened();
    }

    protected Exception createRedirectException(Symbol error, String message, ErrorCondition condition) {
        IOException result = null;
        Map info = condition.getInfo();
        if (info == null) {
            result = new IOException(message + " : Redirection information not set.");
        } else {
            String hostname = (String)info.get(AmqpSupport.OPEN_HOSTNAME);
            String networkHost = (String)info.get(AmqpSupport.NETWORK_HOST);
            if (networkHost == null || networkHost.isEmpty()) {
                result = new IOException(message + " : Redirection information not set.");
            }
            int port = 0;
            try {
                port = Integer.valueOf(info.get(AmqpSupport.PORT).toString());
            }
            catch (Exception ex) {
                result = new IOException(message + " : Redirection information not set.");
            }
            result = new ProviderRedirectedException(message, hostname, networkHost, port);
        }
        return result;
    }

    protected Exception getOpenAbortException() {
        return new IOException("Open failed unexpectedly.");
    }

    protected void doClose() {
        this.getEndpoint().close();
    }
}

