/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp.builders;

import org.apache.qpid.jms.meta.JmsSessionInfo;
import org.apache.qpid.jms.provider.AsyncResult;
import org.apache.qpid.jms.provider.amqp.AmqpConnection;
import org.apache.qpid.jms.provider.amqp.AmqpSession;
import org.apache.qpid.jms.provider.amqp.builders.AmqpResourceBuilder;
import org.apache.qpid.jms.provider.amqp.builders.AmqpTransactionContextBuilder;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.Session;

public class AmqpSessionBuilder
extends AmqpResourceBuilder<AmqpSession, AmqpConnection, JmsSessionInfo, Session> {
    public AmqpSessionBuilder(AmqpConnection parent, JmsSessionInfo resourceInfo) {
        super(parent, resourceInfo);
    }

    @Override
    public void buildResource(final AsyncResult request) {
        AsyncResult opened = request;
        if (((JmsSessionInfo)this.getResourceInfo()).isTransacted()) {
            opened = new AsyncResult(){

                @Override
                public void onSuccess() {
                    AmqpTransactionContextBuilder builder = new AmqpTransactionContextBuilder((AmqpSession)AmqpSessionBuilder.this.getResource(), (JmsSessionInfo)AmqpSessionBuilder.this.getResourceInfo());
                    builder.buildResource(request);
                }

                @Override
                public void onFailure(Throwable result) {
                    request.onFailure(result);
                }

                @Override
                public boolean isComplete() {
                    return request.isComplete();
                }
            };
        }
        super.buildResource(opened);
    }

    @Override
    protected Session createEndpoint(JmsSessionInfo resourceInfo) {
        long outgoingWindow = ((AmqpConnection)this.getParent()).getProvider().getSessionOutgoingWindow();
        Session session = ((Connection)((AmqpConnection)this.getParent()).getEndpoint()).session();
        session.setIncomingCapacity(Integer.MAX_VALUE);
        if (outgoingWindow >= 0L) {
            session.setOutgoingWindow(outgoingWindow);
        }
        return session;
    }

    @Override
    protected AmqpSession createResource(AmqpConnection parent, JmsSessionInfo resourceInfo, Session endpoint) {
        return new AmqpSession(parent, resourceInfo, endpoint);
    }

    @Override
    protected boolean isClosePending() {
        return false;
    }
}

